

<?php $__env->startSection('styles'); ?>
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title">
                <h3 class="card-label">
                    ব্যবহারকারীর তালিকা ( User List )
                </h3>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered nowrap" id="kt_datatable_em">
                <thead class="thead-light">
                <tr>
                    <th>নাম (Name)</th>
                    <th>পদবী (Rank)</th>
                    <th>মোবাইল নাম্বার (Contact Number)</th>
                    <th>ইমেইল (Email)</th>
                    <th>গ্রুপ (Group)</th>
                    <th>Status</th>
                    <th>Action</th>


                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($user->name); ?></td>
                        <td><?php echo e($user->rank); ?></td>
                        <td><?php echo e($user->contact); ?></td>
                        <td><?php echo e($user->email); ?></td>
                        <td><?php echo e($user->useraccess->user_group->name); ?></td>
                        <td><?php if($user->useraccess->active == 1): ?><span class="badge badge-success">Active</span><?php else: ?><span class="badge badge-danger">Disabled</span><?php endif; ?></td>
                        <td>
                            <a href="<?php echo e(route('manage_user.edit',['id'=>$user->id])); ?>" class="btn btn-outline-primary text-primary mr-5" role="button" ><i class="fa fa-edit"></i></a>
                            <a href="<?php echo e(route('manage_user.delete',['id'=>$user->id])); ?>" onclick="return confirm('Are you sure ?');" class="btn btn-outline-danger text-danger mr-5" role="button" ><i class="fa fa-trash"></i></a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>

            </table>
            <script>
                $(document).ready(function() {
                    var table = $('#kt_datatable_em');
                    table.DataTable({
                        responsive: true,

                    });
                });
            </script>
        </div>
    </div>
    <!--end::Card-->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <!--begin::Page Vendors(used by this page)-->
    <script src="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
    <!--end::Page Vendors-->

    <!--begin::Page Scripts(used by this page)-->
    <script src="<?php echo e(asset('js/pages/crud/datatables/data-sources/html.js')); ?>"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/landport/web/pims.aqualinkbd.com/public_html/resources/views/admin/user/index.blade.php ENDPATH**/ ?>