<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.css')); ?>" rel="stylesheet" type="text/css"/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <!--begin::Profile Personal Information-->
    <div class="d-flex flex-row">
        <?php echo $__env->make("admin.employee.aside_nav", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!--begin::Content-->
        <div class="flex-row-fluid ml-lg-8">
            <!--begin::Card-->
            <div class="card card-custom card-stretch">
                <!--begin::Header-->
                <div class="card-header py-3">
                    <div class="card-title align-items-start flex-column">
                        <h3 class="card-label font-weight-bolder text-dark">১০। বিশ্রাম এবং বিনোদন (Rest and Recreation)</h3>
                        <span class="text-muted font-weight-bold font-size-sm mt-1">Update your information</span>
                    </div>
                </div>
                <div class="card-header py-3">

                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#rest_creat_update">
                        Add new/Create
                    </button>
                </div>
                <div class="card-body">
                    <table class="table table-bordered nowrap" id="kt_datatable_ym">
                        <thead>
                        <tr>
                            <th>From</th>
                            <th>To</th>
                            <th>Sanction Date</th>
                            <th>Sanction Number</th>
                            <th>Action</th>
                        </tr>
                        </thead>

                        <tbody>
                        <?php ($n=0); ?>
                        <?php $__currentLoopData = $employee->rest_and_recreation; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr  <?php if(\Carbon\Carbon::parse($rest->from_date) > \Carbon\Carbon::today()): ?> style="background: #c1d7e3;" <?php endif; ?> class="rest_<?php echo e($rest->id); ?>">

                                <td><?php echo e($rest->from_date); ?></td>
                                <td><?php echo e($rest->to_date); ?></td>
                                <td><?php echo e($rest->sanction_date); ?></td>
                                <td><?php echo e($rest->sanction_number); ?></td>
                                <td>
                                    <button type="button" class="btn btn-primary rest_update" data-toggle="modal" data-target="#rest_creat_update" data="<?php echo e($rest->id); ?>">
                                        Edit
                                    </button>
                                    <a href="#" onclick="return confirm('Are your sure ?');" class="btn btn-danger rest_delete" data="<?php echo e($rest->id); ?>">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <div class="modal fade" id="rest_creat_update" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLongTitle">New Rest and recreation ( শ্রান্তি বিনোদন )</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="rest_add_body">
                                        <?php echo $__env->make('admin.employee.extra_partial_page.rest_recreation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </table>
                    <!--end: Datatable-->
                    <script>
                        $(document).ready(function() {
                            var table = $('#kt_datatable_ym');
                            table.DataTable({
                                responsive: true,

                            });

                            $(document).on('click', '.rest_update', function(event){
                                var id = $(this).attr('data');
                                jQuery.ajax({
                                    url: "<?php echo e(route('employee.rest_recreations.create',['id'=>$employee->id])); ?>?did="+id,
                                    method: 'get',
                                    success: function(result){
                                        $('.rest_add_body').html(result);
                                    }
                                });
                            });
                            $(document).on('click', '.rest_delete', function(event){
                                var id = $(this).attr('data');
                                jQuery.ajax({
                                    url: "<?php echo e(route('employee.rest_recreations.create',['id'=>$employee->id])); ?>?delete_id="+id,
                                    method: 'get',
                                    success: function(result){
                                        if(result == 'success'){
                                            $('.rest_'+id).remove();
                                        }

                                    }
                                });
                            });
                        });
                    </script>


                </div>
            </div>
        </div>
        <!--end::Content-->
    </div>
    <!--end::Profile Personal Information-->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('js/pages/widgets.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('js/pages/custom/profile/profile.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            var loan = $('.loan_count').length;
            $(document).on('click', '.loan_add', function(event){
                loan++;
                jQuery.ajax({
                    url: "<?php echo e(route('ajaxcall.loan_add')); ?>?v="+loan,
                    method: 'get',
                    success: function(result){
                        $('.loan_add_body').append(result);
                    }
                });
            });
            $(document).on('click', '.remove_this', function(event){
                var id = $(this).attr('data');
                $(this).parent().parent().remove();
                var ddd = $('#removedata').attr('value');
                $('#removedata').attr('value', ddd +','+id)
            });

        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/landport/web/pims.aqualinkbd.com/public_html/resources/views/admin/employee/rest_and_recreation.blade.php ENDPATH**/ ?>