<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-lg-6">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        No of employee per rank
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="chart_rank"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
    <div class="col-lg-6">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        Employee % by rank
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="rankpiechart" class="d-flex justify-content-center"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
    <div class="col-lg-6">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        No of employee on Working place
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="current_working_place" class="d-flex justify-content-center"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
    <div class="col-lg-6">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        Employee % by Gender
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="genderpiechart" class="d-flex justify-content-center"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
    <div class="col-lg-6">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        Employee % by Religion
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="regionpiechart" class="d-flex justify-content-center"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
    <div class="col-lg-6">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        Employee % by Marital status
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="marital_status_piechart" class="d-flex justify-content-center"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
    <div class="col-lg-12">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        Employee Service Status ( Joining, Promotion and transfer )
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="service_status" class="d-flex justify-content-center"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
    <div class="col-lg-12">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        Employee PRL, Rest and Recreation
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="prl_rest" class="d-flex justify-content-center"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script>
        "use strict";

        // Shared Colors Definition
        const primary = '#6993FF';
        const success = '#1BC5BD';
        const info = '#8950FC';
        const warning = '#FFA800';
        const danger = '#F64E60';

        // Class definition
        function generateBubbleData(baseval, count, yrange) {
            var i = 0;
            var series = [];
            while (i < count) {
                var x = Math.floor(Math.random() * (750 - 1 + 1)) + 1;;
                var y = Math.floor(Math.random() * (yrange.max - yrange.min + 1)) + yrange.min;
                var z = Math.floor(Math.random() * (75 - 15 + 1)) + 15;

                series.push([x, y, z]);
                baseval += 86400000;
                i++;
            }
            return series;
        }

        function generateData(count, yrange) {
            var i = 0;
            var series = [];
            while (i < count) {
                var x = 'w' + (i + 1).toString();
                var y = Math.floor(Math.random() * (yrange.max - yrange.min + 1)) + yrange.min;

                series.push({
                    x: x,
                    y: y
                });
                i++;
            }
            return series;
        }
        var rank_data = [];
        var rank_category = [];
        <?php $__currentLoopData = $employees->groupBy('rank'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$rank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if((int)$key > 0): ?>rank_data.push(<?php echo e(count($rank)); ?>);rank_category.push('<?php echo e($function->rank()[$key]['name_bn']); ?>');<?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        var gender_data = [];
        var gender_category = [];
        <?php $__currentLoopData = $personalinfo->groupBy('gender'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if((int)$key > 0): ?>gender_data.push(<?php echo e(count($group)); ?>);gender_category.push('<?php echo e($function->gender()[$key][0]); ?>');<?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        var region_data = [];
        var region_category = [];
        <?php $__currentLoopData = $personalinfo->groupBy('region'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if((int)$key > 0): ?>region_data.push(<?php echo e(count($group)); ?>);region_category.push('<?php echo e($function->religion()[$key][0]); ?>');<?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        var marital_status_data = [];
        var marital_status_category = [];
        <?php $__currentLoopData = $personalinfo->groupBy('marital_status'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if((int)$key > 0): ?>marital_status_data.push(<?php echo e(count($group)); ?>);marital_status_category.push('<?php echo e($function->marital_status()[$key][0]); ?>');<?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        var KTApexChartsDemo = function () {

            var rankchart = function () {

                const apexChart = "#chart_rank";
                var options = {
                    series: [{
                        name: 'Number',
                        data: rank_data
                    }],
                    chart: {
                        type: 'bar',
                        height: 350
                    },
                    plotOptions: {
                        bar: {
                            horizontal: false,
                            columnWidth: '55%',
                            endingShape: 'rounded'
                        },
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        show: true,
                        width: 2,
                        colors: ['transparent']
                    },
                    xaxis: {
                        categories: rank_category,
                    },
                    yaxis: {
                        title: {
                            text: 'Number'
                        }
                    },
                    fill: {
                        opacity: 1
                    },
                    tooltip: {
                        y: {
                            formatter: function (val) {
                                return " " + val + " "
                            }
                        }
                    },
                    colors: [primary, success, warning]
                };

                var chart = new ApexCharts(document.querySelector(apexChart), options);
                chart.render();
            };
            var rankpiechart = function () {
                const apexChart = "#rankpiechart";
                var options = {
                    series: rank_data,
                    chart: {
                        width: 600,
                        type: 'pie',
                    },
                    labels: rank_category,
                    responsive: [{
                        breakpoint: 480,
                        options: {
                            chart: {
                                width: 200
                            },
                            legend: {
                                position: 'bottom'
                            }
                        }
                    }],
                    colors: [primary, success, warning, danger, info]
                };

                var chart = new ApexCharts(document.querySelector(apexChart), options);
                chart.render();
            };
            var genderpiechart = function () {
                const apexChart = "#genderpiechart";
                var options = {
                    series: gender_data,
                    chart: {
                        width: 400,
                        type: 'pie',
                    },
                    labels: gender_category,
                    responsive: [{
                        breakpoint: 480,
                        options: {
                            chart: {
                                width: 200
                            },
                            legend: {
                                position: 'bottom'
                            }
                        }
                    }],
                    colors: [primary, success, warning, danger, info]
                };

                var chart = new ApexCharts(document.querySelector(apexChart), options);
                chart.render();
            };
            var regionpiechart = function () {
                const apexChart = "#regionpiechart";
                var options = {
                    series: region_data,
                    chart: {
                        width: 400,
                        type: 'pie',
                    },
                    labels: region_category,
                    responsive: [{
                        breakpoint: 480,
                        options: {
                            chart: {
                                width: 200
                            },
                            legend: {
                                position: 'bottom'
                            }
                        }
                    }],
                    colors: [primary, success, warning, danger, info]
                };

                var chart = new ApexCharts(document.querySelector(apexChart), options);
                chart.render();
            };
                var marital_status_piechart = function () {
                    const apexChart = "#marital_status_piechart";
                    var options = {
                        series: marital_status_data,
                        chart: {
                            width: 400,
                            type: 'pie',
                        },
                        labels: marital_status_category,
                        responsive: [{
                            breakpoint: 480,
                            options: {
                                chart: {
                                    width: 200
                                },
                                legend: {
                                    position: 'bottom'
                                }
                            }
                        }],
                        colors: [primary, success, warning, danger, info]
                    };

                    var chart = new ApexCharts(document.querySelector(apexChart), options);
                    chart.render();
                };
                var monthspast = [];
                <?php $__currentLoopData = $monthpast; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                monthspast.push('<?php echo e($month); ?>');
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            var service_status = function () {
                const apexChart = "#service_status";
                var options = {
                    series: [{
                        name: 'First Join',
                        data: [<?php echo e(implode(',',$firstjoins)); ?>]
                    },{
                        name: 'Promotions',
                        data: [<?php echo e(implode(',',$promotions)); ?>]
                    },{
                        name: 'Transfer',
                        data: [<?php echo e(implode(',',$transfers)); ?>]
                    }
                    ],
                    chart: {
                        type: 'bar',
                        height: 350
                    },
                    plotOptions: {
                        bar: {
                            horizontal: false,
                            columnWidth: '55%',
                            endingShape: 'rounded'
                        },
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        show: true,
                        width: 2,
                        colors: ['transparent']
                    },
                    xaxis: {
                        categories:  monthspast,
                    },
                    yaxis: {
                        title: {
                            text: 'Number'
                        }
                    },
                    fill: {
                        opacity: 1
                    },
                    tooltip: {
                        y: {
                            formatter: function (val) {
                                return " " + val + " "
                            }
                        }
                    },
                    colors: [primary, success, warning]
                };

                var chart = new ApexCharts(document.querySelector(apexChart), options);
                chart.render();
            };
            var monthsfuture = [];
            <?php $__currentLoopData = $monthfuture; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            monthsfuture.push('<?php echo e($month); ?>');
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            var prl_rest = function () {
                const apexChart = "#prl_rest";
                var options = {
                    series: [{
                        name: 'PRL',
                        data: [<?php echo e(implode(',',$prls)); ?>]
                    },{
                        name: 'Rest and Recreation',
                        data: [<?php echo e(implode(',',$rest_recreations)); ?>]
                    }
                    ],
                    chart: {
                        type: 'bar',
                        height: 350
                    },
                    plotOptions: {
                        bar: {
                            horizontal: false,
                            columnWidth: '55%',
                            endingShape: 'rounded'
                        },
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        show: true,
                        width: 2,
                        colors: ['transparent']
                    },
                    xaxis: {
                        categories:  monthsfuture,
                    },
                    yaxis: {
                        title: {
                            text: 'Number'
                        }
                    },
                    fill: {
                        opacity: 1
                    },
                    tooltip: {
                        y: {
                            formatter: function (val) {
                                return " " + val + " "
                            }
                        }
                    },
                    colors: [primary, success, warning]
                };

                var chart = new ApexCharts(document.querySelector(apexChart), options);
                chart.render();
            };
            var landport = [];
           <?php ($landportdata=[]); ?>
            <?php $__currentLoopData = $function->name_of_all_landport(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            landport.push('<?php echo e($name[0]); ?>');
                <?php if(isset($employee_on_working_place[$key])): ?><?php (array_push($landportdata,$employee_on_working_place[$key])); ?> <?php else: ?> <?php (array_push($landportdata,0)); ?><?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            var current_working_place = function () {
                const apexChart = "#current_working_place";
                var options = {
                    series: [{
                        name: 'Employee',
                        data: [<?php echo e(implode(',',$landportdata)); ?>]
                    }
                    ],
                    chart: {
                        type: 'bar',
                        height: 350
                    },
                    plotOptions: {
                        bar: {
                            horizontal: false,
                            columnWidth: '55%',
                            endingShape: 'rounded'
                        },
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        show: true,
                        width: 2,
                        colors: ['transparent']
                    },
                    xaxis: {
                        categories:  landport,
                    },
                    yaxis: {
                        title: {
                            text: 'Number'
                        }
                    },
                    fill: {
                        opacity: 1
                    },
                    tooltip: {
                        y: {
                            formatter: function (val) {
                                return " " + val + " "
                            }
                        }
                    },
                    colors: [primary, success, warning]
                };

                var chart = new ApexCharts(document.querySelector(apexChart), options);
                chart.render();
            };
        // Private functions
            return {
                // public functions
                init: function () {
                    rankchart();
                    rankpiechart();
                    genderpiechart();
                    regionpiechart();
                    marital_status_piechart();
                    service_status();
                    prl_rest();
                    current_working_place();
                }
            };
        }();

        jQuery(document).ready(function () {
            KTApexChartsDemo.init();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/landport/web/pims.aqualinkbd.com/public_html/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>