<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.css')); ?>" rel="stylesheet" type="text/css"/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <!--begin::Profile Personal Information-->
    <div class="d-flex flex-row">
        <?php echo $__env->make("admin.employee.aside_nav", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!--begin::Content-->
        <div class="flex-row-fluid ml-lg-8">
            <!--begin::Card-->
            <div class="card card-custom card-stretch">
                <!--begin::Header-->
                <div class="card-header py-3">
                    <div class="card-title align-items-start flex-column">
                        <h3 class="card-label font-weight-bolder text-dark">Change Log</h3>
                    </div>
                </div>
                <div class="card-body">
                    <table class="table table-bordered nowrap" id="kt_datatable_ym">
                        <thead>
                        <tr>
                            <th>Date</th>
                            <th>Data Type</th>
                            <th>From</th>
                            <th>To</th>
                            <th>Action Type</th>
                            <th>Changed By</th>

                        </tr>
                        </thead>

                        <tbody>
                        <?php $__currentLoopData = $employee->record_changelog; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(\Carbon\Carbon::parse($log->created_at)->format('d F,Y h:i')); ?></td>
                                <td><?php echo e($log->name); ?></td>
                                <td><?php echo e($log->old); ?></td>
                                <td><?php echo e($log->new); ?></td>
                                <td><?php if($log->record_type == 1): ?> New Record <?php elseif($log->record_type == 3): ?> Deleted <?php else: ?> Updated <?php endif; ?></td>
                                <td><?php echo e($log->user->name); ?></td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        
                        
                        
                        

                    </table>
                    <!--end: Datatable-->
                    <script>
                        $(document).ready(function() {
                            var table = $('#kt_datatable_ym');
                            table.DataTable({
                                responsive: true,
                                pageLength : 50

                            });
                        });
                    </script>


                </div>
            </div>
        </div>
        <!--end::Content-->
    </div>
    <!--end::Profile Personal Information-->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('js/pages/widgets.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('js/pages/custom/profile/profile.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            var loan = $('.loan_count').length;
            $(document).on('click', '.loan_add', function(event){
                loan++;
                jQuery.ajax({
                    url: "<?php echo e(route('ajaxcall.loan_add')); ?>?v="+loan,
                    method: 'get',
                    success: function(result){
                        $('.loan_add_body').append(result);
                    }
                });
            });
            $(document).on('click', '.remove_this', function(event){
                var id = $(this).attr('data');
                $(this).parent().parent().remove();
                var ddd = $('#removedata').attr('value');
                $('#removedata').attr('value', ddd +','+id)
            });

        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/landport/web/pims.aqualinkbd.com/public_html/resources/views/admin/employee/log.blade.php ENDPATH**/ ?>