



<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">
    <div class="card-header flex-wrap py-3">
        <div class="card-title">
            <h3 class="card-label">
                Employee Information Change Log
            </h3>
        </div>
    </div>
    <div class="card-body" id="employee_list">
        <table class="table table-bordered nowrap" id="kt_datatable_em">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Data Type</th>
                    <th>From</th>
                    <th>To</th>
                    <th>Action Type</th>
                    <th>Changed By</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $employee; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $emp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $__currentLoopData = $emp->record_changelog; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(\Carbon\Carbon::parse($log->created_at)->format('d F,Y h:i')); ?></td>
                            <td><?php echo e($log->name); ?></td>
                            <td><?php echo e($log->old); ?></td>
                            <td><?php echo e($log->new); ?></td>
                            <td><?php if($log->record_type == 1): ?> New Record <?php elseif($log->record_type == 3): ?> Deleted <?php else: ?> Updated <?php endif; ?></td>
                            <td><?php echo e($log->user->name); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<!--end: Datatable-->



<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.js')); ?>" type="text/javascript"></script>
<script>
    $(document).ready(function() {
        var table = $('#kt_datatable_em');
        table.DataTable({
            responsive: true,

        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/landport/web/pims.aqualinkbd.com/public_html/resources/views/admin/employee/infochangelog.blade.php ENDPATH**/ ?>