<?php $__env->startSection('styles'); ?>
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!--begin::Entry-->
    <div class="d-flex flex-column-fluid">
        <!--begin::Container-->
        <div class=" container ">
            <!--begin::Card-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-3">
                    <div class="card-title">
                        <h3 class="card-label">
                           <?php if(isset($thana->id)): ?><?php echo e($thana->name_en); ?> all <?php endif; ?> Thana List
                        </h3>

                        <a style="position:absolute;right:0;margin-right:2%;" type="button"  class="btn btn-info " href="<?php echo e(route('thana.add')); ?>">Add new Thana</a>
                    </div>
                </div>
                <div class="card-body">
                    <!--begin: Datatable-->
                    <table class="table table-bordered table-checkable text-center" id="kt_datatable_user_group">
                        <thead>
                        <tr>
                            <th>Thana</th>
                            <th>Thana (বাংলা)</th>
                            <th>Zone</th>
                            <th>Action</th>

                        </tr>
                        </thead>

                        <tbody>
                        <?php $__currentLoopData = $thanas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th><?php echo e($department->name_en); ?></th>
                                <th><?php echo e($department->name_bn); ?></th>
                                <th><?php echo e($department->zone->name_bn); ?></th>

                                <th>
                                    <a href="<?php echo e(route('thana.edit',['id'=>$department->id])); ?>" class="ml-2 mr-2"> <i class="fa fa-edit text-primary"></i></a>
                                    <a href="<?php echo e(route('thana.delete',['id'=>$department->id])); ?>" class="ml-2 mr-2"> <i class="fa fa-trash text-danger"></i></a>
                                </th>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                    <!--end: Datatable-->
                </div>
            </div>

        </div>
        <!--end::Container-->
    </div>
    <!--end::Entry-->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <!--begin::Page Vendors(used by this page)-->
    <script src="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
    <!--end::Page Vendors-->

    <!--begin::Page Scripts(used by this page)-->
    
    <script src="<?php echo e(asset('js/script.js')); ?>"></script>
    <script>
        var KTDatatablesDataSourceHtml = function() {

            var initTable1 = function() {
                var table = $('#kt_datatable_user_group');

                // begin first table
                table.DataTable({
                    dom: "<'row'<'col-sm-12 col-md-3'l><'col-sm-12 col-md-6'B><'col-sm-12 col-md-3'f>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        'colvis',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        {
                            extend: 'pdfHtml5',
                            orientation: 'landscape',
                            pageSize: 'LEGAL'
                        }
                    ],
                    responsive: true,
                });

            };

            return {

                //main function to initiate the module
                init: function() {
                    initTable1();
                },

            };

        }();

        jQuery(document).ready(function() {
            KTDatatablesDataSourceHtml.init();
        });




    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/landport/web/pims.aqualinkbd.com/public_html/aqualink/district/src/views//thana/index.blade.php ENDPATH**/ ?>