<?php $__env->startSection('styles'); ?>
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title">
                <h3 class="card-label">চলমান জিপিএফ অগ্রিম (Current GPF Advance) Active From <?php echo e($startdate); ?> to <?php echo e($enddate); ?></h3>
            </div>
        </div>
        <div class="card-header flex-wrap py-3">
            <form action="<?php echo e(route('report.gpf_advance')); ?>" method="get" class="card-title">
                From <input name="start_date" data-date-format="dd-mm-yyyy" class="form-control form-control-lg form-control-solid kt_datepicker ml-2" type="text" required>
                To <input name="end_date" data-date-format="dd-mm-yyyy" class="form-control form-control-lg form-control-solid kt_datepicker ml-2" type="text" required>
                <button type="submit" class="btn btn-primary ml-2">Search</button>
            </form>
        </div>
        <div class="card-body">
            <table class="table table-bordered nowrap" id="kt_datatable_em">
                <thead class="thead-light">
                <tr>
                    <th>Name</th>
                    <th>Rank</th>
                    <th>Sanction number</th>
                    <th>Sanction date</th>
                    <th>Sanction amount</th>
                    <th>Sanction total no installment</th>
                    <th>Sanction installment starting date</th>
                    <th>Sanction no installment paid</th>
                    <th>Sanction total interest amount</th>
                    <th>Sanction adjusted amount</th>
                    <th>Sanction number interest installment</th>
                    <th>Sanction number interest installment paid</th>
                    <th>Contact Number</th>
                    <th>Action</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($data->employee->name); ?></td>
                        <td><?php if(isset($data->employee->rank) && (int)$data->employee->rank > 0): ?><?php echo e($function->rank()[(int)$data->employee->rank]['name_en']); ?><?php endif; ?></td>
                        <td><?php echo e($data->sanction_number ? $data->sanction_number:''); ?></td>
                        <td><?php echo e($data->sanction_date ? \Carbon\Carbon::parse($data->sanction_date)->format('d-m-Y'):''); ?></td>
                        <td><?php echo e($data->sanction_amount ? $data->sanction_amount:''); ?></td>
                        <td><?php echo e($data->sanction_total_no_installment ? $data->sanction_total_no_installment:''); ?></td>
                        <td><?php echo e($data->sanction_installment_starting_date ? \Carbon\Carbon::parse($data->sanction_installment_starting_date)->format('d-m-Y'):''); ?></td>
                        <td><?php echo e($data->sanction_no_installment_paid ? $data->sanction_no_installment_paid:''); ?></td>
                        <td><?php echo e($data->sanction_total_interest_amount ? $data->sanction_total_interest_amount:''); ?></td>
                        <td><?php echo e($data->sanction_adjusted_amount ? $data->sanction_adjusted_amount:''); ?></td>
                        <td><?php echo e($data->sanction_number_interest_installment ? $data->sanction_number_interest_installment:''); ?></td>
                        <td><?php echo e($data->sanction_number_interest_installment_paid ? $data->sanction_number_interest_installment_paid:''); ?></td>
                        <td><?php echo e($data->employee->sms_number); ?></td>
                        <td><a href="<?php echo e(route('employee.employinfopdf',['id'=>$data->employee->id])); ?>" class="text-primary" role="button" >Details</a></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>

            </table>
            <script>
                $(document).ready(function() {
                    var title = 'LandPortAuthority All Employee  GPF Advance Information Active  From <?php echo e($startdate); ?> to <?php echo e($enddate); ?>';
                    // +$('h3.card-label').text()
                    var table = $('#kt_datatable_em');
                    table.DataTable({
                        responsive: true,
                        dom: 'Bfrtip',
                        "lengthMenu": [[50, -1], [50, "All"]],
                        rowGroup: {
                            dataSrc: 1
                        },
                        buttons: [
                            {
                                extend: 'excelHtml5',
                                title: title,
                                exportOptions: {
                                    columns:  ':visible:not(:last-child)'
                                }
                            },
                            {
                                extend: 'pdfHtml5',
                                title: title,
                                orientation: 'landscape',
                                pageSize: 'A4',
                                exportOptions: {
                                    columns:  ':visible:not(:last-child)'
                                }
                            },
                            {
                                extend: 'print',
                                title: title,
                                exportOptions: {
                                    columns:  ':visible:not(:last-child)'
                                },
                                customize: function(win)
                                {

                                    var last = null;
                                    var current = null;
                                    var bod = [];

                                    var css = '@page  { size: landscape; }',
                                        head = win.document.head || win.document.getElementsByTagName('head')[0],
                                        style = win.document.createElement('style');

                                    style.type = 'text/css';
                                    style.media = 'print';

                                    if (style.styleSheet)
                                    {
                                        style.styleSheet.cssText = css;
                                    }
                                    else
                                    {
                                        style.appendChild(win.document.createTextNode(css));
                                    }

                                    head.appendChild(style);
                                }
                            },
                            'colvis'

                        ]

                    });
                });
            </script>
        </div>
    </div>
    <!--end::Card-->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <!--begin::Page Vendors(used by this page)-->
    <script src="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
    <!--end::Page Vendors-->

    <!--begin::Page Scripts(used by this page)-->
    <script src="<?php echo e(asset('js/pages/crud/datatables/data-sources/html.js')); ?>"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/landport/web/pims.aqualinkbd.com/public_html/resources/views/admin/reports/gpf_advance.blade.php ENDPATH**/ ?>