<?php $__env->startSection('styles'); ?>
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title">
                <h3 class="card-label">বর্তমান ঠিকানা (Present Address)<i class="fa fa-star-of-life fa-sm text-danger"></i></h3>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered nowrap" id="kt_datatable_em">
                <thead class="thead-light">
                <tr>
                    <th>Name</th>
                    <th>Rank</th>

                    <th>Contact Number</th>
                    <th>HOUSE NO. & ROAD NO. & VILLAGE</th>
                    <th>POST OFFICE</th>
                    <th>POLICE STATION</th>
                    <th>DISTRICT</th>
                    <th>TELEPHONE NO.</th>
                    <th>Action</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($data->employee->name); ?></td>
                        <td><?php if(isset($data->employee->rank) && (int)$data->employee->rank > 0): ?><?php echo e($function->rank()[(int)$data->employee->rank]['name_en']); ?><?php endif; ?></td>

                        <td><?php echo e($data->employee->sms_number); ?></td>
                        <td><?php echo e($data->village_or_house_road); ?></td>
                        <td><?php echo e($data->post_office); ?></td>
                        <td><?php if(isset($data->thana_id)): ?><?php echo e($function->thanas()[$data->thana_id]['name_en']); ?><?php endif; ?></td>
                        <td><?php if(isset($data->district_id)): ?><?php echo e($function->districts()[$data->district_id]['name_en']); ?><?php endif; ?></td>
                        <td><?php echo e($data->contact); ?></td>
                        <td><a href="<?php echo e(route('employee.employinfopdf',['id'=>$data->employee->id])); ?>" class="text-primary" role="button" >Details</a></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>

            </table>
            <script>
                $(document).ready(function() {
                    var title = 'LandPortAuthority All Employee '+$('h3.card-label').text();
                    var table = $('#kt_datatable_em');
                    table.DataTable({
                        responsive: true,
                        dom: 'Bfrtip',
                        buttons: [
                            {
                                extend: 'excelHtml5',
                                title: title,
                                exportOptions: {
                                    columns:  ':visible:not(:last-child)'
                                }
                            },
                            {
                                extend: 'pdfHtml5',
                                title: title,
                                orientation: 'landscape',
                                pageSize: 'A4',
                                exportOptions: {
                                    columns:  ':visible:not(:last-child)'
                                }
                            },
                            {
                                extend: 'print',
                                title: title,
                                exportOptions: {
                                    columns:  ':visible:not(:last-child)'
                                },
                                customize: function(win)
                                {

                                    var last = null;
                                    var current = null;
                                    var bod = [];

                                    var css = '@page  { size: landscape; }',
                                        head = win.document.head || win.document.getElementsByTagName('head')[0],
                                        style = win.document.createElement('style');

                                    style.type = 'text/css';
                                    style.media = 'print';

                                    if (style.styleSheet)
                                    {
                                        style.styleSheet.cssText = css;
                                    }
                                    else
                                    {
                                        style.appendChild(win.document.createTextNode(css));
                                    }

                                    head.appendChild(style);
                                }
                            },
                            'colvis'

                        ]

                    });
                });
            </script>
        </div>
    </div>
    <!--end::Card-->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <!--begin::Page Vendors(used by this page)-->
    <script src="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
    <!--end::Page Vendors-->

    <!--begin::Page Scripts(used by this page)-->
    <script src="<?php echo e(asset('js/pages/crud/datatables/data-sources/html.js')); ?>"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/landport/web/pims.aqualinkbd.com/public_html/resources/views/admin/reports/personal/present_address.blade.php ENDPATH**/ ?>