

<?php $__env->startSection('styles'); ?>
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title">
                <h3 class="card-label">
                    ছুটির অনুরোধ (Leave Application)
                </h3>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered nowrap" id="kt_datatable_em">
                <thead class="thead-light">
                    <tr>
                        <th>তারিখ (Date)</th>
                        <th>ছুটির ধরন (Leave Type)</th>
                        <th>দিনের ধরন (Day Type)</th>
                        <th>শুরু (Begin Date)</th>
                        <th>শেষ (End Date)</th>
                        <th>মোট দিন (Total Days)</th>
                        <th>অবস্থা (Status)</th>
                        <th>Last Updated</th>
                        <th>Action</th>


                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $leave_lists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leave_list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr style="background: <?php if($leave_list->approval_status == 2): ?><?php echo e(__("#d2f6c5")); ?><?php elseif($leave_list->approval_status == 1): ?><?php echo e(__("#ffe2ff")); ?><?php endif; ?>">
                            <td><?php echo e(date('Y-m-d G:i', strtotime($leave_list->created_at))); ?></td>
                            <td><?php echo e($leave_list->leavetype->name); ?></td>
                            <td><?php if($leave_list->day_status == 2): ?> Half Day <?php else: ?> Full Day <?php endif; ?></td>
                            <td><?php echo e(date('d M Y', strtotime($leave_list->begin_date))); ?></td>
                            <td><?php echo e(date('d M Y', strtotime($leave_list->end_date))); ?></td>
                            <td><?php echo e($leave_list->days); ?></td>
                            <td class="font-weight-bold"><?php if($leave_list->approval_status == 2): ?><span class="text-success">Approved</span>
                                <?php elseif($leave_list->approval_status == 1): ?><span class="text-danger">Rejected</span> <?php else: ?> <span class="text-primary">Pending</span> <?php endif; ?></td>

                            <td><?php echo e(date('Y-m-d G:i', strtotime($leave_list->updated_at))); ?></td>
                            <td><?php if($leave_list->approval_status == 0 ): ?>
                                    <a href="<?php echo e(route('myleave.edit_leave',['id'=>$leave_list->id])); ?>" class="mr-5" role="button" ><i class="fa fa-pen-alt text-primary"></i> </a>
                                    <a href="<?php echo e(route('myleave.delete_leave',['id'=>$leave_list->id])); ?>" role="button" ><i class="fa fa-trash text-danger"></i></a>
                                <?php endif; ?></td>

                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>

            </table>
            <script>
                $(document).ready(function() {
                    var table = $('#kt_datatable_em');
                    table.DataTable({
                        responsive: true,

                    });
                });
            </script>
        </div>
    </div>
    <!--end::Card-->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <!--begin::Page Vendors(used by this page)-->
        <script src="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
        <!--end::Page Vendors-->

        <!--begin::Page Scripts(used by this page)-->
        <script src="<?php echo e(asset('js/pages/crud/datatables/data-sources/html.js')); ?>"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/landport/web/pims.aqualinkbd.com/public_html/resources/views/admin/leave/regular/leave_application.blade.php ENDPATH**/ ?>