<?php $__env->startSection('styles'); ?>
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column-fluid">
        <!--begin::Container-->
        <div class=" container " style="padding: 0">
           
            <!--begin::Card-->
            <div class="card card-custom gutter-b">
            <div class="card-header flex-wrap py-3">
                    <div class="card-title">
                        <h3 class="card-label kt_datatable_em_title"><?php echo e($employee->name); ?> Payslip</h3>
                    </div>
                </div>
                <div class="card-header flex-wrap py-3">
                    <form action="<?php echo e(route('employee.payslip',['id'=>$employee->id])); ?>" class="d-flex" method="get">
                       <span class="my-auto">From</span> <input data-date-format="dd-mm-yyyy" readonly class="form-control form-control-solid kt_datepicker float-left my-auto ml-2  mr-2" name="start" type="text" style="width: 150px" value=""/>
                        <span class="my-auto">To</span> <input data-date-format="dd-mm-yyyy" readonly class="form-control form-control-solid kt_datepicker float-left my-auto ml-2 mr-2" name="end" type="text" style="width: 150px" value=""/>
                        <button type="submit" class="btn btn-primary payslipsearch">Search</button>
                    </form>
                </div>
                <div class="card-body">
                    <!--begin: Datatable-->
                    <table class="table table-bordered table-checkable text-center" id="kt_datatable_em">
                    <thead>
                            <tr>
                                <th rowspan="2">নাম</th>
                                <th rowspan="2">পদবী</th>
                                <th rowspan="2">মাস</th>
                                <?php $__currentLoopData = $function->pay_allowance(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$allowance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($allowance[0] == 1 && in_array($key,$activecode1)): ?>
                                        <th rowspan="2"><?php echo e($allowance[1]); ?></th>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <th rowspan="2">সর্বমোট টাকা</th>
                                <th colspan="<?php echo e($deductionCount); ?>">কর্তন</th>
                                <th rowspan="2">মোট কর্তন</th>
                                <th rowspan="2">নীট পরিশোধিত</th>
                            </tr>
                            <tr>
                                <?php $__currentLoopData = $function->pay_allowance(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$allowance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($allowance[0] == 0  && in_array($key,$activecode1)): ?>
                                        <th><?php echo e($allowance[1]); ?></th>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        </thead>

                        <tbody>
                        <?php $__currentLoopData = $employee->pay_slip->groupBy('month'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$payslip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $adata= array();
                                $ddata= array();
                                foreach ($payslip as $p){
                                    if($p->addition == 1){
                                        $adata[$p->code] = (int)$p->taka;
                                    }else{
                                        $ddata[$p->code] = (int)$p->taka;
                                    }

                                }
                            ?>

                            <tr>
                                <th><?php echo e($employee->name); ?></th>
                                <th><?php echo e($employee->employee_present_position->post); ?></th>
                                <th><?php echo e(\Carbon\Carbon::parse($key)->format('F,Y')); ?></th>
                                <?php $__currentLoopData = $function->pay_allowance(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$allowance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($allowance[0] == 1 && in_array($key,$activecode1)): ?>
                                        <th><?php if(isset($adata[$key])): ?> <?php echo e($adata[$key]); ?><?php endif; ?></th>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <th><?php echo e(array_sum($adata)); ?></th>
                                <?php $__currentLoopData = $function->pay_allowance(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$allowance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($allowance[0] == 0 && in_array($key,$activecode1)): ?>
                                        <th><?php if(isset($ddata[$key])): ?> <?php echo e($ddata[$key]); ?><?php endif; ?></th>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <th><?php echo e(array_sum($ddata)); ?></th>
                                <th><?php echo e(array_sum($adata) - array_sum($ddata)); ?></th>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <!--end: Datatable-->
                </div>
            </div>


        </div>
    </div>
    <!--end::Entry-->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            var title = 'LandPortAuthority All Employee '+$('h3.kt_datatable_em_title').text();
            var table = $('#kt_datatable_em');
            table.DataTable({
                responsive: true,
                dom: 'Bfrtip',
                buttons: [
                    {
                        extend: 'excelHtml5',
                        title: title,
                        exportOptions: {
                            columns:  ':visible'
                        }
                    },
                    // {
                    //     extend: 'pdfHtml5',
                    //     title: title,
                    //     orientation: 'landscape',
                    //     pageSize: 'A4',
                    //     exportOptions: {
                    //         // columns:  ':visible'
                    //     }
                    // },
                    {
                        extend: 'print',
                        title: title,
                        exportOptions: {
                            columns:  ':visible'
                        },
                        customize: function(win)
                        {

                            var last = null;
                            var current = null;
                            var bod = [];

                            var css = '@page  { size: landscape; }',
                                head = win.document.head || win.document.getElementsByTagName('head')[0],
                                style = win.document.createElement('style');

                            style.type = 'text/css';
                            style.media = 'print';

                            if (style.styleSheet)
                            {
                                style.styleSheet.cssText = css;
                            }
                            else
                            {
                                style.appendChild(win.document.createTextNode(css));
                            }

                            head.appendChild(style);
                        }
                    },
                    'colvis'

                ]

            });
        });
    
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/landport/web/pims.aqualinkbd.com/public_html/resources/views/admin/employee/payslip.blade.php ENDPATH**/ ?>