<?php $__env->startSection('styles'); ?>
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.css')); ?>" rel="stylesheet" type="text/css"/>
    <!--end::Page Vendors Styles-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php
        $em_Grade = $function->present_position_present_grade();
        $em_Scale = $function->present_position_present_grade();
    ?>
    
    <div class="row d-flex">
        <div class="col-xl-6 col-md-6 form-group d-flex">
            <label class="col-form-label text-left col-md-3">পদবী (Rank)</label>
            <div class="col-md-9 text-right">
                    <select class="form-control dropdown_rank">
                        <option value="-1">All Rank</option>
                        <?php $__currentLoopData = $function->rank(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$rank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>"><?php echo e($rank['name_bn']); ?> (<?php echo e($rank['name_en']); ?>)</option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
            </div>
        </div>
        <div class="col-xl-6 col-md-6 form-group d-flex">
            <label class="col-form-label text-left col-md-3">বর্তমান কর্মস্থল (Present Working Place)</label>
            <div class="col-md-9 text-right">
                <select class="form-control dropdown_working_place">
                    <option value="-1">All working place</option>
                    <?php $__currentLoopData = $function->name_of_all_landport(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$workingplace): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>"><?php echo e($workingplace[0]); ?> (<?php echo e($workingplace[1]); ?>)</option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
        <div class="col-xl-6 col-md-6 form-group d-flex">
            <label class="col-form-label text-left col-md-3">বদলি (Transfer) ( আজকের দিনে কর্মরত )</label>
            <div class="col-md-9 text-right">
                <select class="form-control dropdown_transfer">
                    <option value="-1">All</option>
                    <?php $__currentLoopData = $function->name_of_all_landport(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$workingplace): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>"><?php echo e($workingplace[0]); ?> (<?php echo e($workingplace[1]); ?>)</option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
        <div class="col-xl-6 col-md-6 form-group d-flex">
            <label class="col-form-label text-left col-md-3">গ্রেড ( Grade )</label>
            <div class="col-md-9 text-right">
                <select class="form-control dropdown_grade" data-live-search="true">
                    <option value="-1">All Grade</option>
                    <?php $__currentLoopData = $function->present_position_present_grade(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$Grade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($Grade[7] > 0): ?>
                        <option value="<?php echo e($key); ?>"><?php echo e($Grade[0]); ?></option>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
        <div class="col-xl-6 col-md-6 form-group d-flex">
            <label class="col-form-label text-left col-md-3">বেতন স্কেল (Scale)</label>
            <div class="col-md-9 text-right">
                <select class="form-control dropdown_scale" data-live-search="true">
                    <option value="-1">All scale</option>
                    <?php $__currentLoopData = $function->present_position_present_grade(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$Scale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($Scale[7] > 0): ?>
                        <option value="<?php echo e($key); ?>"><?php echo e($Scale[4]); ?>-<?php echo e($Scale[5]); ?></option>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>











    </div>



    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title">
                <h3 class="card-label">
                    Employee List

                </h3>
            </div>
            <div class="card-toolbar">
                <!--begin::Button-->
                <a href="<?php echo e(route('manage_employee.addnew')); ?>" class="btn btn-primary font-weight-bolder">
                    <span class="svg-icon svg-icon-md">
                         <?php echo e(Metronic::getSVG("media/svg/icons/Design/Flatten.svg", "svg-icon-lg svg-icon-primary")); ?>

                    </span>	New Record
                </a>
                <!--end::Button-->
            </div>
        </div>
        <div class="card-body" id="employee_list">
            <!--begin: Datatable-->
            <?php echo $__env->make('admin.employee.table.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
    <!--end::Card-->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

    <script src="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.js')); ?>" type="text/javascript"></script>


<script>
$(document).ready(function() {

    var dropdown_rank = -1;
    var dropdown_working_place = -1;
    var dropdown_transfer = -1;
    var dropdown_grade = -1;
    var dropdown_scale = -1;

    function searchdata(rank, working_place, transfer, grade, scale) {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        // console.log(c_s,ex,vn,bg,r_a,ta_kg);
        jQuery.ajax({
            url: "<?php echo e(route("ajaxcall.employee_list")); ?>",
            method: 'post',
            data: {
                rank: rank,
                working_place: working_place,
                transfer: transfer,
                grade: grade,
                scale: scale,
            },
            success: function (result) {
                // console.log(result);
                $("#employee_list").html(result);
            }
        })
    }

    $(document).on("change", ".dropdown_rank", function () {
        dropdown_rank = $(this).val();
        searchdata(dropdown_rank, dropdown_working_place, dropdown_transfer, dropdown_grade, dropdown_scale);
    });
    $(document).on("change", ".dropdown_working_place", function () {
        dropdown_working_place = $(this).val();
        searchdata(dropdown_rank, dropdown_working_place, dropdown_transfer, dropdown_grade, dropdown_scale);
    });
    $(document).on("change", ".dropdown_transfer", function () {
        dropdown_transfer = $(this).val();
        searchdata(dropdown_rank, dropdown_working_place, dropdown_transfer, dropdown_grade, dropdown_scale);
    });
    $(document).on("change", ".dropdown_grade", function () {
        dropdown_grade = $(this).val();
        searchdata(dropdown_rank, dropdown_working_place, dropdown_transfer, dropdown_grade, dropdown_scale);
    });
    $(document).on("change", ".dropdown_scale", function () {
        dropdown_scale = $(this).val();
        searchdata(dropdown_rank, dropdown_working_place, dropdown_transfer, dropdown_grade, dropdown_scale);
    });
    // $(document).on("change", ".dropdown_class", function () {
    //     dropdown_class = $(this).val();
    // });



});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/landport/web/pims.aqualinkbd.com/public_html/resources/views/admin/employee/index.blade.php ENDPATH**/ ?>