<?php

use App\Http\Controllers\Controller;
use App\Http\Controllers\Employee\AuthorizedLeaveController;
use App\Http\Controllers\Employee\DeciplinaryActionController;
use App\Http\Controllers\Employee\EmployeeController;
use App\Http\Controllers\Employee\EmployeeLoanController;
use App\Http\Controllers\Employee\GPFController;
use App\Http\Controllers\Employee\PayAllowanceDeductionController;
use App\Http\Controllers\Employee\PayslipController;
use App\Http\Controllers\Employee\PensionNomineeController;
use App\Http\Controllers\Employee\PersonalInfoController;
use App\Http\Controllers\Employee\PresentPositionController;
use App\Http\Controllers\Employee\EmployeeOtherController;
use App\Http\Controllers\Employee\InfoController;
use App\Http\Controllers\Employee\RestandRecreationController;
use App\Http\Controllers\LeaveManagementController;
use App\Http\Controllers\PagesController;

use App\Http\Controllers\RankController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SMSverificationController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\UserLeaveManagementController;
use App\Http\Controllers\LoginpageinfoController;

use Carbon\Carbon;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//Route::get('/', function () {
//    return view('welcome');
//});
//middleware(['auth:sanctum', 'verified'])
Route::get('/clear_all',[Controller::class, 'clear_all']);
Route::get('/notify_people', [\App\Http\Controllers\FunctionController::class, 'notify_employee'])->name("notify_employee")->middleware('onlyadmin');
Route::get('/login', [LoginpageinfoController::class, 'login'])->name('login');
Route::middleware(['auth:sanctum'])->group(function () {
    Route::get('/', function () {
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){
            if(!isset($loggedin->email_verified_at) && Carbon::parse($loggedin->created_at)->diffInMinutes(Carbon::now()) < 55 ){
                return redirect()->route('manage_employee.edit',['id'=>$loggedin->employee_id])->with('type','info')->with('message','A verification email sent to your email. please verify.');
            }
            if(!isset($loggedin->mobile_verified_at )){
                return redirect()->route('manage_employee.edit',['id'=>$loggedin->employee_id])->with('type','info')->with('message','You must verify Mobile Number');
            }
            return redirect()->route('employee.index',['id'=>$loggedin->employee_id]);
        }
        return redirect()->route('dashboard');
    });
    Route::get('/dashboard', [ReportController::class, 'dashboard'])->name('dashboard')->middleware('onlyadmin');
    Route::get('/email/verify', function () {
        return view('auth.verify-email');
    })->middleware('auth')->name('verification.notice');
    Route::post('/email/verification-notification', function (Request $request) {
        $request->user()->sendEmailVerificationNotification();

        return back()->with('message', 'Verification link sent!');
    })->middleware(['auth', 'throttle:6,1'])->name('verification.send');
    Route::get('/email/verify/{id}/{hash}', function (EmailVerificationRequest $request) {
        $request->fulfill();

        return redirect('/')->with('type','success')->with('message','Email verification complete');
    })->middleware(['auth', 'signed'])->name('verification.verify');
    Route::post('/number/verification', [SMSverificationController::class, 'number_send_sms'])->name("number_send_sms");
    Route::post('/number/verify', [SMSverificationController::class, 'number_verify'])->name("number_verify");
//-----------------------------------------------------------------------------------
//    Route::get('/userAccess', [UserAccessController::class, 'index']);
    Route::group(['prefix' => 'manage-user', 'as' => 'manage_user.','middleware' => ['auth','user_management']], function () {
        Route::get('/', [UserController::class, 'index'])->name("index");
        Route::get('/add', [UserController::class, 'add'])->name("add");
        Route::get('/edit/{id}', [UserController::class, 'edit'])->name("edit");
        Route::get('/delete/{id}', [UserController::class, 'delete'])->name("delete");
        Route::post('/add', [UserController::class, 'addtodb'])->name("addtodb");
    });


    Route::group(['prefix' => 'manage_employee', 'as' => 'manage_employee.','middleware' => ['auth']], function () {
        Route::get('/', [EmployeeController::class, 'index'])->name("index")->middleware('onlyadmin');
        Route::get('/sendupdatetoall', [EmployeeController::class, 'sendupdatetoall'])->middleware('onlyadmin');
        Route::get('/addnew', [EmployeeController::class, 'addnew'])->name("addnew")->middleware('onlyadmin');
        Route::post('/addnew', [EmployeeController::class, 'addnew_db'])->name("addnew_db");
        Route::get('/edit/{id}', [EmployeeController::class, 'edit'])->name("edit");
        Route::get('/delete/{id}', [EmployeeController::class, 'delete'])->name("delete")->middleware('onlyadmin','delete_employee');
    });

    Route::group(['prefix' => 'employee/{id}', 'as' => 'employee.','middleware' => ['auth','employee_info_modification']], function () {
        Route::get('/', [InfoController::class, 'index'])->name("index");
        Route::get('/payslip', [PayslipController::class, 'employee_payslip'])->name("payslip")->middleware('employee_pay_slip');
        Route::get('/employinfopdf', [InfoController::class, 'employinfopdf'])->name("employinfopdf");
        Route::get('/employinfoshortpdf', [InfoController::class, 'employinfoshortpdf'])->name("employinfoshortpdf");
        Route::post('/', [InfoController::class, 'db'])->name("indexdb");

        Route::get('/family-and-bank', [PersonalInfoController::class, 'index'])->name("familyandbank")->middleware('employee_family_info');
        Route::post('/family-and-bank', [PersonalInfoController::class, 'db'])->name("familyandbankdb");

        Route::get('/service', [PresentPositionController::class, 'index'])->name("service")->middleware('employee_service_info');
        Route::post('/service', [PresentPositionController::class, 'db'])->name("servicedb");

        Route::get('/pay_allowanced_deduction', [PayAllowanceDeductionController::class, 'index'])->name("pay_allowanced_deduction")->middleware('employee_pay_slip');
        Route::post('/pay_allowanced_deduction', [PayAllowanceDeductionController::class, 'db'])->name("pay_allowanced_deductiondb");

        Route::get('/gpf', [GPFController::class, 'index'])->name("gpf")->middleware('employee_gpf');
        Route::post('/gpf', [GPFController::class, 'db'])->name("gpfdb");

        Route::get('/current_loan', [EmployeeLoanController::class, 'index'])->name("loan")->middleware('employee_loan');
        Route::post('/current_loan', [EmployeeLoanController::class, 'db'])->name("loandb");

        Route::get('/leave', [AuthorizedLeaveController::class, 'index'])->name("leave")->middleware('employee_leave_lien');
        Route::post('/leave', [AuthorizedLeaveController::class, 'db'])->name("leavedb");

        Route::get('/disciplinary', [DeciplinaryActionController::class, 'index'])->name("disciplinary")->middleware('employee_disciplinary_action');
        Route::post('/disciplinary', [DeciplinaryActionController::class, 'db'])->name("disciplinarydb");

        Route::get('/nomineepension', [PensionNomineeController::class, 'index'])->name("nomineepension")->middleware('employee_pension');
        Route::post('/nomineepension', [PensionNomineeController::class, 'db'])->name("nomineepensiondb");

        Route::resource('rest_recreations', RestandRecreationController::class)->only(['index','create','store'])->middleware('employee_rest');
        Route::get('/all_logs', [EmployeeOtherController::class, 'all_logs'])->name("all_logs");
    });


    Route::group(['prefix' => 'ajaxcall', 'as' => 'ajaxcall.','middleware' => ['auth','employee_info_modification']], function () {
        Route::get('/per_husbandwifeinfo', [PersonalInfoController::class, 'husbandwifeinfo'])->name("per_husbandwifeinfo");
        Route::get('/per_children_info', [PersonalInfoController::class, 'per_children_info'])->name("per_children_info");
        Route::get('/per_disabled_children_info', [PersonalInfoController::class, 'per_disabled_children_info'])->name("per_disabled_children_info");
        Route::get('/service_promotion', [PresentPositionController::class, 'service_promotion'])->name("service_promotion");
        Route::get('/pay_scale_change', [PresentPositionController::class, 'pay_scale_change'])->name("pay_scale_change");

        Route::get('/service_accommodation', [PresentPositionController::class, 'service_accommodation'])->name("service_accommodation");
        Route::get('/gpf_nomine', [GPFController::class, 'gpf_nomine'])->name("gpf_nomine");
        Route::get('/gpf_adv', [GPFController::class, 'gpf_adv'])->name("gpf_adv");
        Route::get('/authorized_leave', [AuthorizedLeaveController::class, 'authorized_leave'])->name("authorized_leave");
        Route::get('/lien', [AuthorizedLeaveController::class, 'lien'])->name("lien");
        Route::get('/disciplinary', [DeciplinaryActionController::class, 'disciplinary'])->name("disciplinary");
        Route::get('/nomineepension', [PensionNomineeController::class, 'nomineepension'])->name("nomineepension");
        Route::post('/employee_list', [EmployeeController::class, 'employee_list'])->name("employee_list");
        Route::get('/personal_language', [InfoController::class, 'personal_language'])->name("personal_language");
        Route::get('/personal_educational_qualification', [InfoController::class, 'educational_qualification'])->name("educational_qualification");
        Route::get('/personal_local_training', [InfoController::class, 'local_training'])->name("local_training");
        Route::get('/personal_foreign_training', [InfoController::class, 'foreign_training'])->name("foreign_training");
        Route::get('/personal_foreign_travel', [InfoController::class, 'foreign_travel'])->name("foreign_travel");
        Route::get('/personal_posting_abroad', [InfoController::class, 'posting_abroad'])->name("posting_abroad");
        Route::get('/personal_professional_qualification', [InfoController::class, 'professional_qualification'])->name("professional_qualification");
        Route::get('/personal_publication', [InfoController::class, 'publication'])->name("publication");
        Route::get('/personal_honour_reward', [InfoController::class, 'honour_reward'])->name("honour_reward");
        Route::get('/personal_other_service', [InfoController::class, 'other_service'])->name("other_service");
        Route::post('/find_relation', [InfoController::class, 'find_relation'])->name("find_relation");
        Route::get('/loan_add', [EmployeeLoanController::class, 'loan_add'])->name("loan_add");
        Route::get('/service_transfer', [PresentPositionController::class, 'service_transfer'])->name("service_transfer");

    });

    Route::group(['prefix' => 'leave', 'as' => 'leave.','middleware' => ['auth']], function () {
        Route::get('/', [LeaveManagementController::class, 'pending_leave_application'])->name("index")->middleware('leave_applications');
        Route::get('/all-record', [LeaveManagementController::class, 'leave_application_record'])->name("leave_application_record")->middleware('leave_applications');
        Route::get('/type', [LeaveManagementController::class, 'leave_type'])->name("leave_type")->middleware('leave_applications');
        Route::get('/type/create', [LeaveManagementController::class, 'create_leave_type'])->name("create_leave_type")->middleware('leave_new');
        Route::post('/type/create', [LeaveManagementController::class, 'post_create_leave_type'])->name("post_create_leave_type")->middleware('leave_new');
        Route::get('/type/edit/{id}', [LeaveManagementController::class, 'edit_leave_type'])->name("edit_leave_type")->middleware('leave_new');
        Route::get('/type/remaining-balance', [LeaveManagementController::class, 'remaining_balance'])->name("remaining_balance")->middleware('leave_applications');
        Route::get('/view/{id}', [LeaveManagementController::class, 'view_leave'])->name("view_leave")->middleware('leave_applications');
        Route::post('/view/{id}', [LeaveManagementController::class, 'post_view_leave'])->name("post_view_leave")->middleware('leave_applications');
    });
    Route::group(['prefix' => 'my-leave', 'as' => 'myleave.','middleware' => ['auth','employee_leave']], function () {
        Route::get('/type', [UserLeaveManagementController::class, 'leave_lists'])->name("leave_list");
        Route::get('/', [UserLeaveManagementController::class, 'leave_applications'])->name("index");
        Route::get('/apply', [UserLeaveManagementController::class, 'apply_leave'])->name("apply");
        Route::post('/apply', [UserLeaveManagementController::class, 'post_apply_leave'])->name("post_apply");
        Route::post('/get-remaining-balance', [UserLeaveManagementController::class, 'get_remaining_balance'])->name("get_remaining_balance");
        Route::get('/edit/{id}', [UserLeaveManagementController::class, 'edit_leave'])->name("edit_leave");
        Route::get('/delete/{id}', [UserLeaveManagementController::class, 'delete_leave'])->name("delete_leave");
    });
    Route::group(['prefix' => 'report', 'as' => 'report.','middleware' => ['auth','employee_report']], function () {
        Route::get('/present-address', [ReportController::class, 'present_address'])->name("present_address")->middleware('employee_personal_info');
        Route::get('/permanent-address', [ReportController::class, 'permanent_address'])->name("permanent_address")->middleware('employee_personal_info');
        Route::get('/language', [ReportController::class, 'language'])->name("language")->middleware('employee_personal_info');
        Route::get('/educational-qualification', [ReportController::class, 'educational_qualification'])->name("educational_qualification")->middleware('employee_personal_info');
        Route::get('/local-training', [ReportController::class, 'local_training'])->name("local_training")->middleware('employee_personal_info');
        Route::get('/foreign-training', [ReportController::class, 'foreign_training'])->name("foreign_training")->middleware('employee_personal_info');
        Route::get('/foreign-travel', [ReportController::class, 'foreign_travel'])->name("foreign_travel")->middleware('employee_personal_info');
        Route::get('/posting-abroad', [ReportController::class, 'posting_abroad'])->name("posting_abroad")->middleware('employee_personal_info');
        Route::get('/professional-qualification', [ReportController::class, 'professional_qualification'])->name("professional_qualification")->middleware('employee_personal_info');
        Route::get('/publication', [ReportController::class, 'publication'])->name("publication")->middleware('employee_personal_info');
        Route::get('/honours-and-award', [ReportController::class, 'honours_and_award'])->name("honours_and_award")->middleware('employee_personal_info');
        Route::get('/other-services', [ReportController::class, 'other_services'])->name("other_services")->middleware('employee_personal_info');
        Route::get('/service-history', [ReportController::class, 'service_history'])->name("service_history")->middleware('employee_personal_info');
        Route::get('/husband-wife-information', [ReportController::class, 'husband_wife'])->name("husband_wife")->middleware('employee_family_info');
        Route::get('/children', [ReportController::class, 'children'])->name("children")->middleware('employee_family_info');
        Route::get('/service_present_position', [ReportController::class, 'present_position'])->name("present_position")->middleware('employee_service_info');
        Route::get('/service_first_joining', [ReportController::class, 'service_first_join'])->name("service_first_join")->middleware('employee_service_info');
        Route::get('/service_promotion', [ReportController::class, 'service_promotion'])->name("service_promotion")->middleware('employee_service_info');
        Route::get('/service_transfer', [ReportController::class, 'service_transfer'])->name("service_transfer")->middleware('employee_service_info');
        Route::get('/service_scale', [ReportController::class, 'service_scale'])->name("service_scale")->middleware('employee_service_info');
        Route::get('/service_accommodation', [ReportController::class, 'service_accommodation'])->name("service_accommodation")->middleware('employee_service_info');
        Route::get('/gpf_advance', [ReportController::class, 'gpf_advance'])->name("gpf_advance")->middleware('employee_gpf');
        Route::get('/loan', [ReportController::class, 'loan'])->name("loan")->middleware('employee_loan');
        Route::get('/leave', [ReportController::class, 'earned_leave'])->name("leave")->middleware('employee_leave_lien');
        Route::get('/lien', [ReportController::class, 'lien'])->name("lien")->middleware('employee_leave_lien');
        Route::get('/disciplinary_action', [ReportController::class, 'disciplinary_action'])->name("disciplinary_action")->middleware('employee_disciplinary_action');
        Route::get('/rest_and_recreation', [ReportController::class, 'rest_and_recreation'])->name("rest_and_recreation")->middleware('employee_rest');
        Route::get('/prl', [ReportController::class, 'prl'])->name("prl")->middleware('employee_service_info');

        Route::get('/all_logs', [ReportController::class, 'all_logs'])->name("all_changes_log");


    });

    Route::group(['prefix' => 'rank', 'as' => 'rank.','middleware' => ['auth','web']], function () {
        Route::get('/', [RankController::class, 'index'])->name('index');
        Route::get('/add', [RankController::class, 'add'])->name('add');
        Route::get('/edit/{id}', [RankController::class, 'edit'])->name('edit');
        Route::post('/add', [RankController::class, 'add_to_db'])->name('add_to_db');
        Route::get('/delete/{id}', [RankController::class, 'delete'])->name('delete');
    });

    Route::group(['prefix' => 'language', 'as' => 'language.','middleware' => ['auth','web']], function () {
        Route::get('/', [LanguageController::class, 'index'])->name('index');
        Route::get('/add', [LanguageController::class, 'add'])->name('add');
        Route::get('/edit/{id}', [LanguageController::class, 'edit'])->name('edit');
        Route::post('/add', [LanguageController::class, 'add_to_db'])->name('add_to_db');
        Route::get('/delete/{id}', [LanguageController::class, 'delete'])->name('delete');
    });
    Route::group(['prefix' => 'payslip', 'as' => 'payslip.','middleware' => ['auth','web','employee_pay_slip','onlyadmin']], function () {
        Route::get('/show/{month}', [PayslipController::class, 'index'])->name('index');
        Route::post('/show', [PayslipController::class, 'show'])->name('show');
        Route::get('/add', [PayslipController::class, 'add'])->name('add');
//        Route::get('/edit/{id}', [PayslipController::class, 'edit'])->name('edit');
        Route::post('/add', [PayslipController::class, 'add_to_db'])->name('add_to_db');

//        Route::get('/delete/{id}', [PayslipController::class, 'delete'])->name('delete');
    });

    Route::group(['prefix' => 'loginpageinfo', 'as' => 'loginpageinfo.','middleware' => ['auth','web']], function () {
        Route::get('/', [LoginpageinfoController::class, 'index'])->name('index');
        Route::get('/edit', [LoginpageinfoController::class, 'edit'])->name('edit');
        Route::post('/add_to_db', [LoginpageinfoController::class, 'add_to_db'])->name('add_to_db');

    });


//Route::get('/', [PagesController::class, 'index']);
//
////oute::get('/user/profile',[PagesController::class, 'datatables']);
//// Demo routes
//Route::get('/datatables', [PagesController::class, 'datatables']);
//Route::get('/ktdatatables', [PagesController::class, 'ktDatatables']);
//Route::get('/select2', [PagesController::class, 'select2']);
//Route::get('/icons/custom-icons', [PagesController::class, 'customIcons']);
//Route::get('/icons/flaticon', [PagesController::class, 'flaticon']);
//Route::get('/icons/fontawesome', [PagesController::class, 'fontawesome']);
//Route::get('/icons/lineawesome', [PagesController::class, 'lineawesome']);
//Route::get('/icons/socicons', [PagesController::class, 'socicons']);
//Route::get('/icons/svg', [PagesController::class, 'svg']);
//
//// Quick search dummy route to display html elements in search dropdown (header search)



Route::get('/quick-search', [PagesController::class, 'quickSearch'])->name('quick-search');

});


Route::get('/appLeaveType', [App\Http\Controllers\AppApiController::class, 'leave_lists'])->name("app_leave_list");

Route::get('employee/{id}/appemployinfopdf', [InfoController::class, 'appemployinfopdf'])->name("appemployinfopdf");
