<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::post('/login', [App\Http\Controllers\Api\UserController::class,'login']);

Route::post('/getLeaveCategory', [App\Http\Controllers\Api\LeaveApiController::class,'leave_lists']);

Route::post('/applyLeave', [App\Http\Controllers\Api\LeaveApiController::class,'applyLeave']);

Route::get('/getLeaveType',[App\Http\Controllers\Api\LeaveApiController::class,'getLeaveType']);

Route::post('/pendingLeave', [App\Http\Controllers\Api\LeaveApiController::class,'pending_leave']);

Route::post('/accRejLeave', [App\Http\Controllers\Api\LeaveApiController::class,'acc_rej_leave']);

Route::post('/editLeave', [App\Http\Controllers\Api\LeaveApiController::class,'editLeave']);

Route::post('/deleteLeave', [App\Http\Controllers\Api\LeaveApiController::class,'deleteLeave']);

Route::post('/getLeaveBalance', [App\Http\Controllers\Api\LeaveApiController::class,'getLeaveBalance']);

Route::post('/getTotalLeave', [App\Http\Controllers\Api\LeaveApiController::class,'getTotalLeave']);

Route::post('/getDesignation', [App\Http\Controllers\Api\LeaveApiController::class,'getDesignation']);

Route::post('/forgetPassword', [App\Http\Controllers\Api\LeaveApiController::class,'forgetPassword']);

Route::post('/pds', [App\Http\Controllers\Api\UserController::class,'pds']);
