{{-- Header --}}
<div id="kt_header" class="header {{ Metronic::printClasses('header', false) }}" {{ Metronic::printAttrs('header') }}>

    {{-- Container --}}
    <div class="container-fluid d-flex align-items-center justify-content-between">
        @if (config('layout.header.self.display'))

            @php
                $kt_logo_image = 'logo-1.png';
            @endphp

            @if (config('layout.header.self.theme') === 'light')
                @php $kt_logo_image = 'logo-1.png' @endphp
            @elseif (config('layout.header.self.theme') === 'dark')
                @php $kt_logo_image = 'logo-1.png' @endphp
            @endif

            {{-- Header Menu --}}
            <div class="header-menu-wrapper header-menu-wrapper-right" id="kt_header_menu_wrapper">
                @if(config('layout.aside.self.display') == false)
                    <div class="header-logo">
                        <a href="{{ url('/') }}">
                            <img alt="Logo" src="{{ asset('media/logos/'.$kt_logo_image) }}"/>

                        </a>
                    </div>
                @endif
                    @php
                    $loggedinuser = \Illuminate\Support\Facades\Auth::user();
                    @endphp
                    @if(isset($loggedinuser->employee_id))
                        <span class="badge badge-info p-5">Employee Account</span>
                    @else
                        <span class="badge badge-info p-5">Administrator Account</span>
                    @endif
                    <span class="badge badge-primary p-5">{{$loggedinuser->name}}</span>
@php
    $rank = Illuminate\Support\Facades\Cache::remember('Rank', 240*60, function() {
           return \App\Models\Rank::orderBy('name_en', 'asc')->get()->keyBy('id')->toArray();
        });
@endphp
                    <span class="badge badge-primary p-5">Rank : @if(isset($loggedinuser->rank) && (int)$loggedinuser->rank>0){{$rank[(int)$loggedinuser->rank]['name_bn']}}@endif</span>
               
                <div id="kt_header_menu" class="header-menu header-menu-mobile {{ Metronic::printClasses('header_menu', false) }}" {{ Metronic::printAttrs('header_menu') }}>
                    <ul class="menu-nav {{ Metronic::printClasses('header_menu_nav', false) }}">
                        {{ Menu::renderHorMenu(config('menu_header.items')) }}
                    </ul>
                </div>
            </div>

        @else
            <div></div>
        @endif

    @include('layout.partials.extras._topbar')
    </div>
</div>
