{{-- Extends layout --}}
@extends('layout.default_nobody')
@section('styles')
    <!--begin::Page Custom Styles(used by this page)-->
    <link href="css/pages/login/login-4.css" rel="stylesheet" type="text/css"/>
    <!--end::Page Custom Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Main-->
    <div class="d-flex flex-column flex-root">
        <!--begin::Login-->
        <div class="login login-4 wizard d-flex flex-column flex-lg-row flex-column-fluid">
            <!--begin::Content-->
            <div class="login-container order-2 order-lg-1 d-flex flex-center flex-row-fluid px-7 pt-lg-0 pb-lg-0 pt-4 pb-6 bg-white">
                <!--begin::Wrapper-->
                <div class="login-content d-flex flex-column pt-lg-0 pt-12" style="padding-bottom: 20px">
                    <!--begin::Logo-->
                    <a href="#" class="login-logo pb-xl-5 pb-5">
                        <img src="{{asset('media/blpa.png')}}" style="width: 100%"  alt=""/>
                    </a>
                    <!--end::Logo-->

                    <!--begin::Signin-->
                    <div class="login-form">
                        <!--begin::Form-->
                        @include('layout.session')
                        @include('layout.error')
        <form method="POST" action="{{ route('password.update') }}">
            @csrf

            <input type="hidden" name="token" value="{{ $request->route('token') }}">

            <div class="form-group">
                <label class="font-size-h6 font-weight-bolder text-dark">{{ __('Email') }}<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                <input class="form-control form-control-solid h-auto py-7 px-6 rounded-lg border-0" id="email" type="email" name="email" value="{{old('email', $request->email)}}" required autofocus />
            </div>

            <div class="form-group">
                <label class="font-size-h6 font-weight-bolder text-dark">{{ __('Password') }}<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                <input class="form-control form-control-solid h-auto py-7 px-6 rounded-lg border-0" id="password" type="password" name="password" required autocomplete="new-password" />
            </div>

            <div class="form-group">
                <label class="font-size-h6 font-weight-bolder text-dark">{{ __('Confirm Password') }}<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                <input class="form-control form-control-solid h-auto py-7 px-6 rounded-lg border-0" id="password_confirmation" type="password" name="password_confirmation" required autocomplete="new-password" />
            </div>
            <div class="pb-lg-0 pb-5">
                <button type="submit" id="kt_login_singin_form_submit_button" class="btn btn-primary font-weight-bolder font-size-h6 px-8 py-4 my-3 mr-3">{{ __('Reset Password') }}</button>
            </div>
        </form>
                    </div>
                    <!--end::Signin-->
                </div>
                <!--end::Wrapper-->
            </div>
            <!--begin::Content-->

            <!--begin::Aside-->
            <div class="login-aside order-1 order-lg-2 bgi-no-repeat bgi-position-x-right" style="background: #fff">
                <div class="login-conteiner bgi-no-repeat bgi-position-x-right bgi-position-y-bottom" style="background-image: url({{asset('media/bdlandportmap.jpg')}});background-size: cover">
                    {{--                        <!--begin::Aside title-->--}}
                    {{--                        <h3 class="pt-lg-40 pl-lg-20 pb-lg-0 pl-10 py-20 m-0 d-flex justify-content-lg-start font-weight-boldest display5 display1-lg text-white">--}}
                    {{--                            We Got<br/>--}}
                    {{--                            A Surprise<br/>--}}
                    {{--                            For You--}}
                    {{--                        </h3>--}}
                    {{--                        <!--end::Aside title-->--}}
                </div>
            </div>
            <!--end::Aside-->
        </div>
        <!--end::Login-->
    </div>
    <!--end::Main-->
    {{--        <form method="POST" action="{{ route('login') }}">--}}
    {{--            @csrf--}}

    {{--            <div>--}}
    {{--                <x-jet-label for="email" value="{{ __('Email') }}" />--}}
    {{--                <x-jet-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email')" required autofocus />--}}
    {{--            </div>--}}

    {{--            <div class="mt-4">--}}
    {{--                <x-jet-label for="password" value="{{ __('Password') }}" />--}}
    {{--                <x-jet-input id="password" class="block mt-1 w-full" type="password" name="password" required autocomplete="current-password" />--}}
    {{--            </div>--}}

    {{--            <div class="block mt-4">--}}
    {{--                <label for="remember_me" class="flex items-center">--}}
    {{--                    <input id="remember_me" type="checkbox" class="form-checkbox" name="remember">--}}
    {{--                    <span class="ml-2 text-sm text-gray-600">{{ __('Remember me') }}</span>--}}
    {{--                </label>--}}
    {{--            </div>--}}

    {{--            <div class="flex items-center justify-end mt-4">--}}
    {{--                @if (Route::has('password.request'))--}}
    {{--                    <a class="underline text-sm text-gray-600 hover:text-gray-900" href="{{ route('password.request') }}">--}}
    {{--                        {{ __('Forgot your password?') }}--}}
    {{--                    </a>--}}
    {{--                @endif--}}

    {{--                <x-jet-button class="ml-4">--}}
    {{--                    {{ __('Login') }}--}}
    {{--                </x-jet-button>--}}
    {{--            </div>--}}
    {{--        </form>--}}

@endsection

{{-- Scripts Section --}}
@section('scripts')

    {{--    <script src="{{ asset('js/pages/custom/login/login-4.js') }}" type="text/javascript"></script>--}}
@endsection

