{{-- Extends layout --}}
@extends('layout.default_nobody')
@section('styles')
    {{-- Includable CSS --}}
    @yield('styles')

    {{-- Global Theme Styles (used by all pages) --}}
    @foreach(config('layout.resources.css') as $style)
        <link href="{{ config('layout.self.rtl') ? asset(Metronic::rtlCssPath($style)) : asset($style) }}" rel="stylesheet" type="text/css"/>
    @endforeach

    {{-- Layout Themes (used by all pages) --}}
    @foreach (Metronic::initThemes() as $theme)
        <link href="{{ config('layout.self.rtl') ? asset(Metronic::rtlCssPath($theme)) : asset($theme) }}" rel="stylesheet" type="text/css"/>
    @endforeach

    <script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.5/jquery.min.js"></script>
    <!--begin::Page Custom Styles(used by this page)-->
    <link href="css/pages/login/login-4.css" rel="stylesheet" type="text/css"/>
    <!--end::Page Custom Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Main-->
    <div class="d-flex flex-column flex-root">
        <!--begin::Login-->
        <div class="login login-4 wizard d-flex flex-column flex-lg-row flex-column-fluid">
            <!--begin::Content-->
            <div class="login-container order-2 order-lg-1 d-flex flex-center flex-row-fluid px-7 pt-lg-0 pb-lg-0 pt-4 pb-6 bg-white">
                <!--begin::Wrapper-->
                <div class="login-content d-flex flex-column pt-lg-0 pt-12" style="width: 70%;">
                    <!--begin::Logo-->
                    <a href="#" class="login-logo pb-xl-5 pb-5">
                        <img src="{{asset('media/blpa.png')}}" style="width: 100%"  alt=""/>
                    </a>
                    <!--end::Logo-->

                    <!--begin::Signin-->
                    @include('layout.session')
                    @include('layout.error')
                    <div class="login-form">
                        <!--begin::Form-->
        <form method="POST" action="{{ route('register') }}">
            @csrf

            <div class="pb-5" data-wizard-type="step-content" data-wizard-state="current">
                <!--begin::Input-->
                <div class="form-group">
                    <label>নাম (বাংলা) [Name (Bangla)]<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                    <input type="text" class="form-control form-control-solid form-control-lg" name="name_bn" placeholder="Name (bangla)" required @if(old('name_bn'))value="{{old('name_bn')}}"@endif/>
                    {{--                                            <span class="form-text text-muted">Please enter your Address.</span>--}}
                </div>
                <!--end::Input-->

                <!--begin::Input-->
                <div class="form-group">
                    <label>পদবী (Rank) <i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                    <div >
                        @php $ranks = \App\Models\Rank::all(); @endphp
                        <select class="form-control " id="kt_select2_1"  @if(isset($loggedin->employee_id) && isset($employee->rank)) readonly  @else name="rank" @endif required>
                            <option>নির্বাচন করুন</option>
                            @foreach($ranks as $rank)
                                <option value="{{$rank->id}}">{{$rank->name_en}}({{$rank->name_bn}})</option>
                            @endforeach

                        </select>
                    </div>
                <!-- <input type="text" class="form-control form-control-solid form-control-lg" @if(isset($loggedin->employee_id) && isset($employee->rank))readonly  @else name="rank" @endif  placeholder="Rank" required @if(isset($employee->rank))value="{{$employee->rank}}"@endif  style="border: 1px solid rgb(178, 34, 34,.4);"/>
{{--                                            <span class="form-text text-muted">Please enter your Address.</span>--}} -->
                </div>
                <!--end::Input-->
                <!--begin::Input-->
                <div class="form-group">
                    <label>জাতীয় পরিচয় পত্র নম্বর (National ID number)<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                    <input type="number" class="form-control form-control-solid form-control-lg" name="nid" placeholder="National ID number" required @if(old('nid'))value="{{old('nid')}}"@endif/>
                    {{--                                            <span class="form-text text-muted">Please enter your Address.</span>--}}
                </div>
                <div class="form-group row">
                    <label class="col-form-label text-left col-lg-3 col-sm-12">জন্ম তারিখ (Date of birth)<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                    <div class="col-lg-9 col-md-9 col-sm-12">
                        <input required data-date-format="dd-mm-yyyy" readonly class="form-control form-control-lg form-control-solid kt_datepicker" type="text" name="dob" @if(old('dob'))value="{{old('dob')}}"@endif/>

                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-xl-3 col-lg-3 col-form-label">চাকরির ধরন (Service Type) <i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                    <div class="col-lg-9 col-xl-9">
                        <select class="form-control"   name="type_of_entry">
                            <option>নির্বাচন করুন</option>
                            <option value="1">স্থায়ী (Permanent)</option>
                            <option value="2">অস্থায়ী(Temporary)</option>

                        </select>
                    </div>
                </div>
                @php $qoutas = \Aqualink\District\Models\Quota::all() @endphp
                <div class="form-group row">
                    <label class="col-xl-3 col-lg-3 col-form-label">কোটার ধরন (Qouta Type) <i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                    <div class="col-lg-9 col-xl-9">
                        <select required class="form-control" name="quota">
                            <option>নির্বাচন করুন</option>
                            @foreach($qoutas as $qouta)
                                <option value="{{$qouta->id}}">{{$qouta->name_en}}({{$qouta->name_bn}})</option>
                            @endforeach

                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-form-label text-left col-lg-3 col-sm-12">ইমেইল (Email)<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                    <div class="col-lg-9 col-md-9 col-sm-12">
                        <div class="input-group date" >
                            <input name="email" type="email" class="form-control" required @if(old('email'))value="{{old('email')}}"@endif/>
                        </div>
                        <span class="form-text text-muted">এই ইমেইলে নোটিফিকেশন ও আপডেট পাঠানো হবে। </span>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-form-label text-left col-lg-3 col-sm-12">পাসওয়ার্ড (Password)<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                    <div class="col-lg-9 col-md-9 col-sm-12">
                        <div class="input-group date" >
                            <input name="password" type="password" class="form-control" @if(!isset($employee->sms_number)) required @endif/>
                        </div>
                        {{--                                                <span class="form-text text-muted">এই ইমেইল ও পাসওয়ার্ডের মাদ্ধমে কর্মচারী লগইন করতে পারবে। </span>--}}
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-form-label text-left col-lg-3 col-sm-12">Confirm Password<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                    <div class="col-lg-9 col-md-9 col-sm-12">
                        <div class="input-group date" >
                            <input name="password_confirmation" type="password" class="form-control" @if(!isset($employee->sms_number)) required @endif/>
                        </div>
                        {{--                                                <span class="form-text text-muted">এই ইমেইল ও পাসওয়ার্ডের মাদ্ধমে কর্মচারী লগইন করতে পারবে। </span>--}}
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-form-label text-left col-lg-3 col-sm-12">মোবাইল নাম্বার (Contact Number)<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                    <div class="col-lg-9 col-md-9 col-sm-12">
                        <div class="input-group date" >
                            <input name="sms_number" type="number" class="form-control" min="0" required  @if(old('sms_number'))value="{{old('sms_number')}}"@endif/>
                        </div>
                        <span class="form-text text-muted">এই নাম্বারে নোটিফিকেশন ও আপডেট পাঠানো হবে। </span>
                    </div>
                </div>
                <div>
                    <button type="submit" class="btn btn-success font-weight-bold text-uppercase px-9 py-4" >
                        {{--                                                data-wizard-type="action-submit"--}}
                        Register
                    </button>
                    <a class="underline text-sm text-gray-600 hover:text-gray-900 ml-5" href="{{ route('login') }}">
                        {{ __('Already registered?') }}
                    </a>
                    {{--                                            <button type="button" class="btn btn-primary font-weight-bold text-uppercase px-9 py-4" data-wizard-type="action-next">--}}
                    {{--                                                Next--}}
                    {{--                                            </button>--}}
                </div>
            </div>

{{--            <div class="flex items-center justify-end mt-4">--}}


{{--                <x-jet-button class="ml-4">--}}
{{--                    {{ __('Register') }}--}}
{{--                </x-jet-button>--}}
{{--            </div>--}}
        </form>
                    </div>
                    <!--end::Signin-->
                </div>
                <!--end::Wrapper-->
            </div>
            <!--begin::Content-->

            <!--begin::Aside-->
            <div class="login-aside order-1 order-lg-2 bgi-no-repeat bgi-position-x-right" style="background: #fff">
                <div class="login-conteiner bgi-no-repeat bgi-position-x-right bgi-position-y-bottom" style="background-image: url({{asset('media/bdlandportmap.jpg')}});background-size: cover">
                    {{--                        <!--begin::Aside title-->--}}
                    {{--                        <h3 class="pt-lg-40 pl-lg-20 pb-lg-0 pl-10 py-20 m-0 d-flex justify-content-lg-start font-weight-boldest display5 display1-lg text-white">--}}
                    {{--                            We Got<br/>--}}
                    {{--                            A Surprise<br/>--}}
                    {{--                            For You--}}
                    {{--                        </h3>--}}
                    {{--                        <!--end::Aside title-->--}}
                </div>
            </div>
            <!--end::Aside-->
        </div>
        <!--end::Login-->
    </div>

@endsection

{{-- Scripts Section --}}
@section('scripts')

    @foreach(config('layout.resources.js') as $script)
        <script src="{{ asset($script) }}" type="text/javascript"></script>
    @endforeach
    <script>
        $(document).ready(function() {
            $('.kt_datepicker').datepicker({
                rtl: KTUtil.isRTL(),
                todayHighlight: true,
                orientation: 'bottom left',
                templates: 'arrows'
            });
        });
    </script>
@endsection
