{{-- Extends layout --}}
@extends('layout.default_nobody')
@section('styles')
    <!--begin::Page Custom Styles(used by this page)-->
    <link href="css/pages/login/login-4.css" rel="stylesheet" type="text/css"/>
    <!--end::Page Custom Styles-->
@endsection
{{-- Content --}}
@section('content')
    @if (session('status'))
        <div class="mb-4 font-medium text-sm text-green-600">
            {{ session('status') }}
        </div>
    @endif
    <!--begin::Main-->
    <div class="d-flex flex-column flex-root">
        <!--begin::Login-->
        <div class="login login-4 wizard d-flex flex-column flex-lg-row flex-column-fluid">
            <!--begin::Content-->
            <div class="login-container order-2 order-lg-1 d-flex flex-center flex-row-fluid px-7 pt-lg-0 pb-lg-0 pt-4 pb-6 bg-white">
                <!--begin::Wrapper-->
                <div class="login-content d-flex flex-column pt-lg-0 pt-12">
                    <a href="#" class="login-logo pb-xl-20 pb-15">
                        <img src="https://aqualinkbangladesh.com/static/assets/img/aqualink.png" class="max-h-70px" alt=""/>
                    </a>
                    <div class="mb-4 text-sm text-gray-600">
                        {{ __('Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.') }}
                    </div>


                     <x-jet-validation-errors class="mb-4" />
                    <!--begin::Signin-->
                    <div class="login-form">
                        <form class="form" id="kt_login_singin_form"  method="POST" action="{{ route('password.email') }}">
                            @csrf

{{--                            <div class="block">--}}
{{--                                <x-jet-label for="email" value="{{ __('Email') }}" />--}}
{{--                                <x-jet-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email')" required autofocus />--}}
{{--                            </div>--}}
{{--                --}}
{{--                            <div class="flex items-center justify-end mt-4">--}}
{{--                                <x-jet-button>--}}
{{--                                    {{ __('Email Password Reset Link') }}--}}
{{--                                </x-jet-button>--}}
{{--                            </div>--}}
                            <!--begin::Form group-->
                            <div class="form-group">
                                <label class="font-size-h6 font-weight-bolder text-dark">Your Email<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                                <input class="form-control form-control-solid h-auto py-7 px-6 rounded-lg border-0" type="text" name="email" :value="old('email')" autocomplete="off" required autofocus/>
                            </div>
                                <!--begin::Action-->
                                <div class="pb-lg-0 pb-5">
                                    <button type="submit" id="kt_login_singin_form_submit_button" class="btn btn-primary font-weight-bolder font-size-h6 px-8 py-4 my-3 mr-3">Email Password Reset Link</button>
                                </div>
                        </form>
                    </div>
                    <!--end::Signin-->
                </div>
                <!--end::Wrapper-->
            </div>
            <!--begin::Content-->

            <!--begin::Aside-->
            <div class="login-aside order-1 order-lg-2 bgi-no-repeat bgi-position-x-right">
                <div class="login-conteiner bgi-no-repeat bgi-position-x-right bgi-position-y-bottom" style="background-image: url(media/svg/illustrations/login-visual-4.svg);">
                    <!--begin::Aside title-->
                    <h3 class="pt-lg-40 pl-lg-20 pb-lg-0 pl-10 py-20 m-0 d-flex justify-content-lg-start font-weight-boldest display5 display1-lg text-white">
                        We Got<br/>
                        A Surprise<br/>
                        For You
                    </h3>
                    <!--end::Aside title-->
                </div>
            </div>
            <!--end::Aside-->
        </div>
        <!--end::Login-->
    </div>
@endsection

{{-- Scripts Section --}}
@section('scripts')

    {{--    <script src="{{ asset('js/pages/custom/login/login-4.js') }}" type="text/javascript"></script>--}}
@endsection

