{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title">
                <h3 class="card-label">
                    ব্যবহারকারীর তালিকা ( User List )
                </h3>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered nowrap" id="kt_datatable_em">
                <thead class="thead-light">
                <tr>
                    <th>নাম (Name)</th>
                    <th>পদবী (Rank)</th>
                    <th>মোবাইল নাম্বার (Contact Number)</th>
                    <th>ইমেইল (Email)</th>
                    <th>গ্রুপ (Group)</th>
                    <th>Status</th>
                    <th>Action</th>


                </tr>
                </thead>
                <tbody>
                @foreach($users as $user)
                    <tr>
                        <td>{{ $user->name}}</td>
                        <td>{{ $user->rank}}</td>
                        <td>{{ $user->contact}}</td>
                        <td>{{ $user->email}}</td>
                        <td>{{ $user->useraccess->user_group->name}}</td>
                        <td>@if($user->useraccess->active == 1)<span class="badge badge-success">Active</span>@else<span class="badge badge-danger">Disabled</span>@endif</td>
                        <td>
                            <a href="{{route('manage_user.edit',['id'=>$user->id])}}" class="btn btn-outline-primary text-primary mr-5" role="button" ><i class="fa fa-edit"></i></a>
                            <a href="{{route('manage_user.delete',['id'=>$user->id])}}" onclick="return confirm('Are you sure ?');" class="btn btn-outline-danger text-danger mr-5" role="button" ><i class="fa fa-trash"></i></a>
                        </td>
                    </tr>
                @endforeach
                </tbody>

            </table>
            <script>
                $(document).ready(function() {
                    var table = $('#kt_datatable_em');
                    table.DataTable({
                        responsive: true,

                    });
                });
            </script>
        </div>
    </div>
    <!--end::Card-->
@endsection

{{-- Scripts Section --}}
@section('scripts')
    <!--begin::Page Vendors(used by this page)-->
    <script src="{{asset('plugins/custom/datatables/datatables.bundle.js')}}"></script>
    <!--end::Page Vendors-->

    <!--begin::Page Scripts(used by this page)-->
    <script src="{{asset('js/pages/crud/datatables/data-sources/html.js')}}"></script>

@endsection
