{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Custom Styles(used by this page)-->
    <link href="{{ asset('css/pages/wizard/wizard-1.css') }}" rel="stylesheet" type="text/css"/>
    <!--end::Page Custom Styles-->
@endsection
{{-- Content --}}
@section('content')
@php
use Carbon\Carbon;
@endphp
    {{-- Dashboard 1 --}}

    <!--begin::Entry-->
    <div class="d-flex flex-column-fluid">
        <!--begin::Container-->
        <div class=" container ">
            <div class="card card-custom">
                <div class="card-body p-0">
                    <div class="wizard wizard-1" id="kt_wizard_v1" >
@include('layout.error')
                        <div class="row justify-content-center my-10 px-8 my-lg-15 px-lg-10">
                            <div class="col-xl-12 col-xxl-7">
                                <!--begin::Wizard Form-->
                                <form class="form" id="kt_form" action="{{route("manage_user.addtodb")}}" method="post">
                                    @csrf
                                    @if(isset($user->id))<input type="number" name="other" value="{{$user->id}}" hidden>@endif
                                    <!--begin::Wizard Step 1-->
                                    <div class="pb-5" data-wizard-type="step-content" data-wizard-state="current">
                                        <h3 class="mb-10 font-weight-bold text-dark">প্রাথমিক তথ্যাদি (Primary Information)</h3>
                                        <!--begin::Input-->
                                        <div class="form-group row">
                                            <label class="col-form-label text-left col-lg-3 col-sm-12">নাম [Name]<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                                            <div class="col-lg-9 col-md-9 col-sm-12">
                                                <div class="input-group date" >
                                                <input type="text" class="form-control" name="name"  placeholder="Name" required style="border: 1px solid rgb(178, 34, 34,.4);" @if(isset($user->name))value="{{$user->name}}"@endif/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-form-label text-left col-lg-3 col-sm-12">পদবী (Rank)<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                                            <div class="col-lg-9 col-md-9 col-sm-12">
                                                <div class="input-group date" >
                                            <input type="text" class="form-control"  name="rank"  placeholder="Rank" required style="border: 1px solid rgb(178, 34, 34,.4);" @if(isset($user->rank))value="{{$user->rank}}"@endif/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-form-label text-left col-lg-3 col-sm-12">মোবাইল নাম্বার (Contact Number)<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                                            <div class="col-lg-9 col-md-9 col-sm-12">
                                                <div class="input-group date" >
                                                    <input name="contact" type="number" class="form-control" min="0" required style="border: 1px solid rgb(178, 34, 34,.4);"  @if(isset($user->contact))value="{{$user->contact}}"@endif/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-form-label text-left col-lg-3 col-sm-12">গ্রুপ (Group)</label>
                                            <div class=" col-lg-9 col-md-9 col-sm-12">
                                                <select class="form-control " id="kt_select2_1" name="user_group">
                                                    <option>নির্বাচন করুন</option>
                                                    @foreach($usergroups as $usergroup)
                                                    <option value="{{$usergroup->id}}" @if(isset($user->useraccess->user_group_id) && $user->useraccess->user_group_id == $usergroup->id){{__('selected')}}@endif>{{$usergroup->name}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-form-label text-left col-lg-3 col-sm-12">Active status</label>
                                            <div class=" col-lg-9 col-md-9 col-sm-12">
                                                <select class="form-control " id="kt_select2_1" name="active_status">
                                                    <option>নির্বাচন করুন</option>
                                                    <option value="1" @if(isset($user->useraccess->active) && $user->useraccess->active == 1){{__('selected')}}@endif>Active</option>
                                                    <option value="0" @if(isset($user->useraccess->active) && $user->useraccess->active == 0){{__('selected')}}@endif>Disabled</option>

                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-form-label text-left col-lg-3 col-sm-12">ইমেইল (Email)<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                                            <div class="col-lg-9 col-md-9 col-sm-12">
                                                <div class="input-group date" >
                                                    <input name="email" type="email" class="form-control" required style="border: 1px solid rgb(178, 34, 34,.4);" @if(isset($user->email))value="{{$user->email}}"@endif/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-form-label text-left col-lg-3 col-sm-12">পাসওয়ার্ড (Password)</label>
                                            <div class="col-lg-9 col-md-9 col-sm-12">
                                                <div class="input-group date" >
                                                    <input name="password" type="password" class="form-control"/>
                                                </div>
{{--                                                <span class="form-text text-muted">এই ইমেইল ও পাসওয়ার্ডের মাদ্ধমে কর্মচারী লগইন করতে পারবে। </span>--}}
                                            </div>
                                        </div>

                                        <div>
                                            <button type="submit" class="btn btn-success font-weight-bold text-uppercase px-9 py-4" >
                                                @if(isset($user->id)) Update @else Create @endif
                                            </button>
                                        </div>
                                    </div>
                                    <!--end::Wizard Actions-->
                                </form>
                                <!--end::Wizard Form-->
                            </div>
                        </div>
                        <!--end::Wizard Body-->
                    </div>
                    <!--end::Wizard-->
                </div>
                <!--end::Wizard-->
            </div>
        </div>
        <!--end::Container-->
    </div>
    <!--end::Entry-->

@endsection
