{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title">
                <h3 class="card-label">ভাষা পারদর্শিতা (Language)</h3>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered nowrap" id="kt_datatable_em">
                <thead class="thead-light">
                <tr>
                    <th>Name</th>
                    <th>Rank</th>
                    <th>Language Name</th>
                    <th>Read</th>
                    <th>Write</th>
                    <th>Speak</th>
                    {{--                    <th>NID</th>--}}
                    <th>Contact Number</th>
                    <th>Action</th>
                </tr>
                </thead>
                <tbody>
                @foreach($datas as $data)
                    <tr>
                        <td>{{ $data->employee->name}}</td>
                        <td>@if(isset($data->employee->rank) && (int)$data->employee->rank > 0){{ $function->rank()[(int)$data->employee->rank]['name_en']}}@endif</td>
                        <td>@if(isset($data->name) && (int)$data->name > 0){{ $function->language()[(int)$data->name]['name_en']}}@endif</td>
                        <td>@if($data->read == 1)Y <i class="fa fa-check text-success"></i>@else N <i class="fa fa-times text-danger"></i> @endif </td>
                        <td>@if($data->write == 1)Y <i class="fa fa-check text-success"></i>@else N <i class="fa fa-times text-danger"></i> @endif</td>
                        <td>@if($data->speak == 1)Y <i class="fa fa-check text-success"></i>@else N <i class="fa fa-times text-danger"></i> @endif</td>
{{--                        <td>{{ $data->employee->nid}}</td>--}}
                        <td>{{ $data->employee->sms_number}}</td>
                        <td><a href="{{route('employee.employinfopdf',['id'=>$data->employee->id])}}" class="text-primary" role="button" >Details</a></td>
                    </tr>
                @endforeach
                </tbody>

            </table>
            <script>
                $(document).ready(function() {
                    var title = 'LandPortAuthority All Employee '+$('h3.card-label').text();
                    var table = $('#kt_datatable_em');
                    table.DataTable({
                        responsive: true,
                        dom: 'Bfrtip',
                        buttons: [
                            {
                                extend: 'excelHtml5',
                                title: title,
                                exportOptions: {
                                    columns:  ':visible:not(:last-child)'
                                }
                            },
                            {
                                extend: 'pdfHtml5',
                                title: title,
                                orientation: 'landscape',
                                pageSize: 'A4',
                                exportOptions: {
                                    columns:  ':visible:not(:last-child)'
                                }
                            },
                            {
                                extend: 'print',
                                title: title,
                                exportOptions: {
                                    columns:  ':visible:not(:last-child)'
                                },
                                customize: function(win)
                                {

                                    var last = null;
                                    var current = null;
                                    var bod = [];

                                    var css = '@page { size: landscape; }',
                                        head = win.document.head || win.document.getElementsByTagName('head')[0],
                                        style = win.document.createElement('style');

                                    style.type = 'text/css';
                                    style.media = 'print';

                                    if (style.styleSheet)
                                    {
                                        style.styleSheet.cssText = css;
                                    }
                                    else
                                    {
                                        style.appendChild(win.document.createTextNode(css));
                                    }

                                    head.appendChild(style);
                                }
                            },
                            'colvis'

                        ]

                    });
                });
            </script>
        </div>
    </div>
    <!--end::Card-->
@endsection

{{-- Scripts Section --}}
@section('scripts')
    <!--begin::Page Vendors(used by this page)-->
    <script src="{{asset('plugins/custom/datatables/datatables.bundle.js')}}"></script>
    <!--end::Page Vendors-->

    <!--begin::Page Scripts(used by this page)-->
    <script src="{{asset('js/pages/crud/datatables/data-sources/html.js')}}"></script>

@endsection
