{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title">
                <h3 class="card-label">শৃঙ্খলামুলক ব্যবস্থা (Disciplinary Action) {{$nature}} - {{$type}} From {{$startdate}} to {{$enddate}}</h3>
            </div>
        </div>
        <div class="card-header flex-wrap py-3">
            <form action="{{route('report.disciplinary_action')}}" method="get" class="card-title">
                <label class="col-md-1">দণ্ডের প্রকৃতি</label>
                <select class="form-control natureofpenaltyx" id="kt_select2_1" name="nature">
                    <option >All</option>
                    @foreach($function->disciplinary_action_type() as $key=>$disciplinary_action_type)
                        <option value="{{$key}}">{{$disciplinary_action_type[0]}}({{$disciplinary_action_type[1]}})</option>
                    @endforeach
                </select>
                <label>দণ্ডের ধরন</label>
                <select class="form-control penaltytypex" id="kt_select2_1" name="type" >
                    <option class="_0" >All</option>
                    @foreach($function->disciplinary_action_type_name() as $key=>$disciplinary_action_type_name)
                        <option class="_{{$disciplinary_action_type_name[0]}}" value="{{$key}}">{{$disciplinary_action_type_name[1]}}({{$disciplinary_action_type_name[2]}})</option>
                    @endforeach
                </select>
                From <input name="start_date" data-date-format="dd-mm-yyyy" class="form-control form-control-lg form-control-solid kt_datepicker ml-2" type="text" required>
                To <input name="end_date" data-date-format="dd-mm-yyyy" class="form-control form-control-lg form-control-solid kt_datepicker ml-2" type="text" required>
                <button type="submit" class="btn btn-primary ml-2">Search</button>
            </form>
            <script>
                $(document).ready(function() {
                    $(document).on("change",".natureofpenaltyx", function(){
                        $('.penaltytypex').prop('selectedIndex',0);
                        $(".penaltytypex option").attr("hidden",true);
                        $(".penaltytypex option._0").attr("hidden",false).attr("selected",true);
                        $(".penaltytypex option._"+$(this).val()).removeAttr("hidden");
                    });
                });
            </script>
        </div>
        <div class="card-body">
            <table class="table table-bordered nowrap" id="kt_datatable_em">
                <thead class="thead-light">
                <tr>
                    <th>Name</th>
                    <th>Rank</th>
                    <th>Nature of Penalty</th>
                    <th>Type of Penalty</th>
                    <th>Order number</th>
                    <th>Order date</th>
                    <th>Time period Starting date</th>
                    <th>Time period Finishing date</th>
                    <th>Readjusted Salary</th>
                    <th>Comment</th>
                    <th>Contact Number</th>
                    <th>Action</th>
                </tr>
                </thead>
                <tbody>
                @foreach($datas as $data)
                    <tr>
                        <td>{{ $data->employee->name}}</td>
                        <td>@if(isset($data->employee->rank) && (int)$data->employee->rank > 0){{ $function->rank()[(int)$data->employee->rank]['name_en']}}@endif</td>
                        <td>@if(isset($data->nature_of_penalty) && (int)$data->nature_of_penalty > 0 && isset($function->disciplinary_action_type()[(int)$data->nature_of_penalty])){{ $function->disciplinary_action_type()[(int)$data->nature_of_penalty][1]}}@endif</td>
                        <td>@if(isset($data->type_of_penalty) && (int)$data->type_of_penalty > 0 && isset($function->disciplinary_action_type_name()[(int)$data->type_of_penalty])){{ $function->disciplinary_action_type_name()[(int)$data->type_of_penalty][1]}}@endif</td>
                        <td>{{$data->order_number ? $data->order_number:''}}</td>
                        <td>{{$data->order_date ? \Carbon\Carbon::parse($data->order_date)->format('d-m-Y'):''}}</td>
                        <td>{{$data->start_date ? \Carbon\Carbon::parse($data->start_date)->format('d-m-Y'):''}}</td>
                        <td>{{$data->end_date ? \Carbon\Carbon::parse($data->end_date)->format('d-m-Y'):''}}</td>
                        <td>{{$data->requested_salary ? $data->requested_salary:''}}</td>
                        <td>{{$data->comment ? $data->comment:''}}</td>
                        <td>{{ $data->employee->sms_number}}</td>
                        <td><a href="{{route('employee.employinfopdf',['id'=>$data->employee->id])}}" class="text-primary" role="button" >Details</a></td>
                    </tr>
                @endforeach
                </tbody>

            </table>
            <script>
                $(document).ready(function() {
                    var title = 'LandPortAuthority All Employee '+$('h3.card-label').text();
                    // +$('h3.card-label').text()
                    var table = $('#kt_datatable_em');
                    table.DataTable({
                        responsive: true,
                        dom: 'Bfrtip',
                        "lengthMenu": [[50, -1], [50, "All"]],
                        rowGroup: {
                            dataSrc: 1
                        },
                        buttons: [
                            {
                                extend: 'excelHtml5',
                                title: title,
                                exportOptions: {
                                    columns:  ':visible:not(:last-child)'
                                }
                            },
                            {
                                extend: 'pdfHtml5',
                                title: title,
                                orientation: 'landscape',
                                pageSize: 'A4',
                                exportOptions: {
                                    columns:  ':visible:not(:last-child)'
                                }
                            },
                            {
                                extend: 'print',
                                title: title,
                                exportOptions: {
                                    columns:  ':visible:not(:last-child)'
                                },
                                customize: function(win)
                                {

                                    var last = null;
                                    var current = null;
                                    var bod = [];

                                    var css = '@page { size: landscape; }',
                                        head = win.document.head || win.document.getElementsByTagName('head')[0],
                                        style = win.document.createElement('style');

                                    style.type = 'text/css';
                                    style.media = 'print';

                                    if (style.styleSheet)
                                    {
                                        style.styleSheet.cssText = css;
                                    }
                                    else
                                    {
                                        style.appendChild(win.document.createTextNode(css));
                                    }

                                    head.appendChild(style);
                                }
                            },
                            'colvis'

                        ]

                    });
                });
            </script>
        </div>
    </div>
    <!--end::Card-->
@endsection

{{-- Scripts Section --}}
@section('scripts')
    <!--begin::Page Vendors(used by this page)-->
    <script src="{{asset('plugins/custom/datatables/datatables.bundle.js')}}"></script>
    <!--end::Page Vendors-->

    <!--begin::Page Scripts(used by this page)-->
    <script src="{{asset('js/pages/crud/datatables/data-sources/html.js')}}"></script>

@endsection
