{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Entry-->
    <div class="d-flex flex-column-fluid">
        <!--begin::Container-->
        <div class=" container ">
            <!--begin::Card-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-3">
                    <div class="card-title">
                        <h3 class="card-label">
                            Add new Rank
                        </h3>
                    </div>
                </div>
                <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                <div class="card-body">
                    <form action="{{route('rank.add_to_db')}}" method="post">
                        @csrf
                        @isset($rank->id)<input hidden name="others" value="{{$rank->id}}">@endisset
                        <div class="form-group d-flex">
                            <div class="col-md-4 text-right my-auto">Sequence No<i class="fa fa-star-of-life fa-sm text-danger"></i></div>
                            <div class="col-md-7"><input type="number" class="form-control" name="seq_no" @isset($rank->id) value="{{$rank->seq_no}}" @endisset required></div>

                        </div>
                        <div class="form-group d-flex">
                            <div class="col-md-4 text-right my-auto">Rank Name (English)<i class="fa fa-star-of-life fa-sm text-danger"></i></div>
                            <div class="col-md-7"><input type="text" class="form-control" name="name_en" @isset($rank->id) value="{{$rank->name_en}}" @endisset required></div>

                        </div>
                        <div class="form-group d-flex">
                            <div class="col-md-4 text-right my-auto">District Name (Bangla)</div>
                            <div class="col-md-7"><input type="text" class="form-control" name="name_bn" @isset($rank->id) value="{{$rank->name_bn}}" @endisset required></div>
                        </div>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </form>
                </div>
            </div>

        </div>
        <!--end::Container-->
    </div>
    <!--end::Entry-->
@endsection
