{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
@section('content')
    <div class="d-flex flex-column-fluid">
        <!--begin::Container-->
        <div class=" container " style="padding: 0">
            <form action="{{route('payslip.show')}}" method="post">
                @csrf
                <div class="card card-custom gutter-b">
                    <div class="card-header flex-wrap py-3">
                        <div class="col-lg-6 col-md-6 mt-2 mb-2">
                            <h3 class="card-label">For other payslip select month</h3>
                        </div>
                        <div class="col-lg-4 col-md-4 mt-2 mb-2">
                            <input data-date-format="dd-mm-yyyy" readonly class="form-control form-control-lg form-control-solid kt_datepicker" name="old_month" type="text" value=""/>
                        </div>
                        <div class="col-lg-2 col-md-2 mt-2 mb-2">
                            <button type="submit" class="btn btn-primary">Go</button>
                        </div>
                    </div>
                </div>
            </form>
            <!--begin::Card-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-3">
                    <div class="card-title">
                        <h3 class="card-label kt_datatable_em_title">{{\Carbon\Carbon::parse($month)->format('F, Y')}} Payslip Grade 1-9</h3>
                    </div>
                </div>
                <div class="card-body">
                    <!--begin: Datatable-->
                    <table class="table table-bordered table-checkable text-center" id="kt_datatable_em">
                        <thead>
                            <tr>
                                <th rowspan="2">ক্রম</th>
                                <th rowspan="2">নাম ও পদবী</th>
                                @foreach($function->pay_allowance() as $key=>$allowance)
                                    @if($allowance[0] == 1 && in_array($key,$activecode1))
                                        <th rowspan="2">{{$allowance[1]}}</th>
                                    @endif
                                @endforeach
                                <th rowspan="2">সর্বমোট টাকা</th>
                                @php($paydcount = 0)
                                @foreach($function->pay_allowance() as $key=>$allowance)
                                    @if($allowance[0] == 0  && in_array($key,$activecode1))
                                        @php($paydcount++)
                                    @endif
                                @endforeach
                                <th colspan="{{$paydcount}}">কর্তন</th>
                                <th rowspan="2">মোট কর্তন</th>
                                <th rowspan="2">নীট পরিশোধিত</th>
                            </tr>
                            <tr>
                                @foreach($function->pay_allowance() as $key=>$allowance)
                                    @if($allowance[0] == 0  && in_array($key,$activecode1))
                                        <th>{{$allowance[1]}}</th>
                                    @endif
                                @endforeach
                            </tr>
                        </thead>

                        <tbody>
                        @php($n = 0)
                        @foreach($employees as $employee)
                            @if(isset($employee->employee_present_position->grade_no) && $employee->employee_present_position->grade_no <= 9 )
                            @php($n++)
                            <tr>
                                <th>{{$n}}</th>
                                <th>{{$employee->name}} {{$employee->employee_present_position->post}}</th>
                                @foreach($function->pay_allowance() as $key=>$allowance)
                                    @if($allowance[0] == 1 && in_array($key,$activecode1))
                                        <th>@isset($tk[$employee->id][$key]) {{$tk[$employee->id][$key]}}@endisset</th>
                                    @endif
                                @endforeach
                                <th>{{$employee->pay_slip_plus->sum('taka')}}</th>
                                @foreach($function->pay_allowance() as $key=>$allowance)
                                    @if($allowance[0] == 0 && in_array($key,$activecode1))
                                        <th>@isset($tk[$employee->id][$key]){{$tk[$employee->id][$key]}}@endisset</th>
                                    @endif
                                @endforeach
                                <th>{{$employee->pay_slip_minus->sum('taka')}}</th>
                                <th>{{$employee->pay_slip_plus->sum('taka') - $employee->pay_slip_minus->sum('taka')}}</th>
                            </tr>
                            @endif
                        @endforeach
                        </tbody>

                    </table>
                    <!--end: Datatable-->
                </div>
            </div>
            <!--begin::Card-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-3">
                    <h3 class="card-label kt_datatable_em_title2">{{\Carbon\Carbon::parse($month)->format('F, Y')}} Payslip Grade 10-20</h3>
                </div>
                <div class="card-body">
                    <!--begin: Datatable-->
                    <table class="table table-bordered table-checkable text-center" id="kt_datatable_em2">
                        <thead>
                        <tr>
                            <th rowspan="2">ক্রম</th>
                            <th rowspan="2">নাম ও পদবী</th>
                            @foreach($function->pay_allowance() as $key=>$allowance)
                                @if($allowance[0] == 1 && in_array($key,$activecode2))
                                    <th rowspan="2">{{$allowance[1]}}</th>
                                @endif
                            @endforeach
                            <th rowspan="2">সর্বমোট টাকা</th>
                            @php($paydcount = 0)
                            @foreach($function->pay_allowance() as $key=>$allowance)
                                @if($allowance[0] == 0  && in_array($key,$activecode2))
                                    @php($paydcount++)
                                @endif
                            @endforeach
                            <th colspan="{{$paydcount}}">কর্তন</th>
                            <th rowspan="2">মোট কর্তন</th>
                            <th rowspan="2">নীট পরিশোধিত</th>
                        </tr>
                        <tr>
                            @foreach($function->pay_allowance() as $key=>$allowance)
                                @if($allowance[0] == 0  && in_array($key,$activecode2))
                                    <th>{{$allowance[1]}}</th>
                                @endif
                            @endforeach
                        </tr>
                        </thead>

                        <tbody>
                        @php($n = 0)
                        @foreach($employees as $employee)
                            @if(isset($employee->employee_present_position->grade_no) && $employee->employee_present_position->grade_no > 9 )
                                @php($n++)
                                <tr>
                                    <th>{{$n}}</th>
                                    <th>{{$employee->name}} {{$employee->employee_present_position->post}}</th>
                                    @foreach($function->pay_allowance() as $key=>$allowance)
                                        @if($allowance[0] == 1 && in_array($key,$activecode2))
                                            <th>@isset($tk[$employee->id][$key]) {{$tk[$employee->id][$key]}}@endisset</th>
                                        @endif
                                    @endforeach
                                    <th>{{$employee->pay_slip_plus->sum('taka')}}</th>
                                    @foreach($function->pay_allowance() as $key=>$allowance)
                                        @if($allowance[0] == 0 && in_array($key,$activecode2))
                                            <th>@isset($tk[$employee->id][$key]){{$tk[$employee->id][$key]}}@endisset</th>
                                        @endif
                                    @endforeach
                                    <th>{{$employee->pay_slip_minus->sum('taka')}}</th>
                                    <th>{{$employee->pay_slip_plus->sum('taka') - $employee->pay_slip_minus->sum('taka')}}</th>
                                </tr>
                            @endif
                        @endforeach
                        </tbody>

                    </table>
                    <!--end: Datatable-->
                </div>
            </div>

        </div>
    </div>
    <!--end::Entry-->
@endsection

{{-- Scripts Section --}}
@section('scripts')
    <script src="{{asset('plugins/custom/datatables/datatables.bundle.js')}}"></script>
    <script>
        $(document).ready(function() {
            var title = 'LandPortAuthority All Employee '+$('h3.kt_datatable_em_title').text();
            var table = $('#kt_datatable_em');
            table.DataTable({
                responsive: true,
                dom: 'Bfrtip',
                buttons: [
                    {
                        extend: 'excelHtml5',
                        title: title,
                        exportOptions: {
                            columns:  ':visible'
                        }
                    },
                    // {
                    //     extend: 'pdfHtml5',
                    //     title: title,
                    //     orientation: 'landscape',
                    //     pageSize: 'A4',
                    //     exportOptions: {
                    //         // columns:  ':visible'
                    //     }
                    // },
                    {
                        extend: 'print',
                        title: title,
                        exportOptions: {
                            columns:  ':visible'
                        },
                        customize: function(win)
                        {

                            var last = null;
                            var current = null;
                            var bod = [];

                            var css = '@page { size: landscape; }',
                                head = win.document.head || win.document.getElementsByTagName('head')[0],
                                style = win.document.createElement('style');

                            style.type = 'text/css';
                            style.media = 'print';

                            if (style.styleSheet)
                            {
                                style.styleSheet.cssText = css;
                            }
                            else
                            {
                                style.appendChild(win.document.createTextNode(css));
                            }

                            head.appendChild(style);
                        }
                    },
                    'colvis'

                ]

            });
        });
        $(document).ready(function() {
            var title2 = 'LandPortAuthority All Employee '+$('h3.kt_datatable_em_title2').text();
            var table2 = $('#kt_datatable_em2');
            table2.DataTable({
                responsive: true,
                dom: 'Bfrtip',
                buttons: [
                    {
                        extend: 'excelHtml5',
                        title: title2,
                        exportOptions: {
                             columns:  ':visible'
                        }
                    },
                    // {
                    //     extend: 'pdfHtml5',
                    //     title: title,
                    //     orientation: 'landscape',
                    //     pageSize: 'A4',
                    //     exportOptions: {
                    //         // columns:  ':visible'
                    //     }
                    // },
                    {
                        extend: 'print',
                        title: title2,
                        exportOptions: {
                             columns:  ':visible'
                        },
                        customize: function(win)
                        {

                            var last = null;
                            var current = null;
                            var bod = [];

                            var css = '@page { size: landscape; }',
                                head = win.document.head || win.document.getElementsByTagName('head')[0],
                                style = win.document.createElement('style');

                            style.type = 'text/css';
                            style.media = 'print';

                            if (style.styleSheet)
                            {
                                style.styleSheet.cssText = css;
                            }
                            else
                            {
                                style.appendChild(win.document.createTextNode(css));
                            }

                            head.appendChild(style);
                        }
                    },
                    'colvis'

                ]

            });
        });
    </script>
@endsection
