{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Entry-->
    <div class="d-flex flex-column-fluid">
        <!--begin::Container-->
        <div class=" container ">
            <!--begin::Card-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-3">
                    <div class="card-title">
                        <h3 class="card-label">
                            Pay Slip Generate
                        </h3>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{route('payslip.add_to_db')}}" method="post">
                        @csrf
                        <div class="form-group row d-flex">
                            <label class="col-lg-6 col-xl-6 col-form-label text-right">Month <i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                            <input data-date-format="dd-mm-yyyy" readonly class="form-control form-control-lg form-control-solid kt_datepicker col-lg-6 col-xl-6" type="text" name="month" required/>
                        </div>
                        <div class="form-group row p-3  my-auto">
                            <div class="col-lg-6 col-xl-6 col-form-label  text-right text-warning">Check All</div>
                            <div class="col-lg-6 col-xl-6"><input id="checkAll" type="checkbox" class="form-check-input ml-2 mt-4"></div>
                        </div>
                        <div class="form-group row p-3  my-auto">
                            <div class="col-lg-12 col-xl-12 col-form-label  text-center"><h3>বর্তমান মুল বেতন ও ভাতাদি (Basic pay and allowance at Present)</h3></div>
                        </div>
                        @foreach($function->pay_allowance() as $key=>$code)
                            @if($code[0] == 1)
                            <div class="form-group row p-3  my-auto">
                                <div class="col-lg-6 col-xl-6 col-form-label  text-right">{{$code[1]}} [{{$code[2]}}]</div>
                                <div class="col-lg-6 col-xl-6"><input name="payslip_code[{{$key}}]" type="checkbox" class="form-check-input ml-2 mt-4"></div>
                            </div>
                            @endif
                        @endforeach
                        <div class="form-group row p-3  my-auto">
                            <div class="col-lg-12 col-xl-12 col-form-label  text-center"><h3>কর্তনসমূহ (Deductions)</h3></div>
                        </div>
                        @foreach($function->pay_allowance() as $key=>$code)
                            @if($code[0] == 0)
                                <div class="form-group row p-3  my-auto">
                                    <div class="col-lg-6 col-xl-6 col-form-label  text-right">{{$code[1]}} [{{$code[2]}}]</div>
                                    <div class="col-lg-6 col-xl-6"><input name="payslip_code[{{$key}}]" type="checkbox" class="form-check-input ml-2 mt-4"></div>
                                </div>
                            @endif
                        @endforeach
                        <div class="form-group row p-3  my-auto">
                            <div class="col-lg-12 col-xl-12 col-form-label  text-center"><button type="submit" class="btn btn-primary">Submit</button></div>
                        </div>
                    </form>
                    <script>
                        $(document).ready(function() {
                            $("#checkAll").click(function () {
                                $('input:checkbox').not(this).prop('checked', this.checked);
                            });
                        });
                    </script>
                </div>
            </div>

        </div>
        <!--end::Container-->
    </div>
    <!--end::Entry-->
@endsection
