{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title">
                <h3 class="card-label">
                    ছুটির ব্যবহার(Leave Uses)
                </h3>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered nowrap" id="kt_datatable_em">
                <thead class="thead-light">
                <tr>
                    <th>বছর (Year)</th>
                    <th>নাম (Name)</th>
                    <th>নাম্বার (Contact)</th>
                    <th>ধরন (Type)</th>
                    <th>মোট পরিমাণ (Total balance)</th>
                    <th>ব্যবহারের পরিমাণ (Used)</th>
                    <th>অব্যবহৃত(Remaining)</th>
                    <th>পদবী (Rank)</th>
                    <th>NID</th>

                </tr>
                </thead>
                <tbody>
                @foreach($allstatus as $status)
                    <tr>
                        <td>Y-{{ date('Y', strtotime($status->date))}}</td>
                        <td>{{ $status->employee->name}}</td>
                        <td>{{ $status->employee->sms_number}}</td>
                        <td>{{ $status->leavetype->name}}</td>
                        <td>{{ $status->total}}</td>
                        <td>{{ $status->used}}</td>
                        <td>{{ $status->total - $status->used}}</td>
                        <td>{{ $status->employee->rank}}</td>
                        <td>{{ $status->employee->nid}}</td>
                    </tr>
                @endforeach
                </tbody>

            </table>
            <script>
                $(document).ready(function() {
                    var table = $('#kt_datatable_em');
                    table.DataTable({
                        responsive: true,

                    });
                });
            </script>
        </div>
    </div>
    <!--end::Card-->
@endsection

{{-- Scripts Section --}}
@section('scripts')
    <!--begin::Page Vendors(used by this page)-->
    <script src="{{asset('plugins/custom/datatables/datatables.bundle.js')}}"></script>
    <!--end::Page Vendors-->

    <!--begin::Page Scripts(used by this page)-->
    <script src="{{asset('js/pages/crud/datatables/data-sources/html.js')}}"></script>

@endsection
