{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title w-100">
                <h3 class="card-label col-lg-9 col-md-6 com-sm-12 my-auto">
                    ছুটির ধরণের তালিকা ( Leave Type list )
                </h3>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered nowrap" id="kt_datatable_em">
                <thead class="thead-light">
                    <tr>
                        <th>নাম (Name)</th>
                        <th>Balance</th>
                        <th>My Remaining Balance</th>
                        <th>End Time</th>
                        <th>পর্যায়ক্রমিক (Period)</th>
                        <th>সর্বোচ্চ সীমা ছারাতে পারবে ( Exceed Maximum Limit )</th>
                        <th>সমর্থনকারী কাগজপত্র লাগবে (Supporting Documents)</th>
                        <th>সর্বনিম্ন কতদিন হলে সমর্থনকারী কাগজপত্র লাগবে ( Minimum Days for SD)</th>
                        <th>জের টানতে পারবে (Carry Forward)</th>
                        <th>Day interval ( for earned leave )</th>
                        <th>Action</th>

                    </tr>
                </thead>
                <tbody>
                    @foreach($leave_type_lists as $list)
                        <tr>
                           <td>{{ $list->name }}</td>
                           <td>{{ $list->balance }}</td>
                           <td>{{ ($list->myleavestatus->total - $list->myleavestatus->used) }}</td>
                           <td>{{ \Carbon\Carbon::parse($list->date)->format('F, Y') }}</td>
                            <td>
                                <div class="custom-control custom-checkbox mb-3">
                                    @if($list->time_period == 5 && isset($list->time_period_day)){{$list->time_period_day}}@endif
                                </div>
                            </td>
                           <td>
                                <div class="custom-control custom-checkbox mb-3">
                                    <input class="custom-control-input" type="checkbox" @if($list->exceed_maximum_limit) checked @endif>
                                    <label class="custom-control-label"></label>
                                </div>
                            </td>

                            <td>
                                <div class="custom-control custom-checkbox mb-3">
                                    <input class="custom-control-input" type="checkbox" @if($list->supporting_documents) checked @endif>
                                    <label class="custom-control-label"></label>
                                </div>
                            </td>

                           <td>@if($list->supporting_documents) {{ $list->minimum_days }} @else - @endif</td>

                           <td>
                                <div class="custom-control custom-checkbox mb-3">
                                    <input class="custom-control-input" type="checkbox" @if($list->carry_forward) checked @endif>
                                    <label class="custom-control-label"></label>
                                </div>
                            </td>
                            <td>
                                <div class="custom-control custom-checkbox mb-3">
                                    @if($list->time_period == 1) Yearly @endif
                                    @if($list->time_period == 2) Half Yearly @endif
                                    @if($list->time_period == 3) Quarterly @endif
                                    @if($list->time_period == 4) Monthly @endif
                                    @if($list->time_period == 5)After Specific Working day @endif
                                </div>
                            </td>
                            <td>
                                <a href="{{route('leave.edit_leave_type',['id'=>$list->id])}}"><i class="fa fa-edit text-primary"></i></a>
                            </td>

                        </tr>
                    @endforeach
                </tbody>
            </table>

                        </div>
                    </div>
                </div> <!-- /.row -->
                <div class="card-body"></div>
            </div>
        </div><!-- /# column -->
    </div>
    <!--  /Traffic -->


    <script>
        $(document).ready(function() {
            var table = $('#kt_datatable_em');
            table.DataTable({
                responsive: true,

            });
        });
    </script>
    </div>
    </div>
    <!--end::Card-->

@endsection
{{-- Scripts Section --}}
@section('scripts')
    <!--begin::Page Vendors(used by this page)-->
    <script src="{{asset('plugins/custom/datatables/datatables.bundle.js')}}"></script>
    <!--end::Page Vendors-->

    <!--begin::Page Scripts(used by this page)-->
    <script src="{{asset('js/pages/crud/datatables/data-sources/html.js')}}"></script>

@endsection


