{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title">
                <h3 class="card-label">
                    ছুটির অনুরোধ (Leave Application)
                </h3>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered nowrap" id="kt_datatable_em">
                <thead class="thead-light">
                    <tr>
                        <th>তারিখ (Date)</th>
                        <th>ছুটির ধরন (Leave Type)</th>
                        <th>দিনের ধরন (Day Type)</th>
                        <th>শুরু (Begin Date)</th>
                        <th>শেষ (End Date)</th>
                        <th>মোট দিন (Total Days)</th>
                        <th>অবস্থা (Status)</th>
                        <th>Last Updated</th>
                        <th>Action</th>


                    </tr>
                </thead>
                <tbody>
                    @foreach($leave_lists as $leave_list)
                        <tr style="background: @if($leave_list->approval_status == 2){{__("#d2f6c5")}}@elseif($leave_list->approval_status == 1){{__("#ffe2ff")}}@endif">
                            <td>{{ date('Y-m-d G:i', strtotime($leave_list->created_at))}}</td>
                            <td>{{ $leave_list->leavetype->name}}</td>
                            <td>@if($leave_list->day_status == 2) Half Day @else Full Day @endif</td>
                            <td>{{ date('d M Y', strtotime($leave_list->begin_date))}}</td>
                            <td>{{ date('d M Y', strtotime($leave_list->end_date))}}</td>
                            <td>{{ $leave_list->days}}</td>
                            <td class="font-weight-bold">@if($leave_list->approval_status == 2)<span class="text-success">Approved</span>
                                @elseif($leave_list->approval_status == 1)<span class="text-danger">Rejected</span> @else <span class="text-primary">Pending</span> @endif</td>
{{--                                            <td>@if($leave_list->approval_status <1)<a href="{{route('view_leave_requst',['id'=>$leave_list->id])}}" class="text-primary" role="button" ><i class="fas fa-edit"></i></a>@endif</td>--}}
                            <td>{{ date('Y-m-d G:i', strtotime($leave_list->updated_at))}}</td>
                            <td>@if($leave_list->approval_status == 0 )
                                    <a href="{{route('myleave.edit_leave',['id'=>$leave_list->id])}}" class="mr-5" role="button" ><i class="fa fa-pen-alt text-primary"></i> </a>
                                    <a href="{{route('myleave.delete_leave',['id'=>$leave_list->id])}}" role="button" ><i class="fa fa-trash text-danger"></i></a>
                                @endif</td>
{{--                            <td><a href="" class="text-primary" role="button" >Details</a></td>--}}
                        </tr>
                    @endforeach
                </tbody>

            </table>
            <script>
                $(document).ready(function() {
                    var table = $('#kt_datatable_em');
                    table.DataTable({
                        responsive: true,

                    });
                });
            </script>
        </div>
    </div>
    <!--end::Card-->

@endsection
{{-- Scripts Section --}}
@section('scripts')
    <!--begin::Page Vendors(used by this page)-->
        <script src="{{asset('plugins/custom/datatables/datatables.bundle.js')}}"></script>
        <!--end::Page Vendors-->

        <!--begin::Page Scripts(used by this page)-->
        <script src="{{asset('js/pages/crud/datatables/data-sources/html.js')}}"></script>

@endsection
