{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title">
                <h3 class="card-label">
                    Apply
                </h3>
            </div>
        </div>
        <div class="card-body">
                        <form role="form" enctype="multipart/form-data" method="POST" action="{{ route('myleave.post_apply') }}">
                            @csrf
<input aria-label="" hidden type="text" readonly name="other" value="@if(isset($application->id)){!! $application->id !!}@endif">
                            <div class="row">
                                <div class="col-md-6">


                                    <div class="form-group">
                                        <div class="input-group input-group-alternative mb-3">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">
                                                    <i class="fas fa-list-ol"></i>
                                                    <i style="color:red">*</i>&nbsp;Leave Type
                                                 </span>
                                            </div>

                                            <select id="leave_id" class="form-control" name="leave_id" required style="border: 1px solid rgb(178, 34, 34,.4);">
                                                <option selected="true" value="" disabled="disabled">Select Leave Type</option>
                                                @foreach($leave_list as $leave)
                                                <option
                                                    @if(isset($application->leave_id) && ($application->leave_id == $leave->id)) selected @endif
                                                    value="{{ $leave->id }}">{{ $leave->name }}</option>
                                                @endforeach
                                            </select>


                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <div class="input-group input-group-alternative mb-3">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">
                                                    <i class="fas fa-clock"></i>
                                                    <i style="color:red">*</i>&nbsp;Day Status
                                                </span>
                                            </div>

                                            <select id="day_status" class="form-control" name="day_status" required style="border: 1px solid rgb(178, 34, 34,.4);">
                                                <option value="" selected="true" disabled="disabled">Select Day Status</option>
                                                <option  @if(isset($application->day_status) && ($application->day_status == 1)) selected @endif value="1">Full Day</option>
                                                <option @if(isset($application->day_status) && ($application->day_status == 2)) selected @endif value="2">Half Day</option>
                                            </select>

                                        </div>
                                    </div>

                                    <div class="form-group{{ $errors->has('begin_date') ? ' has-danger' : '' }}">
                                        <div class="input-group input-group-alternative mb-3">

                                            <div class="input-group-prepend">
                                                <span class="input-group-text">
                                                    <i class="fas fa-calendar-alt"></i>
                                                    <i style="color:red">*</i>&nbsp;Start Day
                                                </span>
                                            </div>

                                            <input id="begin_date" class="form-control{{ $errors->has('begin_date') ? ' is-invalid' : '' }}" placeholder="{{ __('Beginning of Leave') }}" type="date" name="begin_date"
                                                   @if(isset($application->begin_date)) value="{{ $application->begin_date }}"
                                                  @else value="{{ old('begin_date') }}" @endif required style="border: 1px solid rgb(178, 34, 34,.4);">

                                        </div>
                                        @if ($errors->has('begin_date'))
                                            <span class="invalid-feedback" style="display: block;" role="alert">
                                                <strong>{{ $errors->first('begin_date') }}</strong>
                                            </span>
                                        @endif
                                    </div>

                                    <div class="form-group{{ $errors->has('end_date') ? ' has-danger' : '' }}">
                                        <div class="input-group input-group-alternative mb-3">

                                            <div class="input-group-prepend">
                                                <span class="input-group-text">
                                                    <i class="fas fa-calendar-alt"></i>
                                                    <i style="color:red">*</i>&nbsp;End Day
                                                </span>
                                            </div>

                                            <input id="end_date" class="form-control{{ $errors->has('end_date') ? ' is-invalid' : '' }}" placeholder="{{ __('End of Leave') }}" type="date" name="end_date"
                                                   @if(isset($application->end_date)) value="{{ $application->end_date }}"
                                                   @else value="{{ old('end_date') }}" @endif required style="border: 1px solid rgb(178, 34, 34,.4);">


                                        </div>
                                        <div id="end_dateerro"></div>
                                        @if ($errors->has('end_date'))
                                            <span class="invalid-feedback" style="display: block;" role="alert">
                                                <strong>{{ $errors->first('end_date') }}</strong>
                                            </span>
                                        @endif
                                    </div>



                                </div>

                                <div class="col-md-6">

                                    <div class="form-group py-2">
                                            <label>Remaining Balance: </label> <span><strong id="balance">@if(isset($remaining)){{$remaining}}@else 0 @endif</strong></span>
                                    </div>

                                    <div class="form-group{{ $errors->has('additional_info') ? ' has-danger' : '' }}">
                                        <div class="input-group input-group-alternative mb-3">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><i class="fas fa-question-circle"></i></span>
                                            </div>
                                            <textarea  style="resize: none;" class="form-control{{ $errors->has('additional_info') ? ' is-invalid' : '' }}" placeholder="{{ __('Write Cause of Leave') }}" rows="8" name="additional_info">@if(isset($application->additional_info)){!! $application->additional_info !!}@else{{ old('additional_info') }}@endif</textarea>
                                        </div>
                                    </div>

                                    <div id="supporting_document">

                                    </div>



                                </div>
                            </div>


                            <div class="text-center">
                                <button id="formsubmits" type="submit" class="btn btn-primary mt-4">@if(isset($remaining)) Update @else{{ __('Request Leave') }}@endif</button>
                            </div>
                        </form>
            <div class="card-body">
                @if(isset($image))
                    @for($x=0;$x<count($image)-1;$x++)
                        <img style="width: 400px;" src="{{asset($image[$x])}}" alt=""/></br>
                    @endfor
                @endif
            </div>
            </div>
        </div>
        <!--end::Card-->

@endsection
@section('scripts')
    <script type="text/javascript">

        var start,end,sd,remaining,half,carryforward;
        $( "#leave_id" ).change(function() {
            loadRemainingBalance($( this ).val());
            // $( "select option:selected" ).each(function() {
            //
            // });
        });
        $( "#day_status" ).change(function() {
            half = $( this ).val();
            var days = 0;
            if(end){
                diff = new Date(end - start);
                if(half ==2){  days = (diff/1000/60/60/24 + 1)/2;} else { days = diff/1000/60/60/24 + 1;}
                if(days <1){ document.getElementById('end_dateerro').innerHTML = '<div class="text-dark alert alert-warning" role="alert">Start day must be earlier than end day</div>'; }
                if(days > sd){
                    document.getElementById('supporting_document').innerHTML='<a onclick="addfiles()" role="button" class="btn btn-primary text-white mb-4">Add more file</a></br><input type="file" name="supporting_document[]" required style="border: 1px solid rgb(178, 34, 34,.4);">';
                } else {
                    document.getElementById('supporting_document').innerHTML= '';
                }
                if(remaining < 1 && carryforward < 1){
                    $('#formsubmits').prop('disabled', true);
                    document.getElementById('end_dateerro').innerHTML = '<div class="text-dark alert alert-warning" role="alert">You have no leave left . Contact with HR</div>';

                } else if (days > remaining && carryforward > 0){
                    $('#formsubmits').prop('disabled', false);
                    document.getElementById('end_dateerro').innerHTML = '<div class="text-dark alert alert-warning" role="alert">You selected days('+(days)+') are more than your limit . without strong reason your leave application will get rejected</div>';
                } else {
                    $('#formsubmits').prop('disabled', false);
                    document.getElementById('end_dateerro').innerHTML = '<div class="text-dark alert alert-warning" role="alert">You selected '+days+' days</div>';
                }
            }
        });

        $( "#begin_date" ).change(function() {
            start = new Date($( this ).val()) ;
            if(end){

                diff = new Date(end - start);
                if(half == 2){ var days = (diff/1000/60/60/24 + 1)/2;} else {var days = diff/1000/60/60/24 + 1;}

                 if(days <1){ document.getElementById('end_dateerro').innerHTML = '<div class="text-dark alert alert-warning" role="alert">Start day must be earlier than end day</div>'; }
                if(days > sd){
                    document.getElementById('supporting_document').innerHTML='<a onclick="addfiles()" role="button" class="btn btn-primary text-white mb-4">Add more file</a></br><input type="file" name="supporting_document[]" required style="border: 1px solid rgb(178, 34, 34,.4);">';
                } else {
                    document.getElementById('supporting_document').innerHTML= '';
                }

                if(remaining < 1 && carryforward < 1){
                    $('#formsubmits').prop('disabled', true);
                    document.getElementById('end_dateerro').innerHTML = '<div class="text-dark alert alert-warning" role="alert">You have no leave left . Contact with HR</div>';

                } else if (days > remaining && carryforward > 0){
                    $('#formsubmits').prop('disabled', false);
                    document.getElementById('end_dateerro').innerHTML = '<div class="text-dark alert alert-warning" role="alert">You selected days('+(days)+') are more than your limit . without strong reason your leave application will get rejected</div>';
                } else {
                    $('#formsubmits').prop('disabled', false);
                    document.getElementById('end_dateerro').innerHTML = '<div class="text-dark alert alert-warning" role="alert">You selected '+days+' days</div>';
                }
            }
        });
        $( "#end_date" ).change(function() {
            end =  new Date($( this ).val()) ;
            // console.log(end);
             if(start){
                 diff = new Date(end - start);
                 if(half ==2){ var days = (diff/1000/60/60/24 + 1)/2;} else {var days = diff/1000/60/60/24 + 1;}
                 if(days <1){ document.getElementById('end_dateerro').innerHTML = '<div class="text-dark alert alert-warning" role="alert">Start day must be earlier than end day</div>'; }
                 if(days > sd){
                     document.getElementById('supporting_document').innerHTML='<a onclick="addfiles()" role="button" class="btn btn-primary text-white mb-4">Add more file</a></br><input type="file" name="supporting_document[]" required style="border: 1px solid rgb(178, 34, 34,.4);">';
                 } else {
                     document.getElementById('supporting_document').innerHTML= '';
                 }

                 if(remaining < 1 && carryforward < 1){
                     $('#formsubmits').prop('disabled', true);
                     document.getElementById('end_dateerro').innerHTML = '<div class="text-dark alert alert-warning" role="alert">You have no leave left . Contact with HR</div>';

                 } else if (days > remaining && carryforward > 0){
                     $('#formsubmits').prop('disabled', false);
                     document.getElementById('end_dateerro').innerHTML = '<div class="text-dark alert alert-warning" role="alert">You selected days('+(days)+') are more than your limit . without strong reason your leave application will get rejected</div>';
                 } else {
                     $('#formsubmits').prop('disabled', false);
                     document.getElementById('end_dateerro').innerHTML = '<div class="text-dark alert alert-warning" role="alert">You selected '+days+' days</div>';
                 }
             }
        });


        function addfiles(){
            $('#supporting_document').append('</br><input class="mt-3" type="file" name="supporting_document[]">');
        }
        function loadRemainingBalance(id){
            if(id > 0) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                jQuery.ajax({
                    url: "{{route('myleave.get_remaining_balance')}}",
                    method: 'post',
                    data: {
                        id: id,
                    },
                    success: function (result) {
                        $('#balance').text(result.remaining);
                        remaining = result.remaining;
                        sd = result.sd;
                        carryforward = result.carryforward;
                    }
                });
            }
        }




    </script>
@endsection
