{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title">
                <h3 class="card-label">
                    @if(isset($leave->employee->name)){{$leave->employee->name}}@endif leave request
                </h3>
            </div>
        </div>
        <div class="card-body">

        <h4 class="box-title"> @if(isset($leave->approval_status)) @if($leave->approval_status == 2)<span class="badge badge-success">Approved</span>
            @elseif($leave->approval_status == 1)<span class="badge badge-danger">Rejected</span> @else <span class="badge badge-primary">Pending</span> @endif @endif</h4>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card-body">
{{--                            @include('backendlayout.session')--}}
{{--                            @include('backendlayout.error')--}}
                            @if($next == $leave->id)
                                <div class="alert alert-danger" role="alert">
                                    This is the last leave request
                                </div>
                            @endif
    <div class="form-control d-flex mt-2">
        <div class="col-md-4">Name</div>
        <div class="col-md-8">@if(isset($leave->employee->name)){{$leave->employee->name}}@endif</div>
    </div>
                            <div class="form-control d-flex mt-2">
                                <div class="col-md-4">Rank</div>
                                <div class="col-md-8">@if(isset($leave->employee->rank)){{$leave->employee->rank}}@endif</div>
                            </div>
                            <div class="form-control d-flex mt-2">
                                <div class="col-md-4">Contact</div>
                                <div class="col-md-8">@if(isset($leave->employee->sms_number)){{$leave->employee->sms_number}}@endif</div>
                            </div>
    <div class="form-control d-flex mt-2">
        <div class="col-md-4">Email</div>
        <div class="col-md-8">@if(isset($leave->employee->email)){{$leave->employee->email}}@endif</div>
    </div>
    <div class="form-control d-flex mt-2">
        <div class="col-md-4">Time</div>
        <div class="col-md-8">@if(isset($leave->created_at)){{ date('d M Y', strtotime($leave->created_at))}}@endif</div>
    </div>
    <div class="form-control d-flex mt-2">
        <div class="col-md-4">Leave Type</div>
        <div class="col-md-8">@if(isset($leave->leavetype->name)){{ $leave->leavetype->name}}@endif</div>
    </div>
    <div class="form-control d-flex mt-2">
        <div class="col-md-4">Applied Type</div>
        <div class="col-md-8 text-danger">@if(isset($leave->day_status))@if($leave->day_status == 2) Half Day @else Full Day @endif @endif</div>
    </div>
    <div class="form-control d-flex mt-2">
        <div class="col-md-4">Requested Days</div>
        <div class="col-md-8 text-info">@if(isset($leave->days)){{ $leave->days}}@endif</div>
    </div>
    <div class="form-control d-flex mt-2">
        <div class="col-md-4">Begin Date</div>
        <div class="col-md-8 text-danger">@if(isset($leave->begin_date)){{ date('d M Y', strtotime($leave->begin_date))}}@endif</div>
    </div>
    <div class="form-control d-flex mt-2">
        <div class="col-md-4">End Date</div>
        <div class="col-md-8 text-danger">@if(isset($leave->end_date)){{ date('d M Y', strtotime($leave->end_date))}}@endif</div>
    </div>
     <div class="form-control d-flex mt-2">
        <div class="col-md-4">Status</div>
        <div class="col-md-8">@if(isset($leave->approval_status)) @if($leave->approval_status == 2)<span class="badge badge-success">Approved</span>
     @elseif($leave->approval_status == 1)<span class="badge badge-danger">Rejected</span> @else <span class="badge badge-primary">Pending</span> @endif @endif</div>
    </div>
    <div class="form-control d-flex mt-2">
        <div class="col-md-4"><span class="badge badge-warning">Comment</span></div>
        <div class="col-md-8">
            @if(isset($leave->additional_info)){{$leave->additional_info}}@endif
        </div>
    </div>

    <div class="form-group d-flex d-flex" style="margin-top: 20px">
        @if(isset($leave->id))
            @if($prev != $leave->id)
            <a href="{{route('leave.view_leave',['id'=>$prev])}}" class="btn btn-primary">Previous</a>
            @endif
            <form action="{{route('leave.post_view_leave',['id'=>$leave->id])}}" method="post" class="m-auto">
                @csrf <input hidden name="ap" value="2">
                <button type="submit" class="btn btn-success">Approve</button>
            </form>
            <form action="{{route('leave.post_view_leave',['id'=>$leave->id])}}" method="post" class="m-auto" >
                @csrf <input hidden name="ap" value="1">
                <button type="submit" class="btn btn-danger">Reject</button>
            </form>
            @if($next != $leave->id)
            <a href="{{route('leave.view_leave',['id'=>$next])}}" class="btn btn-primary">Next</a>
            @endif
        @endif
    </div>

                            <div class="form-control mt-2">
                                <div class="col-md-4">Supported Document</div>
                                <div class="col-md-8">
                                    @if(isset($image))
                                        @for($x=0;$x<count($image);$x++)
                                            @if( !(\Illuminate\Support\Facades\Storage::exists($image[$x])) )
                                            {{--                    @php(dd($image))--}}
                                            <img style="width: 100%;" src="{{asset($image[$x])}}" alt=""/></br>
                                            @endif
                                        @endfor
                                    @endif
                                </div>
                            </div>


                        </div>
                    </div>
                </div> <!-- /.row -->
                <div class="card-body"></div>
            </div>
        </div><!-- /# column -->
    </div>
    <!--  /Traffic -->

@endsection
