{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title">
                <h3 class="card-label">
                   নতুন ছুটির ধরণ তৈরি করুন ( Create Leave Type )
                </h3>
            </div>
        </div>
        <div class="card-body">

            <form role="form" method="POST" action="{{ route('leave.post_create_leave_type') }}">
                @csrf
                @if(isset($leavetype->id)) <input type="number" name="others" value="{{$leavetype->id}}" hidden readonly> @endif
                <div class="form-group{{ $errors->has('name') ? ' has-danger' : '' }} d-flex mb-2">
                    <div class="col-lg-3 col-md-6 col-sm-12">ছুটির ধরনের নাম (Name)<i class="fa fa-star-of-life fa-sm text-danger"></i></div>
                    <input class="col-lg-9 col-md-6 col-sm-12 form-control{{ $errors->has('name') ? ' is-invalid' : '' }}" placeholder="{{ __('Name of Leave') }}" type="text" name="name" @if( old('name') != null) value="{{ old('name') }}" @elseif(isset($leavetype->name)) value="{{ $leavetype->name }}" @endif required style="border: 1px solid rgb(178, 34, 34,.4);" autofocus>
                    @if ($errors->has('name'))
                        <span class="invalid-feedback" style="display: block;" role="alert">
                            <strong>{{ $errors->first('name') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="form-group mb-2 d-flex">
                    <div class="col-lg-3 col-md-6 col-sm-12">সময়কাল (Time period)</div>
                        <select name="time_period" class="form-control col-lg-9 col-md-6 col-sm-12" id="time_period">
                            <option selected disabled>Select time period</option>
                            <option value="1" @if( old('time_period') != null &&  (int)old('time_period')==1) selected @elseif(isset($leavetype->time_period) && $leavetype->time_period == 1) selected @endif>বাৎসরিক ( Yearly )</option>
                            <option value="2" @if( old('time_period') != null &&  (int)old('time_period')==2) selected @elseif(isset($leavetype->time_period) && $leavetype->time_period == 2) selected @endif>ষাণ্মাসিক ( Half Yearly )</option>
                            <option value="3" @if( old('time_period') != null &&  (int)old('time_period')==3) selected @elseif(isset($leavetype->time_period) && $leavetype->time_period == 3) selected @endif>ত্রৈমাসিক ( Quarterly )</option>
                            <option value="4" @if( old('time_period') != null &&  (int)old('time_period')==4) selected @elseif(isset($leavetype->time_period) && $leavetype->time_period == 4) selected @endif>মাসিক ( Monthly )</option>
                            <option value="5" @if( old('time_period') != null &&  (int)old('time_period')==5) selected @elseif(isset($leavetype->time_period) && $leavetype->time_period == 5) selected @endif>নির্দিষ্ট সময় পরপর ( After Specific Working day )</option>
                        </select>

                </div>
                <div class="form-group mb-4 d-flex time_period_select">
                    <div class="col-lg-3 col-md-6 col-sm-12">দিন ( Days )</div>
                    <select name="time_period_day" class="form-control  col-lg-9 col-md-6 col-sm-12" >
                        <option value="0" selected disabled>Select</option>
                        @for($i=6;$i<32;$i++)
                        <option value="{{$i}}" @if( old('time_period_day') != null &&  (int)old('time_period_day')== $i) selected @elseif(isset($leavetype->time_period_day) && $leavetype->time_period_day == $i) selected @endif>{{$i}}</option>
                        @endfor
                    </select>
                </div>
                <div class="form-group mb-4 d-flex">
                    <label class="col-lg-3 col-md-6 col-sm-12" for="limit">Can Exceed Maximum Limit?</label>
                    <input style="max-width:50px"  class="col-lg-9 col-md-6 col-sm-12" name="exceed_maximum_limit" id="limit" type="checkbox" @if( old('exceed_maximum_limit') != null) checked @elseif(isset($leavetype->exceed_maximum_limit) && $leavetype->exceed_maximum_limit == 1) checked @endif>

                </div>

                <div class="form-group mb-4 d-flex">
                    <label class="col-lg-3 col-md-6 col-sm-12" for="carry">Carry Forward?</label>
                  <input style="max-width:50px"  class="col-lg-9 col-md-6 col-sm-12" name="carry_forward" id="carry" type="checkbox" @if( old('carry_forward') != null) checked @elseif(isset($leavetype->carry_forward) && $leavetype->carry_forward == 1) checked @endif>

                </div>

                <div class="mb-4 d-flex form-group{{ $errors->has('balance') ? ' has-danger' : '' }}">
                    <div class="input-group input-group-alternative mb-3">
                        <label class="col-lg-3 col-md-6 col-sm-12" for="carry">Balance<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                        <input class="form-control{{ $errors->has('balance') ? ' is-invalid' : '' }}" placeholder="{{ __('Leave Balance') }}" type="number" name="balance" required style="border: 1px solid rgb(178, 34, 34,.4);" autofocus @if( old('balance') != null) value="{{ old('balance') }}" @elseif(isset($leavetype->balance)) value="{{ $leavetype->balance }}" @endif>
                    </div>
                    @if ($errors->has('balance'))
                        <span class="invalid-feedback" style="display: block;" role="alert">
                            <strong>{{ $errors->first('balance') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="form-group mb-4 d-flex">
                    <label class="col-lg-3 col-md-6 col-sm-12" for="carry">সমর্থনকারী কাগজপত্র লাগবে (Supporting Documents)</label>
                    <input style="max-width:50px"  class="col-lg-9 col-md-6 col-sm-12"  name="supporting_documnets" id="document" type="checkbox" @if( old('supporting_documnets') != null) checked @elseif(isset($leavetype->supporting_documents) && $leavetype->supporting_documents == 1) checked @endif>

                </div>

                <div id="document_days">
                    @if((old('supporting_documnets') != null && (int)old('supporting_documnets') > 0) || (isset($leavetype->supporting_documents) && $leavetype->supporting_documents == 1))
                    <div class="form-group{{ $errors->has('minimum_days') ? ' has-danger' : '' }} mb-4 d-flex">
                        <label class="col-lg-3 col-md-6 col-sm-12" for="carry">সর্বনিম্ন কতদিন হলে সমর্থনকারী কাগজপত্র লাগবে ( Minimum Days for SD)<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                        <input class="col-lg-9 col-md-6 col-sm-12 form-control{{ $errors->has('minimum_days') ? ' is-invalid' : '' }}" placeholder="{{ __('Minimum Days for Supporting Documents') }}" type="text" name="minimum_days" @if( old('minimum_days') != null) value="{{ old('minimum_days') }}" @elseif(isset($leavetype->minimum_days)) value="{{ $leavetype->minimum_days }}" @endif required style="border: 1px solid rgb(178, 34, 34,.4);" autofocus>
                    </div>
                    @endif
                </div>





                <div class="text-center">
                    <button type="submit" class="btn btn-primary mt-4">{{ __('Create Leave') }}</button>
                </div>
            </form>


    </div>
</div>
    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("change", "#time_period", function () {
                if($(this).val() === 5 || $(this).val() === '5'){
                    $('.time_period_select').removeClass('d-none').addClass('d-flex');
                }else{
                    $('.time_period_select').removeClass('d-flex').addClass('d-none');
                }
            });
            @if( ( old('time_period') != null &&  (int)old('time_period')==5) || (isset($leavetype->time_period) && $leavetype->time_period == 5)) $('.time_period_select').removeClass('d-none').addClass('d-flex'); @else $('.time_period_select').removeClass('d-flex').addClass('d-none');  @endif
            $(document).on("click", "#document", function () {
                if ($(this).is(':checked')) {
                    $('#document_days').html(' <div class="form-group{{ $errors->has('minimum_days') ? ' has-danger' : '' }} mb-4 d-flex"><label class="col-lg-3 col-md-6 col-sm-12" for="carry">সর্বনিম্ন কতদিন হলে সমর্থনকারী কাগজপত্র লাগবে ( Minimum Days for SD)<i class="fa fa-star-of-life fa-sm text-danger"></i></label><input class="col-lg-9 col-md-6 col-sm-12 form-control{{ $errors->has('minimum_days') ? ' is-invalid' : '' }}" placeholder="{{ __('Minimum Days for Supporting Documents') }}" type="text" name="minimum_days" value="{{ old('minimum_days') }}" required style="border: 1px solid rgb(178, 34, 34,.4);" autofocus></div>');
                } else {
                    $('#document_days').empty();
                }

            });
        });





    </script>
@endsection




