@extends('backendlayout.app')

@section('content')

    <!--  Traffic  -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="box-title">Create Leave Type</h4>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card-body">
                            @include('backendlayout.session')
{{--                            @include('backendlayout.error')                     --}}



                        <form role="form" method="POST" action="{{ route('post_create_leave') }}">
                            @csrf

                            <div class="row">
                                <div class="col-md-6">

                                    <div class="form-group{{ $errors->has('name') ? ' has-danger' : '' }}">
                                        <div class="input-group input-group-alternative mb-3">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><i class="fas fa-user"></i></span>
                                            </div>
                                            <input class="form-control{{ $errors->has('name') ? ' is-invalid' : '' }}" placeholder="{{ __('Name of Leave') }}" type="text" name="name" value="{{ old('name') }}" required style="border: 1px solid rgb(178, 34, 34,.4);" autofocus>
                                        </div>
                                        @if ($errors->has('name'))
                                            <span class="invalid-feedback" style="display: block;" role="alert">
                                                <strong>{{ $errors->first('name') }}</strong>
                                            </span>
                                        @endif
                                    </div>


                                    <div class="custom-control custom-checkbox mb-3">
                                      <input class="custom-control-input" name="exceed_maximum_limit" id="limit" type="checkbox">
                                      <label class="custom-control-label" for="limit">Can Exceed Maximum Limit?</label>
                                    </div>

                                    <div class="custom-control custom-checkbox mb-3">
                                      <input class="custom-control-input" name="carry_forward" id="carry" type="checkbox">
                                      <label class="custom-control-label" for="carry">Carry Forward?</label>
                                    </div>





                                </div>

                                <div class="col-md-6">

                                    <div class="form-group{{ $errors->has('balance') ? ' has-danger' : '' }}">
                                        <div class="input-group input-group-alternative mb-3">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><i class="fas fa-user"></i></span>
                                            </div>
                                            <input class="form-control{{ $errors->has('balance') ? ' is-invalid' : '' }}" placeholder="{{ __('Leave Balance') }}" type="number" name="balance" value="{{ old('balance') }}" required autofocus>
                                        </div>
                                        @if ($errors->has('balance'))
                                            <span class="invalid-feedback" style="display: block;" role="alert">
                                                <strong>{{ $errors->first('balance') }}</strong>
                                            </span>
                                        @endif
                                    </div>

                                    <div class="custom-control custom-checkbox mb-3">
                                      <input class="custom-control-input" name="supporting_documnets" id="document" type="checkbox">
                                      <label class="custom-control-label" for="document">Need Supporting Documents?</label>
                                    </div>

                                    <div id="document_days">

                                    </div>


                                </div>
                            </div>


                            <div class="text-center">
                                <button type="submit" class="btn btn-primary mt-4">{{ __('Create Leave') }}</button>
                            </div>
                        </form>

                        </div>
                    </div>
                </div> <!-- /.row -->
                <div class="card-body"></div>
            </div>
        </div><!-- /# column -->
    </div>
    <!--  /Traffic -->

@endsection
@push('js')

    <script type="text/javascript">


        $(document).on("click","#document", function () {
            if ($(this).is(':checked')) {
                $('#document_days').html(' <div class="form-group{{ $errors->has('minimum_days') ? ' has-danger' : '' }}"><div class="input-group input-group-alternative mb-3"><div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-user"></i></span></div><input class="form-control{{ $errors->has('minimum_days') ? ' is-invalid' : '' }}" placeholder="{{ __('Minimum Days for Supporting Documents') }}" type="text" name="minimum_days" value="{{ old('minimum_days') }}" required style="border: 1px solid rgb(178, 34, 34,.4);" autofocus></div>@if ($errors->has('minimum_days'))<span <strong>{{ $errors->first('minimum_days') }}</strong></span>@endif </div>');
            }else{
                $('#document_days').empty();
            }

        });





    </script>
@endpush
