{{-- Extends layout --}}
@extends('layout.default')
{{-- Content --}}
@section('styles')
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css"/>
@endsection
@section('content')

    <!--begin::Profile Personal Information-->
    <div class="d-flex flex-row">
        @include("admin.employee.aside_nav")
        <!--begin::Content-->
        <div class="flex-row-fluid ml-lg-8">
            <!--begin::Card-->
            <div class="card card-custom card-stretch">
                <!--begin::Header-->
                <div class="card-header py-3">
                    <div class="card-title align-items-start flex-column">
                        <h3 class="card-label font-weight-bolder text-dark">১০। বিশ্রাম এবং বিনোদন (Rest and Recreation)</h3>
                        <span class="text-muted font-weight-bold font-size-sm mt-1">Update your information</span>
                    </div>
                </div>
                <div class="card-header py-3">
{{--                    <a href="{{route('employee.rest_recreations.create')}}"--}}
                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#rest_creat_update">
                        Add new/Create
                    </button>
                </div>
                <div class="card-body">
                    <table class="table table-bordered nowrap" id="kt_datatable_ym">
                        <thead>
                        <tr>
                            <th>From</th>
                            <th>To</th>
                            <th>Sanction Date</th>
                            <th>Sanction Number</th>
                            <th>Action</th>
                        </tr>
                        </thead>

                        <tbody>
                        @php($n=0)
                        @foreach($employee->rest_and_recreation as $rest)

                            <tr  @if(\Carbon\Carbon::parse($rest->from_date) > \Carbon\Carbon::today()) style="background: #c1d7e3;" @endif class="rest_{{$rest->id}}">

                                <td>{{$rest->from_date}}</td>
                                <td>{{$rest->to_date}}</td>
                                <td>{{$rest->sanction_date}}</td>
                                <td>{{$rest->sanction_number}}</td>
                                <td>
                                    <button type="button" class="btn btn-primary rest_update" data-toggle="modal" data-target="#rest_creat_update" data="{{$rest->id}}">
                                        Edit
                                    </button>
                                    <a href="#" onclick="return confirm('Are your sure ?');" class="btn btn-danger rest_delete" data="{{$rest->id}}">Delete</a>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                        <div class="modal fade" id="rest_creat_update" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLongTitle">New Rest and recreation ( শ্রান্তি বিনোদন )</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="rest_add_body">
                                        @include('admin.employee.extra_partial_page.rest_recreation')
                                    </div>
                                </div>
                            </div>
                        </div>

                    </table>
                    <!--end: Datatable-->
                    <script>
                        $(document).ready(function() {
                            var table = $('#kt_datatable_ym');
                            table.DataTable({
                                responsive: true,

                            });

                            $(document).on('click', '.rest_update', function(event){
                                var id = $(this).attr('data');
                                jQuery.ajax({
                                    url: "{{route('employee.rest_recreations.create',['id'=>$employee->id])}}?did="+id,
                                    method: 'get',
                                    success: function(result){
                                        $('.rest_add_body').html(result);
                                    }
                                });
                            });
                            $(document).on('click', '.rest_delete', function(event){
                                var id = $(this).attr('data');
                                jQuery.ajax({
                                    url: "{{route('employee.rest_recreations.create',['id'=>$employee->id])}}?delete_id="+id,
                                    method: 'get',
                                    success: function(result){
                                        if(result == 'success'){
                                            $('.rest_'+id).remove();
                                        }

                                    }
                                });
                            });
                        });
                    </script>


                </div>
            </div>
        </div>
        <!--end::Content-->
    </div>
    <!--end::Profile Personal Information-->

@endsection

{{-- Scripts Section --}}
@section('scripts')
    <script src="{{ asset('plugins/custom/datatables/datatables.bundle.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/pages/widgets.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/pages/custom/profile/profile.js')}}"></script>
    <script>
        $(document).ready(function() {
            var loan = $('.loan_count').length;
            $(document).on('click', '.loan_add', function(event){
                loan++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.loan_add')}}?v="+loan,
                    method: 'get',
                    success: function(result){
                        $('.loan_add_body').append(result);
                    }
                });
            });
            $(document).on('click', '.remove_this', function(event){
                var id = $(this).attr('data');
                $(this).parent().parent().remove();
                var ddd = $('#removedata').attr('value');
                $('#removedata').attr('value', ddd +','+id)
            });

        });

    </script>
@endsection
