{{-- Extends layout --}}
@extends('layout.default')

{{-- Content --}}
@section('content')

    <!--begin::Profile Personal Information-->
    <div class="d-flex flex-row">
        @include("admin.employee.aside_nav")
        <!--begin::Content-->
        <div class="flex-row-fluid ml-lg-8">
            <!--begin::Card-->
            <div class="card card-custom card-stretch">
                <!--begin::Header-->
                <div class="card-header py-3">
                    <div class="card-title align-items-start flex-column">
                        <h3 class="card-label font-weight-bolder text-dark">ব্যাক্তিগত তথ্যাদি ( Personal all Information )</h3>
                        <span class="text-muted font-weight-bold font-size-sm mt-1">Update your personal information</span>
                    </div>
                </div>
                <!--end::Header-->

                <!--begin::Form-->
                <form class="form" method="post" action="{{route('employee.indexdb',['id'=>$employee->id])}}" enctype="multipart/form-data">@csrf
                    <!--begin::Body-->
                    <div class="card-body">
                        <div class="row">
                            <label class="col-xl-3"></label>
                            <div class="col-lg-9 col-xl-6">
                                <h5 class="font-weight-bold mb-6">Employee Info</h5>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label">Photo</label>
                            <div class="col-lg-9 col-xl-6">
                                <div class="image-input image-input-outline" id="kt_profile_avatar" style="background-image: url({{asset('media/users/blank.png')}})">
                                    <div class="image-input-wrapper" style="background-image: url(@if(isset($employee->image)){{asset($employee->image)}}@else{{asset('media/users/blank.png')}}@endif)"></div>

                                    <label class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="change" data-toggle="tooltip" title="" data-original-title="Change avatar">
                                        <i class="fa fa-pen icon-sm text-muted"></i>
                                        @if(isset($loggedin->employee_id) && isset($employee->image)) @else
                                        <input type="file" name="profile_avatar" accept=".png, .jpg, .jpeg"/>
                                        <input type="hidden" name="profile_avatar_remove"/>
                                        @endif
                                    </label>

                                    <span class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="cancel" data-toggle="tooltip" title="Cancel avatar">
                                    <i class="ki ki-bold-close icon-xs text-muted"></i>
                                </span>

                                    <span class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="remove" data-toggle="tooltip" title="Remove avatar">
                                    <i class="ki ki-bold-close icon-xs text-muted"></i>
                                </span>
                                </div>
                                <span class="form-text text-muted">Allowed file types:  png, jpg, jpeg,</span>
                                <span class="form-text text-muted">max photo size 1024KB,</span>
                                <span class="form-text text-muted">width 320-360 px, height 400-440 px.</span>
                            </div>
                        </div>
                        <div class="row mb-2">
                            <label class="col-xl-3"></label>
                            <div class="col-lg-9 col-xl-9">
                                <h5 class="font-weight-bold mt-10 mb-6">২.১.১ ব্যাক্তিগত তথ্যাদি (Personal Information)</h5>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-form-label text-left col-lg-3 col-sm-12">লিঙ্গ (Gender)</label>
                            <div class=" col-lg-9 col-md-9 col-sm-12">
                                <select class="form-control " id="kt_select2_1"  @if(isset($loggedin->employee_id) && isset($employee->employee_personal_info->gender) && (int)$employee->employee_personal_info->gender > 0) readonly @else name="gender" @endif>
                                    <option>নির্বাচন করুন</option>
                                    <option value="1" @if(isset($employee->employee_personal_info->gender) && $employee->employee_personal_info->gender == 1){{__('selected')}}@endif>পুরুষ (Male)</option>
                                    <option value="2" @if(isset($employee->employee_personal_info->gender) && $employee->employee_personal_info->gender == 2){{__('selected')}}@endif>মহিলা (Female)</option>
                                    <option value="3" @if(isset($employee->employee_personal_info->gender) && $employee->employee_personal_info->gender == 3){{__('selected')}}@endif>অন্যান্য (Others)</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label">পিতার নাম (ইংরেজি) [Father name (English)]</label>
                            <div class="col-lg-9 col-xl-9">
                                <input class="form-control form-control-lg form-control-solid" type="text"  @if(isset($loggedin->employee_id) && isset($employee->employee_personal_info->fname)) readonly @else name="fname" @endif @if(isset($employee->employee_personal_info->fname))value="{{$employee->employee_personal_info->fname}}"@endif/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label">মাতার নাম (ইংরেজি) [Mother name (English)]</label>
                            <div class="col-lg-9 col-xl-9">
                                <input class="form-control form-control-lg form-control-solid" type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_personal_info->mname)) readonly @else name="mname" @endif @if(isset($employee->employee_personal_info->mname))value="{{$employee->employee_personal_info->mname}}"@endif/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-form-label text-left col-lg-3 col-sm-12">ধর্ম (Religion)</label>
                            <div class=" col-lg-9 col-md-9 col-sm-12">
                                <select class="form-control " id="kt_select2_1" @if(isset($loggedin->employee_id) && isset($employee->employee_personal_info->region) && (int)$employee->employee_personal_info->region > 0) readonly @else name="religion" @endif>
                                    <option>নির্বাচন করুন</option>
                                    <option value="1" @if(isset($employee->employee_personal_info->region) && $employee->employee_personal_info->region == 1){{__('selected')}}@endif>ইসলাম (Islam)</option>
                                    <option value="2" @if(isset($employee->employee_personal_info->region) && $employee->employee_personal_info->region == 2){{__('selected')}}@endif>হিন্দু (Hindu)</option>
                                    <option value="3" @if(isset($employee->employee_personal_info->region) && $employee->employee_personal_info->region == 3){{__('selected')}}@endif>বৌদ্ধ (Buddhist)</option>
                                    <option value="4" @if(isset($employee->employee_personal_info->region) && $employee->employee_personal_info->region == 4){{__('selected')}}@endif>খ্রিষ্টান (Christian)</option>
                                    <option value="5" @if(isset($employee->employee_personal_info->region) && $employee->employee_personal_info->region == 5){{__('selected')}}@endif>অন্যান্য (Other)</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-form-label text-left col-lg-3 col-sm-12">বৈবাহিক অবস্থা (Marital Status)</label>
                            <div class=" col-lg-9 col-md-9 col-sm-12">
                                <select class="form-control " id="kt_select2_1" @if(isset($loggedin->employee_id) && isset($employee->employee_personal_info->marital_status) && (int)$employee->employee_personal_info->marital_status > 0) readonly @else name="marital_status" @endif >
                                    <option>নির্বাচন করুন</option>
                                    <option value="1" @if(isset($employee->employee_personal_info->marital_status) && $employee->employee_personal_info->marital_status == 1){{__('selected')}}@endif>বিবাহিত (Married)</option>
                                    <option value="2" @if(isset($employee->employee_personal_info->marital_status) && $employee->employee_personal_info->marital_status == 2){{__('selected')}}@endif>অবিবাহিত (Unmarried)</option>
                                    <option value="3" @if(isset($employee->employee_personal_info->marital_status) && $employee->employee_personal_info->marital_status == 3){{__('selected')}}@endif>বিধবা (Widow)</option>
                                    <option value="4" @if(isset($employee->employee_personal_info->marital_status) && $employee->employee_personal_info->marital_status == 4){{__('selected')}}@endif>বিপত্নীক (Widower)</option>
                                    <option value="5" @if(isset($employee->employee_personal_info->marital_status) && $employee->employee_personal_info->marital_status == 5){{__('selected')}}@endif>অন্যান্য (Other)</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label">মোবাইল ফোন নম্বর (Mobile Phone Number)</label>
                            <div class="col-lg-9 col-xl-9">
                                <input class="form-control form-control-lg form-control-solid" type="number" min="0"  @if(isset($loggedin->employee_id) && isset($employee->employee_personal_info->mobile_phone)) readonly @else name="mobile" @endif  @if(isset($employee->employee_personal_info->mobile_phone))value="{{$employee->employee_personal_info->mobile_phone}}"@endif/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label">ইমারজেন্সি যোগাযোগ নম্বর (Emergency Contact Number)</label>
                            <div class="col-lg-9 col-xl-9">
                                <input class="form-control form-control-lg form-control-solid" type="number" min="0"  @if(isset($loggedin->employee_id) && isset($employee->employee_personal_info->emergency_phone)) readonly @else name="emergency_phone" @endif  @if(isset($employee->employee_personal_info->emergency_phone))value="{{$employee->employee_personal_info->emergency_phone}}"@endif/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label">ই-টিআইএন নম্বর (যদি থাকে) [E-TIN Number (if have any)]</label>
                            <div class="col-lg-9 col-xl-9">
                                <input class="form-control form-control-lg form-control-solid" type="number" min="0" @if(isset($loggedin->employee_id) && isset($employee->employee_personal_info->tin)) readonly @else name="etin" @endif  @if(isset($employee->employee_personal_info->tin))value="{{$employee->employee_personal_info->tin}}"@endif/>
                            </div>
                        </div>

                        <div id="present_address_trck_id" class="row mt-2 mb-2">
                            <div class="col-lg-12 col-xl-12">
                                <h6 class="mt-10 mb-6 text-center">২.১.২ বর্তমান ঠিকানা (Present Address)</h6>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label"> বাড়ি নং ও রোড নং ও গ্রাম[HOUSE NO. & ROAD NO. & VILLAGE]<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                            <div class="col-lg-9 col-xl-9">
                                <input class="form-control form-control-lg form-control-solid" type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_present_address->village_or_house_road)) readonly @else name="present_address[village_or_house_road]" @endif required  @if(isset($employee->employee_present_address->village_or_house_road))value="{{$employee->employee_present_address->village_or_house_road}}"@endif/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label"> পোস্ট অফিস ও পোস্ট কোড [POST OFFICE & POST CODE]<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                            <div class="col-lg-9 col-xl-9">
                                <input class="form-control form-control-lg form-control-solid" type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_present_address->post_office)) readonly @else name="present_address[post_office]" @endif required  @if(isset($employee->employee_present_address->post_office))value="{{$employee->employee_present_address->post_office}}"@endif placeholder="POST OFFICE , POST CODE"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label" style="color:black;"> জেলা [DISTRICT]<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                            <div class="col-lg-9 col-xl-9">
                                <select class="form-control present_district" id="kt_select2_1"
                                        @if(isset($loggedin->employee_id) && isset($employee->employee_present_address->district_id)) readonly
                                        @else name="present_address[district]" @endif
                                        required >
                                    <option value>নির্বাচন করুন</option>
                                    @foreach($function->districts() as $district)
                                        <option value="{{$district['id']}}" @if(isset($employee->employee_present_address->district_id) && (int)$employee->employee_present_address->district_id == (int)$district['id']) selected @endif>{{$district['name_en']}}({{$district['name_bn']}})</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label" style="color:black;"> থানা [POLICE STATION]<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                            <div class="col-lg-9 col-xl-9">
                                <select class="form-control present_thana" id="kt_select2_1"
                                @if(isset($loggedin->employee_id) && isset($employee->employee_present_address->thana_id)) readonly
                                    @else name="present_address[police_station]" @endif
                                    required >
                                    <option class="_0" value>নির্বাচন করুন</option>
                                    @foreach($function->thanas() as $thana)
                                    <option class="_{{$thana['district_id']}}" @if(isset($employee->employee_present_address->district_id) && (int)$employee->employee_present_address->district_id != $thana['district_id']) hidden @endif value="{{$thana['id']}}" @if(isset($employee->employee_present_address->thana_id) && (int)$employee->employee_present_address->thana_id == (int)$thana['id']) selected @endif>{{$thana['name_en']}}({{$thana['name_bn']}})</option>
                                    @endforeach

                                </select>
                            </div>
                        </div>

                        <script>
                            $(document).ready(function() {
                                $(document).on("change",".present_district", function(){
                                    $(".present_thana option").attr("hidden",true);
                                    $(".present_thana option._0").attr("hidden",false).attr("selected",true);
                                    $(".present_thana option._"+$(this).val()).removeAttr("hidden");
                                });
                            });
                        </script>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label"> টেলিফোন নাম্বার [TELEPHONE NO.] (optional)</label>
                            <div class="col-lg-9 col-xl-9">
                                <input class="form-control form-control-lg form-control-solid" type="number" @if(isset($loggedin->employee_id) && isset($employee->employee_present_address->contact)) readonly @else name="present_address[contact]" @endif @if(isset($employee->employee_present_address->contact))value="{{$employee->employee_present_address->contact}}"@endif/>
                            </div>
                        </div>

                        <div id="permanent_address_trck_id" class="row mt-2 mb-2">
                            <div class="col-lg-12 col-xl-12">
                                <h6 class="mt-10 mb-6 text-center">২.১.৩ স্থায়ী ঠিকানা (Permanent Address)<i class="fa fa-star-of-life fa-sm text-danger"></i></h6>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label"> বাড়ি নং ও রোড নং ও গ্রাম[HOUSE NO. & ROAD NO. & VILLAGE]<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                            <div class="col-lg-9 col-xl-9">
                                <input class="form-control form-control-lg form-control-solid" type="text"  @if(isset($loggedin->employee_id) && isset($employee->employee_permanent_address->village_or_house_road)) readonly @else  name="permanent_address[village_or_house_road]" @endif required  @if(isset($employee->employee_permanent_address->village_or_house_road))value="{{$employee->employee_permanent_address->village_or_house_road}}"@endif/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label"> পোস্ট অফিস ও পোস্ট কোড [POST OFFICE & POST CODE]<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                            <div class="col-lg-9 col-xl-9">
                                <input class="form-control form-control-lg form-control-solid" type="text"  @if(isset($loggedin->employee_id) && isset($employee->employee_permanent_address->post_office)) readonly @else name="permanent_address[post_office]" @endif required  @if(isset($employee->employee_permanent_address->post_office))value="{{$employee->employee_permanent_address->post_office}}"@endif placeholder="POST OFFICE , POST CODE"/>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label"> জেলা [DISTRICT]<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                            <div class="col-lg-9 col-xl-9">
                                <select class="form-control permanent_district" id="kt_select2_1"
                                        @if(isset($loggedin->employee_id) && isset($employee->employee_permanent_address->district_id)) readonly
                                        @else name="permanent_address[district]" @endif
                                        required >
                                    <option value>নির্বাচন করুন</option>
                                    @foreach($function->districts() as $district)
                                        <option value="{{$district['id']}}" @if(isset($employee->employee_permanent_address->district_id) && (int)$employee->employee_permanent_address->district_id == (int)$district['id']) selected @endif>{{$district['name_en']}}({{$district['name_bn']}})</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label" style="color:black;"> থানা [POLICE STATION]<i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                            <div class="col-lg-9 col-xl-9">
                                <select class="form-control permanent_thana" id="kt_select2_1"
                                @if(isset($loggedin->employee_id) && isset($employee->employee_permanent_address->thana_id)) readonly
                                    @else name="permanent_address[police_station]" @endif
                                    required >
                                    <option class="_0" value>নির্বাচন করুন</option>
                                    @foreach($function->thanas() as $thana)
                                        <option class="_{{$thana['district_id']}}" @if(isset($employee->employee_permanent_address->district_id) && (int)$employee->employee_permanent_address->district_id != $thana['district_id']) hidden @endif value="{{$thana['id']}}" @if(isset($employee->employee_permanent_address->thana_id) && (int)$employee->employee_permanent_address->thana_id == (int)$thana['id']) selected @endif>{{$thana['name_en']}}({{$thana['name_bn']}})</option>
                                    @endforeach

                                </select>
                            </div>
                        </div>
                        <script>
                            $(document).ready(function() {
                                $(document).on("change",".permanent_district", function(){
                                    $(".permanent_thana option").attr("hidden",true);
                                    $(".permanent_thana option._0").attr("hidden",false).attr("selected",true);
                                    $(".permanent_thana option._"+$(this).val()).removeAttr("hidden");
                                });
                            });
                        </script>

                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label"> টেলিফোন নাম্বার [TELEPHONE NO.] (optional)</label>
                            <div class="col-lg-9 col-xl-9">
                                <input class="form-control form-control-lg form-control-solid" type="number" @if(isset($loggedin->employee_id) && isset($employee->employee_permanent_address->contact)) readonly @else name="permanent_address[contact]" @endif @if(isset($employee->employee_permanent_address->contact))value="{{$employee->employee_permanent_address->contact}}"@endif/>
                            </div>
                        </div>

                        <div id="language_track_id" class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h6 class="mt-10 mb-6 text-center">২.১.৪ ভাষা (Language)</h6>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info personal_language">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body personal_languagebody">
                            @include('admin.employee.extra_partial_page.per_language')
                        </div>


                        <div id="education_track_id" class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h6 class="mt-10 mb-6 text-center">২.১.৫ শিক্ষাগত যোগ্যতা (Educational Qualification)</h6>
                            </div>
                        </div>
                        <div class="row mt-2 mb-2">
                            <div class="col-lg-6 col-xl-6 my-auto mx-auto d-flex">
                                <button type="button" class="btn btn-info btn-sm personal_edu_qua_ssc mr-2">SSC/Equivalent</button>
                                <button type="button" class="btn btn-info btn-sm personal_edu_qua_hsc mr-2">HSC/Equivalent</button>
                                <button type="button" class="btn btn-info btn-sm personal_edu_qua">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body personal_edu_qua_body">
                            @include('admin.employee.extra_partial_page.per_educational_qualification')
                        </div>


                        <div id="local_training_track_id" class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h6 class="mt-10 mb-6 text-center">২.১.৬ স্থানীয় প্রশিক্ষণ (Local Training)</h6>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info per_local_training">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body per_local_training_body">
                            @include('admin.employee.extra_partial_page.per_local_training')
                        </div>


                        <div id="foreign_training_track_id" class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h6 class="mt-10 mb-6 text-center">২.১.৭ বিদেশ ভ্রমন (Foreign Travel)</h6>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info per_foreign_training">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body per_foreign_training_body">
                            @include('admin.employee.extra_partial_page.per_foreign_training')
                        </div>

{{--                        <div id="foreign_training_track_id" class="row mt-2 mb-2">--}}
{{--                            <div class="col-lg-9 col-xl-9">--}}
{{--                                <h6 class="mt-10 mb-6 text-center">২.১.৭ বিদেশ ভ্রমন (Foreign Travel)</h6>--}}
{{--                            </div>--}}
{{--                            <div class="col-lg-3 col-xl-3 my-auto text-right">--}}
{{--                                <button type="button" class="btn btn-info per_foreign_travel">Add new</button>--}}
{{--                            </div>--}}
{{--                        </div>--}}
{{--                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>--}}
{{--                        <div class="card-body per_foreign_travel_body">--}}
{{--                            @include('admin.employee.extra_partial_page.per_foreign_travel')--}}
{{--                        </div>--}}

                        {{-- <div class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h6 class="mt-10 mb-6 text-center">২.১.৮ বিদেশে পোস্টিং (Posting Abroad)</h6>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info per_posting_abroad">Add new</button>
                            </div>
                        </div> --}}
{{--                        <div class="card-body per_posting_abroad_body">--}}
{{--                            @include('admin.employee.extra_partial_page.per_posting_abroad')--}}
{{--                        </div>--}}

                        <div id="other_training_track_id" class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h6 class="mt-10 mb-6 text-center">২.১.৮ অন্যান্য যোগ্যতা (Other Qualification)</h6>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info per_professional_qualification">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body per_professional_qualification_body">
                            @include('admin.employee.extra_partial_page.per_professional_qualification')
                        </div>

                        <div id="publication_track_id" class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h6 class="mt-10 mb-6 text-center">২.১.৯ প্রকাশনা(Publication)</h6>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info per_publication">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body per_publication_body">
                            @include('admin.employee.extra_partial_page.per_publication')
                        </div>
                        <div id="honor_track_id" class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h6 class="mt-10 mb-6 text-center">২.১.১০ সম্মাননা এবং পুরষ্কার (Honours and Award)</h6>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info per_honours_and_award">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body per_honours_and_award_body">
                            @include('admin.employee.extra_partial_page.per_honours_and_award')
                        </div>

                        <div id="other_service_track_id" class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h6 class="mt-10 mb-6 text-center">২.১.১১ অন্যান্য পরিষেবাদি (Other Services (Prior Civilian Gazetted Post/Rank))</h6>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info per_other_service">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body per_other_service_body">
                            @include('admin.employee.extra_partial_page.per_other_service')
                        </div>

                        {{-- <div class="row mt-2 mb-2">
                            <div  class="col-lg-12 col-xl-12">
                                <h6 class="mt-10 mb-6 text-center">২.১.১৩ পরিষেবা ইতিহাস (Service History)</h6>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="form-group row">
                                <label class="col-xl-3 col-lg-3 col-form-label">সরকারি পরিষেবার তারিখ [GOVT. Service Date]</label>
                                <div class="col-lg-9 col-xl-9">
                                    <input data-date-format="dd-mm-yyyy" readonly class="form-control form-control-lg form-control-solid kt_datepicker" style="border: 1px solid #cdcdcd;" type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_service->service_date)) @else name="personal_service_history[govt_service_date]" @endif @if(isset($employee->employee_service->service_date))value="{{\Carbon\Carbon::parse($employee->employee_service->service_date)->format('d-m-Y')}}"@endif/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-xl-3 col-lg-3 col-form-label">গেজেটের তারিখ [Gazetted Date]</label>
                                <div class="col-lg-9 col-xl-9">
                                    <input data-date-format="dd-mm-yyyy" readonly class="form-control form-control-lg form-control-solid kt_datepicker" style="border: 1px solid #cdcdcd;"  type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_service->gazetted_date)) @else name="personal_service_history[gazetted_date]" @endif @if(isset($employee->employee_service->gazetted_date))value="{{\Carbon\Carbon::parse($employee->employee_service->gazetted_date)->format('d-m-Y')}}"@endif/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-xl-3 col-lg-3 col-form-label">গেজেটের তারিখ [Encadrement Date]</label>
                                <div class="col-lg-9 col-xl-9">
                                    <input data-date-format="dd-mm-yyyy" readonly class="form-control form-control-lg form-control-solid kt_datepicker" style="border: 1px solid #cdcdcd;"  type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_service->encadrement_date)) @else  name="personal_service_history[encadrement_date]" @endif  @if(isset($employee->employee_service->encadrement_date))value="{{\Carbon\Carbon::parse($employee->employee_service->encadrement_date)->format('d-m-Y')}}"@endif/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-xl-3 col-lg-3 col-form-label">জ্যেষ্ঠতার তারিখ [Seniority Date]</label>
                                <div class="col-lg-9 col-xl-9">
                                    <input data-date-format="dd-mm-yyyy" readonly class="form-control form-control-lg form-control-solid kt_datepicker" style="border: 1px solid #cdcdcd;"  type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_service->seniority_date)) @else  name="personal_service_history[seniority_date]" @endif  @if(isset($employee->employee_service->seniority_date))value="{{\Carbon\Carbon::parse($employee->employee_service->seniority_date)->format('d-m-Y')}}"@endif/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-xl-3 col-lg-3 col-form-label">ক্যাডার [Cadre]</label>
                                <div class="col-lg-9 col-xl-9">
                                    <input class="form-control form-control-lg form-control-solid" style="border: 1px solid #cdcdcd;"  type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_service->cadre)) readonly @else  name="personal_service_history[cadre]" @endif  @if(isset($employee->employee_service->cadre))value="{{$employee->employee_service->cadre}}"@endif/>
                                </div>
                            </div> --}}
                        </div>



                        <div class="card-footer">
                            <div class="row">
                                <div class="col-lg-4"> <input id="removedata" type="text" name="remove" value="" hidden></div>
                                <div class="col-lg-4">
                                    <div class="card-toolbar">
                                        <button type="submit" class="btn btn-success mr-2">Save Changes</button>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    @if(isset($employee->id))
                                    <div class="card-toolbar">
                                        <a href="{{route('employee.service',['id'=>$employee->id,'l'=>3])}}" class="btn btn-info mr-2">কর্মচারীর চাকরি সম্পর্কিত তথ্যাদি</a>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                    <!--end::Body-->
                </form>
                <!--end::Form-->
            </div>
        </div>
        <!--end::Content-->
    </div>
    <!--end::Profile Personal Information-->

@endsection

{{-- Scripts Section --}}
@section('scripts')
    <script src="{{ asset('js/pages/widgets.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/pages/custom/profile/profile.js')}}"></script>
    <script>
        $(document).ready(function() {
            var personal_language = 0;
            $(document).on('click', '.personal_language', function(event){
                personal_language++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.personal_language')}}?v="+personal_language,
                    method: 'get',
                    success: function(result){
                        $('.personal_languagebody').append(result);
                    }
                });
            });
            var personal_edu_qua = 0;
            $(document).on('click', '.personal_edu_qua', function(event){
                personal_edu_qua++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.educational_qualification')}}?v="+personal_edu_qua+"&e=3",
                    method: 'get',
                    success: function(result){
                        $('.personal_edu_qua_body').append(result);
                    }
                });
            });
            $(document).on('click', '.personal_edu_qua_ssc', function(event){
                personal_edu_qua++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.educational_qualification')}}?v="+personal_edu_qua+"&e=1",
                    method: 'get',
                    success: function(result){
                        $('.personal_edu_qua_body').append(result);
                    }
                });
            });
            $(document).on('click', '.personal_edu_qua_hsc', function(event){
                personal_edu_qua++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.educational_qualification')}}?v="+personal_edu_qua+"&e=2",
                    method: 'get',
                    success: function(result){
                        $('.personal_edu_qua_body').append(result);
                    }
                });
            });
            var per_local_training = 0;
            $(document).on('click', '.per_local_training', function(event){
                per_local_training++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.local_training')}}?v="+per_local_training,
                    method: 'get',
                    success: function(result){
                        $('.per_local_training_body').append(result);
                    }
                });
            });

            var per_foreign_training = 0;
            $(document).on('click', '.per_foreign_training', function(event){
                per_foreign_training++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.foreign_training')}}?v="+per_foreign_training,
                    method: 'get',
                    success: function(result){
                        $('.per_foreign_training_body').append(result);
                    }
                });
            });
            var per_foreign_travel = 0;
            $(document).on('click', '.per_foreign_travel', function(event){
                per_foreign_travel++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.foreign_travel')}}?v="+per_foreign_travel,
                    method: 'get',
                    success: function(result){
                        $('.per_foreign_travel_body').append(result);
                    }
                });
            });
            var per_posting_abroad = 0;
            $(document).on('click', '.per_posting_abroad', function(event){
                per_posting_abroad++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.posting_abroad')}}?v="+per_posting_abroad,
                    method: 'get',
                    success: function(result){
                        $('.per_posting_abroad_body').append(result);
                    }
                });
            });
            var per_professional_qualification = 0;
            $(document).on('click', '.per_professional_qualification', function(event){
                per_professional_qualification++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.professional_qualification')}}?v="+per_professional_qualification,
                    method: 'get',
                    success: function(result){
                        $('.per_professional_qualification_body').append(result);
                    }
                });
            });
            var per_publication = 0;
            $(document).on('click', '.per_publication', function(event){
                per_publication++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.publication')}}?v="+per_publication,
                    method: 'get',
                    success: function(result){
                        $('.per_publication_body').append(result);
                    }
                });
            });
            var per_honours_and_award = 0;
            $(document).on('click', '.per_honours_and_award', function(event){
                per_honours_and_award++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.honour_reward')}}?v="+per_honours_and_award,
                    method: 'get',
                    success: function(result){
                        $('.per_honours_and_award_body').append(result);
                    }
                });
            });
            var per_other_service = 0;
            $(document).on('click', '.per_other_service', function(event){
                per_other_service++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.other_service')}}?v="+per_other_service,
                    method: 'get',
                    success: function(result){
                        $('.per_other_service_body').append(result);
                    }
                });
            });

            $(document).on('click', '.remove_this', function(event){
                var id = $(this).attr('data');
                $(this).parent().parent().remove();
                var ddd = $('#removedata').attr('value');
                $('#removedata').attr('value', ddd +','+id)
            });
        });


    </script>
@endsection
