{{-- Extends layout --}}
@extends('layout.default')

{{-- Content --}}
@section('content')

    <!--begin::Profile Personal Information-->
    <div class="d-flex flex-row">
        @include("admin.employee.aside_nav")
        <!--begin::Content-->
        <div class="flex-row-fluid ml-lg-8">
            <!--begin::Card-->
            <div class="card card-custom card-stretch">
                <!--begin::Header-->
                <div class="card-header py-3">
                    <div class="card-title align-items-start flex-column">
                        <h3 class="card-label font-weight-bolder text-dark">৯। চাকুরীজীবীর অবর্তমানে পেনশন প্রাপ্তির উত্তরাধিকারী মনোনয়ন (Nominee for pension in absence of the employee)</h3>
                        <span class="text-muted font-weight-bold font-size-sm mt-1">Update your information</span>
                    </div>
                </div>
                <!--end::Header-->

                <!--begin::Form-->
                <form class="form" method="post"  action="{{route('employee.nomineepensiondb',['id'=>$employee->id])}}">@csrf
                    <!--begin::Body-->
                    <div class="card-body">
                        <div class="row">
                            <label class="col-xl-3"></label>
                            <div class="col-lg-9 col-xl-6">
                                <h5 class="font-weight-bold mb-6"></h5>
                            </div>
                        </div>
                        <div class="row mb-10">
                            <div class="col-lg-9 col-xl-9">
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info nomineepension">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body">
                            @foreach($employee->employee_family_info as $family)
                                @if($family->husbandwife == 1)
                                    <button class="emfamily_info family{{$family->nid}} badge badge-primary" type="button" data="{{$family->id}}">Add H/W - {{$family->name_bangla}}</button>
                                @endif
                                @if($family->child == 1 && $family->autistic == 0)
                                    <button class="emfamily_info family{{$family->nid}} badge badge-primary" type="button" data="{{$family->id}}">Add {{$family->relation}} - {{$family->name_bangla}}</button>
                                @endif
                                @if($family->child == 1 && $family->autistic == 1)
                                    <button class="emfamily_info family{{$family->nid}} badge badge-primary" type="button" data="{{$family->id}}">Add Autistic - {{$family->name_bangla}}</button>
                                @endif
                            @endforeach
                        </div>
                        <div class="card-body nomineepension_body">
                            @include('admin.employee.extra_partial_page.nomineepension')
                        </div>
                        <div class="card-footer">
                            <div class="row">
                                <div class="col-lg-4">
                                    @if(isset($employee->id))
                                        <div class="card-toolbar">
                                            <a href="{{route('employee.disciplinary',['id'=>$employee->id,'l'=>8])}}" class="btn btn-info mr-2">কর্মচারীর শৃঙ্খলামুলক ব্যবস্থা</a>
                                        </div>
                                    @endif
                                </div>
                                <div class="col-lg-4 d-none"> <input id="removedata" type="text" name="remove" value="" hidden></div>
                                <div class="col-lg-4">
                                    <div class="card-toolbar">
                                        <button type="submit" class="btn btn-success mr-2">Save Changes</button>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    @if(isset($employee->id) && !isset($loggedin->employee_id))
                                        <div class="card-toolbar">
                                            <a href="{{route('manage_employee.index')}}" class="btn btn-info mr-2">All employee</a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                    </div>
                    <!--end::Body-->
                </form>
                <!--end::Form-->
            </div>
        </div>
        <!--end::Content-->
    </div>
    <!--end::Profile Personal Information-->

@endsection

{{-- Scripts Section --}}
@section('scripts')
    <script src="{{ asset('js/pages/widgets.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/pages/custom/profile/profile.js')}}"></script>
    <script>
        $(document).ready(function() {
            var nomineepension = 0;
            $(document).on('click', '.nomineepension', function(event){
                nomineepension++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.nomineepension')}}?v="+nomineepension,
                    method: 'get',
                    success: function(result){
                        $('.nomineepension_body').append(result);
                    }
                });
            });
            $(document).on('click', '.remove_this', function(event){
                var id = $(this).attr('data');
                $(this).parent().parent().remove();
                var ddd = $('#removedata').attr('value');
                $('#removedata').attr('value', ddd +','+id)
            });
        });

    </script>
    <script>
        $(document).ready(function() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $(document).on('click', '.emfamily_info', function(event){
                jQuery.ajax({
                    url: "{{route('ajaxcall.find_relation')}}",
                    method: 'post',
                    data: {
                        data: $(this).attr('data'),
                        nom: 1,
                    },
                    success: function(result){
                        $('.nomineepension_body').append(result);
                    }
                })
            });
        });
    </script>
@endsection
