{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
@section('content')
    <div class="d-flex flex-column-fluid">
        <!--begin::Container-->
        <div class=" container " style="padding: 0">
           
            <!--begin::Card-->
            <div class="card card-custom gutter-b">
            <div class="card-header flex-wrap py-3">
                    <div class="card-title">
                        <h3 class="card-label kt_datatable_em_title">{{$employee->name}} Payslip</h3>
                    </div>
                </div>
                <div class="card-header flex-wrap py-3">
                    <form action="{{route('employee.payslip',['id'=>$employee->id])}}" class="d-flex" method="get">
                       <span class="my-auto">From</span> <input data-date-format="dd-mm-yyyy" readonly class="form-control form-control-solid kt_datepicker float-left my-auto ml-2  mr-2" name="start" type="text" style="width: 150px" value=""/>
                        <span class="my-auto">To</span> <input data-date-format="dd-mm-yyyy" readonly class="form-control form-control-solid kt_datepicker float-left my-auto ml-2 mr-2" name="end" type="text" style="width: 150px" value=""/>
                        <button type="submit" class="btn btn-primary payslipsearch">Search</button>
                    </form>
                </div>
                <div class="card-body">
                    <!--begin: Datatable-->
                    <table class="table table-bordered table-checkable text-center" id="kt_datatable_em">
                    <thead>
                            <tr>
                                <th rowspan="2">নাম</th>
                                <th rowspan="2">পদবী</th>
                                <th rowspan="2">মাস</th>
                                @foreach($function->pay_allowance() as $key=>$allowance)
                                    @if($allowance[0] == 1 && in_array($key,$activecode1))
                                        <th rowspan="2">{{$allowance[1]}}</th>
                                    @endif
                                @endforeach
                                <th rowspan="2">সর্বমোট টাকা</th>
                                <th colspan="{{$deductionCount}}">কর্তন</th>
                                <th rowspan="2">মোট কর্তন</th>
                                <th rowspan="2">নীট পরিশোধিত</th>
                            </tr>
                            <tr>
                                @foreach($function->pay_allowance() as $key=>$allowance)
                                    @if($allowance[0] == 0  && in_array($key,$activecode1))
                                        <th>{{$allowance[1]}}</th>
                                    @endif
                                @endforeach
                            </tr>
                        </thead>

                        <tbody>
                        @foreach($employee->pay_slip->groupBy('month') as $key=>$payslip)
                            @php
                                $adata= array();
                                $ddata= array();
                                foreach ($payslip as $p){
                                    if($p->addition == 1){
                                        $adata[$p->code] = (int)$p->taka;
                                    }else{
                                        $ddata[$p->code] = (int)$p->taka;
                                    }

                                }
                            @endphp
{{--                            @php(dd($key,$payslip))--}}
                            <tr>
                                <th>{{$employee->name}}</th>
                                <th>{{$employee->employee_present_position->post}}</th>
                                <th>{{\Carbon\Carbon::parse($key)->format('F,Y')}}</th>
                                @foreach($function->pay_allowance() as $key=>$allowance)
                                    @if($allowance[0] == 1 && in_array($key,$activecode1))
                                        <th>@isset($adata[$key]) {{$adata[$key]}}@endisset</th>
                                    @endif
                                @endforeach
                                <th>{{array_sum($adata)}}</th>
                                @foreach($function->pay_allowance() as $key=>$allowance)
                                    @if($allowance[0] == 0 && in_array($key,$activecode1))
                                        <th>@isset($ddata[$key]) {{$ddata[$key]}}@endisset</th>
                                    @endif
                                @endforeach
                                <th>{{array_sum($ddata)}}</th>
                                <th>{{array_sum($adata) - array_sum($ddata)}}</th>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                    <!--end: Datatable-->
                </div>
            </div>


        </div>
    </div>
    <!--end::Entry-->
@endsection

{{-- Scripts Section --}}
@section('scripts')
    <script src="{{asset('plugins/custom/datatables/datatables.bundle.js')}}"></script>
    <script>
        $(document).ready(function() {
            var title = 'LandPortAuthority All Employee '+$('h3.kt_datatable_em_title').text();
            var table = $('#kt_datatable_em');
            table.DataTable({
                responsive: true,
                dom: 'Bfrtip',
                buttons: [
                    {
                        extend: 'excelHtml5',
                        title: title,
                        exportOptions: {
                            columns:  ':visible'
                        }
                    },
                    // {
                    //     extend: 'pdfHtml5',
                    //     title: title,
                    //     orientation: 'landscape',
                    //     pageSize: 'A4',
                    //     exportOptions: {
                    //         // columns:  ':visible'
                    //     }
                    // },
                    {
                        extend: 'print',
                        title: title,
                        exportOptions: {
                            columns:  ':visible'
                        },
                        customize: function(win)
                        {

                            var last = null;
                            var current = null;
                            var bod = [];

                            var css = '@page { size: landscape; }',
                                head = win.document.head || win.document.getElementsByTagName('head')[0],
                                style = win.document.createElement('style');

                            style.type = 'text/css';
                            style.media = 'print';

                            if (style.styleSheet)
                            {
                                style.styleSheet.cssText = css;
                            }
                            else
                            {
                                style.appendChild(win.document.createTextNode(css));
                            }

                            head.appendChild(style);
                        }
                    },
                    'colvis'

                ]

            });
        });
    
    </script>
@endsection
