{{-- Extends layout --}}
@extends('layout.default')
{{-- Content --}}
@section('styles')
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css"/>
@endsection
@section('content')

    <!--begin::Profile Personal Information-->
    <div class="d-flex flex-row">
        @include("admin.employee.aside_nav")
        <!--begin::Content-->
        <div class="flex-row-fluid ml-lg-8">
            <!--begin::Card-->
            <div class="card card-custom card-stretch">
                <!--begin::Header-->
                <div class="card-header py-3">
                    <div class="card-title align-items-start flex-column">
                        <h3 class="card-label font-weight-bolder text-dark">Change Log</h3>
                    </div>
                </div>
                <div class="card-body">
                    <table class="table table-bordered nowrap" id="kt_datatable_ym">
                        <thead>
                        <tr>
                            <th>Date</th>
                            <th>Data Type</th>
                            <th>From</th>
                            <th>To</th>
                            <th>Action Type</th>
                            <th>Changed By</th>

                        </tr>
                        </thead>

                        <tbody>
                        @foreach($employee->record_changelog as $log)
                            <tr>
                                <td>{{\Carbon\Carbon::parse($log->created_at)->format('d F,Y h:i')}}</td>
                                <td>{{$log->name}}</td>
                                <td>{{$log->old}}</td>
                                <td>{{$log->new}}</td>
                                <td>@if($log->record_type == 1) New Record @elseif($log->record_type == 3) Deleted @else Updated @endif</td>
                                <td>{{$log->user->name}}{{--/{{$log->user->email}}--}}</td>

                            </tr>
                        @endforeach
                        </tbody>
                        {{--    @if($employee->toegs == 1) স্থায়ী পদের বিপরীতে সরাসরি নিয়োগ @endif--}}
                        {{--    @if($employee->toegs == 2) বেসরকারি শিক্ষা প্রতিষ্ঠান থেকে জাতীয়করণ @endif--}}
                        {{--    @if($employee->toegs == 3) বেসরকারি/আধাসরকারী প্রতিষ্ঠান হতে সরকারি পদে অধিকৃত @endif--}}
                        {{--    @if($employee->toegs == 4) উন্নয়ন প্রকল্প হতে রাজস্ব খাতে স্থানান্তরিত @endif--}}

                    </table>
                    <!--end: Datatable-->
                    <script>
                        $(document).ready(function() {
                            var table = $('#kt_datatable_ym');
                            table.DataTable({
                                responsive: true,
                                pageLength : 50

                            });
                        });
                    </script>


                </div>
            </div>
        </div>
        <!--end::Content-->
    </div>
    <!--end::Profile Personal Information-->

@endsection

{{-- Scripts Section --}}
@section('scripts')
    <script src="{{ asset('plugins/custom/datatables/datatables.bundle.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/pages/widgets.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/pages/custom/profile/profile.js')}}"></script>
    <script>
        $(document).ready(function() {
            var loan = $('.loan_count').length;
            $(document).on('click', '.loan_add', function(event){
                loan++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.loan_add')}}?v="+loan,
                    method: 'get',
                    success: function(result){
                        $('.loan_add_body').append(result);
                    }
                });
            });
            $(document).on('click', '.remove_this', function(event){
                var id = $(this).attr('data');
                $(this).parent().parent().remove();
                var ddd = $('#removedata').attr('value');
                $('#removedata').attr('value', ddd +','+id)
            });

        });

    </script>
@endsection
