{{-- Extends layout --}}
@extends('layout.default')
{{-- Content --}}
@section('styles')
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css"/>
@endsection
@section('content')

    <!--begin::Profile Personal Information-->
    <div class="d-flex flex-row">
        @include("admin.employee.aside_nav")
        <!--begin::Content-->
        <div class="flex-row-fluid ml-lg-8">
            <!--begin::Card-->
            <div class="card card-custom card-stretch">
                <!--begin::Header-->
                <div class="card-header py-3">
                    <div class="card-title align-items-start flex-column">
                        <h3 class="card-label font-weight-bolder text-dark">৬। বর্তমান ঋণ সংক্রান্ত তথ্যাদি (Current loan related information)</h3>
                        <span class="text-muted font-weight-bold font-size-sm mt-1">Update your information</span>
                    </div>
                </div>
                <!--end::Header-->

                <!--begin::Form-->
                <form class="form" method="post"  action="{{route('employee.loandb',['id'=>$employee->id])}}">@csrf
                    <!--begin::Body-->
                    <div class="card-body">
                        <div class="row">
                            <label class="col-xl-3"></label>
                            <div class="col-lg-9 col-xl-6">
                                <h5 class="font-weight-bold mb-6"></h5>
                            </div>
                        </div>
                        <div class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h5 class="font-weight-bold mt-10 mb-6"> ঋণ সংক্রান্ত তথ্যাদি (Loan related information)</h5>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info loan_add">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                      
                        <div class="card-body loan_add_body">
                            @include('admin.employee.extra_partial_page.loan_table')
                        </div>
                        <div class="card-footer">
                            <div class="row">
                                <div class="col-lg-4">
                                    @if(isset($employee->id))
                                        <div class="card-toolbar">
                                            <a href="{{route('employee.gpf',['id'=>$employee->id,'l'=>5])}}" class="btn btn-info mr-2">কর্মচারীর সাধারণ ভবিষ্য তহবিল এবং এর অগ্রিম সংক্রান্ত তথ্যাদি</a>
                                        </div>
                                    @endif
                                </div>
                                <div class="col-lg-4">
                                    <div class="card-toolbar">
                                        <button type="submit" class="btn btn-success mr-2">Save Changes</button>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    @if(isset($employee->id))
                                        <div class="card-toolbar">
                                            <a href="{{route('employee.leave',['id'=>$employee->id,'l'=>7])}}" class="btn btn-info mr-2">কর্মচারীর গৃহীত অর্জিত ছুটি / লিয়েন সম্পর্কিত তথ্যাদি</a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                    </div>
                    <!--end::Body-->
                </form>
                <!--end::Form-->
            </div>
        </div>
        <!--end::Content-->
    </div>
    <!--end::Profile Personal Information-->

@endsection

{{-- Scripts Section --}}
@section('scripts')
    <script src="{{ asset('js/pages/widgets.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/pages/custom/profile/profile.js')}}"></script>
    <script>
        $(document).ready(function() {
            var loan = $('.loan_count').length;
            $(document).on('click', '.loan_add', function(event){
                loan++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.loan_add')}}?v="+loan,
                    method: 'get',
                    success: function(result){
                        $('.loan_add_body').append(result);
                    }
                });
            });
            $(document).on('click', '.remove_this', function(event){
                var id = $(this).attr('data');
                $(this).parent().parent().remove();
                var ddd = $('#removedata').attr('value');
                $('#removedata').attr('value', ddd +','+id)
            });

        });

    </script>
@endsection
