{{-- Extends layout --}}
@extends('layout.default')

{{-- Content --}}
@section('content')

    <!--begin::Profile Personal Information-->
    <div class="d-flex flex-row">
        @include("admin.employee.aside_nav")
        <!--begin::Content-->
        <div class="flex-row-fluid ml-lg-8">
            <!--begin::Card-->
            <div class="card card-custom card-stretch">
                <!--begin::Header-->
                <div class="card-header py-3">
                    <div class="card-title align-items-start flex-column">
                        <h3 class="card-label font-weight-bolder text-dark">৩। চাকরি সম্পর্কিত তথ্যাদি (Information Related to Service)</h3>
                        <span class="text-muted font-weight-bold font-size-sm mt-1">Update your information</span>
                    </div>
                </div>
                <!--end::Header-->

                <!--begin::Form-->
                <form class="form" method="post" action="{{route('employee.servicedb',['id'=>$employee->id])}}">@csrf
                    <!--begin::Body-->
                    <div class="card-body">
                        @if(!isset($employee->quota) || (int)$employee->quota < 1)
                            <div class="alert alert-warning" role="alert">
                                এই ফর্ম পুরন করার পূর্বে এই লিঙ্কে গিয়ে <a class="btn-sm btn-light-primary" href="{{route('manage_employee.edit',['id'=>$employee->id])}}">প্রাথমিক তথ্যাদি (Primary Information)</a> আপডেট করুন । কোঠা ও পদবী চেক করুন ।
                            </div>
                        @endif
                        <div class="row">
                            <label class="col-xl-3"></label>
                            <div class="col-lg-9 col-xl-6">
                                <h5 class="font-weight-bold mb-6"></h5>
                            </div>
                        </div>
                        <div class="row mb-10">
                            <label class="col-xl-3"></label>
                            <div class="col-lg-9 col-xl-9">
                                <h5 class="font-weight-bold mt-10 mb-6">৩.১ বর্তমান অবস্থান (Present Position)</h5>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label">কর্মস্থল [Working place]</label>
                            <div class="col-lg-9 col-xl-9">
{{--                                <input class="form-control form-control-lg form-control-solid" type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_first_joining->working_place)) readonly @else name="first_join[working_place]" @endif @if(isset($employee->employee_first_joining->working_place))value="{{$employee->employee_first_joining->working_place}}"@endif/>--}}
                                <select class="form-control " id="kt_select2_1" @if(isset($loggedin->employee_id) && isset($employee->employee_present_position->working_place) && (int)$employee->employee_present_position->working_place > 0) readonly @else  name="present_position[working_place]" @endif>
                                    <option>নির্বাচন করুন</option>
                                    @foreach($function->name_of_all_landport() as $key=>$port)
                                        <option value="{{$key}}" @if(isset($employee->employee_present_position->working_place) && (int)$employee->employee_present_position->working_place == $key){{__('selected')}}@endif>{{$port[0]}} ( {{$port[1]}} ) - {{$port[2]}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                            <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label">পদবী (Rank) <i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                            <div class="col-lg-9 col-xl-9">
                                <select class="form-control " id="kt_select2_1"  @if(isset($loggedin->employee_id) && isset($employee->rank) && (int)$employee->rank > 0) readonly  @else name="rank" @endif required>
                                    <option>নির্বাচন করুন</option>
                                    @foreach($function->rank() as $rank)
                                        <option value="{{$rank['id']}}" @if(isset($employee->rank) && (int)$employee->rank == (int)$rank['id']) selected @endif>{{$rank['name_en']}}({{$rank['name_bn']}})</option>
                                    @endforeach

                                </select>
                            </div>
                        <!-- <input type="text" class="form-control form-control-solid form-control-lg" @if(isset($loggedin->employee_id) && isset($employee->rank))readonly  @else name="rank" @endif  placeholder="Rank" required @if(isset($employee->rank))value="{{$employee->rank}}"@endif  style="border: 1px solid rgb(178, 34, 34,.4);"/>
{{--                                            <span class="form-text text-muted">Please enter your Address.</span>--}} -->
                        </div>
{{--                        <div class="form-group row">--}}
{{--                            <label class="col-xl-3 col-lg-3 col-form-label">বর্তমান পদ (Present Post)</label>--}}
{{--                            <div class="col-lg-9 col-xl-9">--}}
{{--                                <input class="form-control form-control-lg form-control-solid" type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_present_position->post)) readonly @else name="present_position[post]" @endif @if(isset($employee->employee_present_position->post))value="{{$employee->employee_present_position->post}}"@endif/>--}}
{{--                                <select class="form-control " id="kt_select2_1" @if(isset($loggedin->employee_id) && isset($employee->employee_present_position->post)) readonly @else  name="present_position[post]" @endif>--}}
{{--                                    <option>নির্বাচন করুন</option>--}}
{{--                                    @foreach($function->name_of_all_landport() as $key=>$port)--}}
{{--                                        <option value="{{$key}}" @if(isset($employee->employee_present_position->post) && (int)$employee->employee_present_position->post == $key){{__('selected')}}@endif>{{$port[0]}} ( {{$port[1]}} ) - {{$port[2]}}</option>--}}
{{--                                    @endforeach--}}
{{--                                </select>--}}
{{--                            </div>--}}
{{--                        </div>--}}
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label">বর্তমান পদে যোগদানের তারিখ (Joining Date at present position)</label>
                            <div class="col-lg-9 col-xl-9">
                                <input data-date-format="dd-mm-yyyy" readonly class="form-control form-control-lg form-control-solid kt_datepicker" type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_present_position->join_date)) @else  name="present_position[join_date]" @endif @if(isset($employee->employee_present_position->join_date))value="{{\Carbon\Carbon::parse($employee->employee_present_position->join_date)->format('d-m-Y')}}"@endif/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label">বর্তমান গ্রেড (Present Grade)</label>
{{--                            <div class="col-lg-9 col-xl-9">--}}
{{--                                <input class="form-control form-control-lg form-control-solid" type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_present_position->grade)) readonly @else  name="present_position[grade]" @endif @if(isset($employee->employee_present_position->grade))value="{{$employee->employee_present_position->grade}}"@endif/>--}}
{{--                            </div>--}}
                            <div class=" col-lg-9 col-md-9 col-sm-12">
                                <select class="form-control present_position_grade" id="kt_select2_1" @if(isset($loggedin->employee_id) && isset($employee->employee_present_position->grade_no) && (int)$employee->employee_present_position->grade_no > 0) readonly @else  name="present_position[grade]" @endif>
                                    <option>নির্বাচন করুন</option>
                                    @foreach($function->present_position_present_grade() as $key=>$grade)
                                        @if($grade[7] > 0)
                                            <option value="{{$key}}" @if(isset($employee->employee_present_position->grade) && (int)$employee->employee_present_position->grade == $key){{__('selected')}}@endif>{{$grade[0]}} ( {{$grade[1]}} )</option>
                                        @endif
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label">বর্তমান স্কেল (Present Scale)</label>
                            <div class="col-lg-9 col-xl-9">
{{--                                <input class="form-control form-control-lg form-control-solid" type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_present_position->scale)) readonly @else  name="present_position[scale]" @endif @if(isset($employee->employee_present_position->scale))value="{{$employee->employee_present_position->scale}}"@endif/>--}}
                                <select class="form-control present_position_scale" id="kt_select2_1" @if(isset($loggedin->employee_id) && isset($employee->employee_present_position->scale) && (int)$employee->employee_present_position->scale >0) readonly @else  name="present_position[scale]" @endif>
                                    <option>নির্বাচন করুন</option>
                                    @foreach($function->present_position_present_grade() as $key=>$grade)
                                        @if($grade[7] > 0)
                                            <option class="_{{$key}}" value="{{$key}}" @if(isset($employee->employee_present_position->scale) && (int)$employee->employee_present_position->scale == $key){{__('selected')}}@endif>{{$grade[2]}}-{{$grade[3]}} ( {{$grade[4]}}-{{$grade[5]}} )</option>
                                        @endif
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <script>
                            $(document).ready(function() {
                                $(document).on("change",".present_position_grade", function(){
                                    $(".present_position_scale option._"+$(this).val()).removeAttr("hidden").attr("selected",true);
                                });
                            });
                        </script>
                        <div class="form-group row">
                            <label class="col-form-label text-left col-lg-3 col-sm-12">বর্তমান শ্রেণী (Present Class)</label>
                            <div class=" col-lg-9 col-md-9 col-sm-12">
                                <select class="form-control " id="kt_select2_1" @if(isset($loggedin->employee_id) && isset($employee->employee_present_position->class)) readonly @else  name="present_position[class]" @endif>
                                    <option>নির্বাচন করুন</option>
                                    @foreach($function->present_position_present_class() as $key=>$class)
                                        <option value="{{$key}}" @if(isset($employee->employee_present_position->class) && (int)$employee->employee_present_position->class == $key){{__('selected')}}@endif>{{$class[0]}} ( {{$class[1]}} )</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="row border-bottom">
                            <label class="col-xl-3"></label>
                            <div class="col-lg-9 col-xl-6">
                                <h5 class="font-weight-bold mb-6"></h5>
                            </div>
                        </div>
                        <div id="first_join_track_id" class="row mt-2 mb-2">
                            <label class="col-xl-3"></label>
                            <div class="col-lg-9 col-xl-9">
                                <h5 class="font-weight-bold mt-10 mb-6">৩.২ প্রথম যোগদান (First Joining)</h5>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label">প্রথম যোগদানের কর্মস্থল [Working place of first joining]</label>
                            <div class="col-lg-9 col-xl-9">
{{--                                <input class="form-control form-control-lg form-control-solid" type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_first_joining->working_place)) readonly @else name="first_join[working_place]" @endif @if(isset($employee->employee_first_joining->working_place))value="{{$employee->employee_first_joining->working_place}}"@endif/>--}}
                                <select class="form-control " id="kt_select2_1" @if(isset($loggedin->employee_id) && isset($employee->employee_first_joining->working_place) && (int)$employee->employee_first_joining->working_place > 0) readonly @else  name="first_join[working_place]" @endif>
                                    <option>নির্বাচন করুন</option>
                                    @foreach($function->name_of_all_landport() as $key=>$port)
                                        <option value="{{$key}}" @if(isset($employee->employee_first_joining->working_place) && (int)$employee->employee_first_joining->working_place == $key){{__('selected')}}@endif>{{$port[0]}} ( {{$port[1]}} ) - {{$port[2]}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h6 class="mt-10 mb-6">প্রথম যোগদানের তারিখ, গ্রেড ও স্কেল (Grade and scale of first joining)</h6>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label">সরকারি চাকরির ক্ষেত্রে (In case of government service)</label>
                            <div class="col-lg-9 col-xl-9">
                                <div class="row">
                                    <label class="col-xl-3 col-lg-3 col-form-label">তারিখ</label>
                                    <input data-date-format="dd-mm-yyyy" readonly class="form-control form-control-lg form-control-solid kt_datepicker" type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_first_joining->time)) @else name="first_join[time]" @endif @if(isset($employee->employee_first_joining->time))value="{{\Carbon\Carbon::parse($employee->employee_first_joining->time)->format('d-m-Y')}}"@endif/>
                                </div>
                                <div class="row">
                                    <label class="col-xl-3 col-lg-3 col-form-label">গ্রেড</label>
                                    <select class="form-control first_join_grade" id="kt_select2_1" @if(isset($loggedin->employee_id) && isset($employee->employee_first_joining->grade) && (int)$employee->employee_first_joining->grade > 0) readonly @else  name="first_join[grade]" @endif>
                                        <option>নির্বাচন করুন</option>
                                        @foreach($function->present_position_present_grade() as $key=>$grade)
                                            <option value="{{$key}}" @if(isset($employee->employee_first_joining->grade) && (int)$employee->employee_first_joining->grade == $key){{__('selected')}}@endif>{{$grade[0]}} ( {{$grade[1]}} )</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="row">
                                    <label class="col-xl-3 col-lg-3 col-form-label">স্কেল</label>
{{--                                    <input class="form-control form-control-lg form-control-solid" type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_first_joining->scale)) readonly @else name="first_join[scale]" @endif @if(isset($employee->employee_first_joining->scale))value="{{$employee->employee_first_joining->scale}}"@endif/>--}}
                                    <select class="form-control first_join_scale" id="kt_select2_1" @if(isset($loggedin->employee_id) && isset($employee->employee_first_joining->scale)) readonly @else  name="first_join[scale]" @endif>
                                        <option>নির্বাচন করুন</option>
                                        @foreach($function->present_position_present_grade() as $key=>$grade)
                                            <option class="_{{$key}}" value="{{$key}}" @if(isset($employee->employee_first_joining->scale) && (int)$employee->employee_first_joining->scale == $key){{__('selected')}}@endif>{{$grade[2]}}-{{$grade[3]}} ( {{$grade[4]}}-{{$grade[5]}} )</option>
                                        @endforeach
                                    </select>
                                </div>
                                <script>
                                    $(document).ready(function() {
                                        $(document).on("change",".first_join_grade", function(){
                                            $(".first_join_scale option._"+$(this).val()).removeAttr("hidden").attr("selected",true);
                                        });
                                    });
                                </script>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label">পূর্ববর্তী চাকরির ক্ষেত্রে (আত্তীকৃত/জাতীয়করণকৃত/স্থানান্তরিত) [In case of previous job (Assimilated / nationalized / transferred)]</label>
                            <div class="col-lg-9 col-xl-9">
                                <div class="row">
                                    <label class="col-xl-3 col-lg-3 col-form-label">তারিখ</label>
                                    <input data-date-format="dd-mm-yyyy" readonly  class="form-control form-control-lg form-control-solid kt_datepicker" type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_first_joining->old_time)) @else name="first_join[old_time]" @endif @if(isset($employee->employee_first_joining->old_time))value="{{\Carbon\Carbon::parse($employee->employee_first_joining->old_time)->format('d-m-Y')}}"@endif/>
                                </div>
                                <div class="row">
                                    <label class="col-xl-3 col-lg-3 col-form-label">গ্রেড</label>
                                    <select class="form-control first_join_old_grade" id="kt_select2_1" @if(isset($loggedin->employee_id) && isset($employee->employee_first_joining->old_grade)) readonly @else  name="first_join[old_grade]" @endif>
                                        <option>নির্বাচন করুন</option>
                                        @foreach($function->present_position_present_grade() as $key=>$grade)
                                            <option value="{{$key}}" @if(isset($employee->employee_first_joining->old_grade) && (int)$employee->employee_first_joining->old_grade == $key){{__('selected')}}@endif>{{$grade[0]}} ( {{$grade[1]}} )</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="row">
                                    <label class="col-xl-3 col-lg-3 col-form-label">স্কেল</label>
{{--                                    <input class="form-control form-control-lg form-control-solid" type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_first_joining->old_scale)) readonly @else name="first_join[old_scale]" @endif @if(isset($employee->employee_first_joining->old_scale))value="{{$employee->employee_first_joining->old_scale}}"@endif/>--}}
                                    <select class="form-control first_join_old_scale" id="kt_select2_1" @if(isset($loggedin->employee_id) && isset($employee->employee_first_joining->old_scale)) readonly @else  name="first_join[old_scale]" @endif>
                                        <option>নির্বাচন করুন</option>
                                        @foreach($function->present_position_present_grade() as $key=>$grade)
                                            <option class="_{{$key}}" value="{{$key}}" @if(isset($employee->employee_first_joining->old_scale) && (int)$employee->employee_first_joining->old_scale == $key){{__('selected')}}@endif>{{$grade[2]}}-{{$grade[3]}} ( {{$grade[4]}}-{{$grade[5]}} )</option>
                                        @endforeach
                                    </select>
                                </div>
                                <script>
                                    $(document).ready(function() {
                                        $(document).on("change",".first_join_old_grade", function(){
                                            $(".first_join_old_scale option._"+$(this).val()).removeAttr("hidden").attr("selected",true);
                                        });
                                    });
                                </script>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label">চাকরি স্থায়ীকরন [Job permanent]</label>
                            <div class="col-lg-9 col-xl-9">
                                <div class="row">
                                    <label class="col-xl-3 col-lg-3 col-form-label">তারিখ</label>
                                    <input data-date-format="dd-mm-yyyy" readonly  class="form-control form-control-lg form-control-solid kt_datepicker" type="text" @if(isset($loggedin->employee_id) && isset($employee->employee_first_joining->job_permanent_date)) @else name="first_join[job_permanent_date]" @endif @if(isset($employee->employee_first_joining->job_permanent_date))value="{{\Carbon\Carbon::parse($employee->employee_first_joining->job_permanent_date)->format('d-m-Y')}}"@endif/>
                                </div>
                                <div class="row">
                                    <label class="col-xl-3 col-lg-3 col-form-label">পদবী [Rank]</label>
                                    <select class="form-control " id="kt_select2_1" @if(isset($loggedin->employee_id) && isset($employee->employee_first_joining->job_permanent_rank) && (int)$employee->employee_first_joining->job_permanent_rank > 0) readonly @else  name="first_join[job_permanent_rank]" @endif>
                                        <option>নির্বাচন করুন</option>
                                        @foreach($function->rank() as $key=>$rank)
                                            <option value="{{$key}}" @if(isset($employee->employee_first_joining->job_permanent_rank) && (int)$employee->employee_first_joining->job_permanent_rank == $key){{__('selected')}}@endif>{{$rank['name_bn']}} ( {{$rank['name_en']}} )</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row border-bottom">
                            <label class="col-xl-3"></label>
                            <div class="col-lg-9 col-xl-6">
                                <h5 class="font-weight-bold mb-6"></h5>
                            </div>
                        </div>


                        <div id="promotion_scale_track_id" class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h5 class="font-weight-bold mt-10 mb-6">৩.৩ পদোন্নতি সংক্রান্ত তথ্যাদি (Promotion Information)</h5>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info service_promotion">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body service_promotion_body">
                            @include('admin.employee.extra_partial_page.service_promotion')
                        </div>
                        <div class="row border-bottom">
                            <label class="col-xl-3"></label>
                            <div class="col-lg-9 col-xl-6">
                                <h5 class="font-weight-bold mb-6"></h5>
                            </div>
                        </div>
                        <div class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h5 class="font-weight-bold mt-10 mb-6">৩.৪ কর্মস্থল পরিবর্তন/বদলি সংক্রান্ত তথ্যাদি (Transfer Information)</h5>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info service_transfer">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body service_transfer_body">
                            @include('admin.employee.extra_partial_page.service_transfer')
                        </div>
                        <div class="row border-bottom">
                            <label class="col-xl-3"></label>
                            <div class="col-lg-9 col-xl-6">
                                <h5 class="font-weight-bold mb-6"></h5>
                            </div>
                        </div>



                        <div class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h5 class="font-weight-bold mt-10 mb-6">৩.৫ স্কেল পরিবর্তন সংক্রান্ত তথ্যাদি (Information on pay scale)</h5>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info pay_scale_change">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body pay_scale_change_body">
                            @include('admin.employee.extra_partial_page.service_pay_scale_change')
                        </div>

                        <div class="row border-bottom">
                            <label class="col-xl-3"></label>
                            <div class="col-lg-9 col-xl-6">
                                <h5 class="font-weight-bold mb-6"></h5>
                            </div>
                        </div>





                        <div id="gov_accommodation_track_id" class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h5 class="font-weight-bold mt-10 mb-6">৩.৬ সরকারি আবাসন সংক্রান্ত তথ্যাদি (Information related to government accommodation)</h5>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info service_accommodation">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body service_accommodation_body">
                            @include('admin.employee.extra_partial_page.service_accommodation')
                        </div>
                        <div class="card-footer">
                            <div class="row">
                                <div class="col-lg-4">
                                    @if(isset($employee->id))
                                        <div class="card-toolbar">
                                            <a href="{{route('employee.service',['id'=>$employee->id,'l'=>2])}}" class="btn btn-info mr-2">কর্মচারীর ব্যাক্তিগত , পারিবারিক এবং ব্যাংক অ্যাকাউন্ট সম্পর্কিত তথ্যাদি</a>
                                        </div>
                                    @endif
                                </div>
                                <div class="col-lg-4 d-none">
                                    <input id="removedata" type="text" name="remove" value="" hidden>
                                </div>
                                <div class="col-lg-4">
                                    <div class="card-toolbar">
                                        <button type="submit" class="btn btn-success mr-2">Save Changes</button>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    @if(isset($employee->id))
                                        <div class="card-toolbar">
                                            <a href="{{route('employee.pay_allowanced_deduction',['id'=>$employee->id,'l'=>4])}}" class="btn btn-info mr-2">কর্মচারীর বেতন ভাতাদি ও কর্তন সম্পর্কিত তথ্যাদি</a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                    </div>
                    <!--end::Body-->
                </form>
                <!--end::Form-->
            </div>
        </div>
        <!--end::Content-->
    </div>
    <!--end::Profile Personal Information-->

@endsection

{{-- Scripts Section --}}
@section('scripts')
    <script src="{{ asset('js/pages/widgets.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/pages/custom/profile/profile.js')}}"></script>
    <script>
        $(document).ready(function() {
            var service_promotion = 0;
            $(document).on('click', '.service_promotion', function(event){
                service_promotion++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.service_promotion')}}?v="+service_promotion,
                    method: 'get',
                    success: function(result){
                        $('.service_promotion_body').append(result);
                    }
                });
            });
            var service_transfer = 0;
            $(document).on('click', '.service_transfer', function(event){
                service_transfer++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.service_transfer')}}?v="+service_transfer+'&r=@if(isset($employee->rank) && (int)$employee->rank > 0){{(int)$employee->rank}}@endif',
                    method: 'get',
                    success: function(result){
                        $('.service_transfer_body').append(result);
                    }
                });
            });
            var pay_scale_change = 0;
            $(document).on('click', '.pay_scale_change', function(event){
                pay_scale_change++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.pay_scale_change')}}?v="+pay_scale_change+"&e={{$employee->id}}",
                    method: 'get',
                    success: function(result){
                        $('.pay_scale_change_body').append(result);
                    }
                });
            });
            var service_accommodation = 0;
            @if(isset($employee->employee_accommodation) && count($employee->employee_accommodation) > 0)
            service_accommodation = {{count($employee->employee_accommodation)}};
            @endif
            $(document).on('click', '.service_accommodation', function(event){
                service_accommodation++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.service_accommodation')}}?v="+service_accommodation,
                    method: 'get',
                    success: function(result){
                        $('.service_accommodation_body').append(result);
                    }
                });
            });
            $(document).on('click', '.remove_this', function(event){
                var id = $(this).attr('data');
                $(this).parent().parent().remove();
                var ddd = $('#removedata').attr('value');
                $('#removedata').attr('value', ddd +','+id)
            });
        });

    </script>
@endsection
