{{-- Extends layout --}}
@extends('layout.default')

{{-- Content --}}
@section('content')

<div class="card card-custom gutter-b">
    <div class="card-header flex-wrap py-3">
        <div class="card-title">
            <h3 class="card-label">
                Employee Information Change Log
            </h3>
        </div>
    </div>
    <div class="card-body" id="employee_list">
        <table class="table table-bordered nowrap" id="kt_datatable_em">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Data Type</th>
                    <th>From</th>
                    <th>To</th>
                    <th>Action Type</th>
                    <th>Changed By</th>
                </tr>
            </thead>
            <tbody>
                @foreach($employee as $emp)
                    @foreach($emp->record_changelog as $log)
                        <tr>
                            <td>{{\Carbon\Carbon::parse($log->created_at)->format('d F,Y h:i')}}</td>
                            <td>{{$log->name}}</td>
                            <td>{{$log->old}}</td>
                            <td>{{$log->new}}</td>
                            <td>@if($log->record_type == 1) New Record @elseif($log->record_type == 3) Deleted @else Updated @endif</td>
                            <td>{{$log->user->name}}{{--/{{$log->user->email}}--}}</td>
                        </tr>
                    @endforeach
                @endforeach
            </tbody>
        </table>
    </div>
</div>
<!--end: Datatable-->



@endsection

{{-- Scripts Section --}}
@section('scripts')
<script src="{{ asset('plugins/custom/datatables/datatables.bundle.js') }}" type="text/javascript"></script>
<script>
    $(document).ready(function() {
        var table = $('#kt_datatable_em');
        table.DataTable({
            responsive: true,

        });
    });
</script>
@endsection
