{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css"/>
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    @php
        $em_Grade = $function->present_position_present_grade();
        $em_Scale = $function->present_position_present_grade();
    @endphp
    {{-- Dashboard 1 --}}
    <div class="row d-flex">
        <div class="col-xl-6 col-md-6 form-group d-flex">
            <label class="col-form-label text-left col-md-3">পদবী (Rank)</label>
            <div class="col-md-9 text-right">
                    <select class="form-control dropdown_rank">
                        <option value="-1">All Rank</option>
                        @foreach($function->rank() as $key=>$rank)
                        <option value="{{$key}}">{{$rank['name_bn']}} ({{$rank['name_en']}})</option>
                        @endforeach
                    </select>
            </div>
        </div>
        <div class="col-xl-6 col-md-6 form-group d-flex">
            <label class="col-form-label text-left col-md-3">বর্তমান কর্মস্থল (Present Working Place)</label>
            <div class="col-md-9 text-right">
                <select class="form-control dropdown_working_place">
                    <option value="-1">All working place</option>
                    @foreach($function->name_of_all_landport() as $key=>$workingplace)
                        <option value="{{$key}}">{{$workingplace[0]}} ({{$workingplace[1]}})</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-xl-6 col-md-6 form-group d-flex">
            <label class="col-form-label text-left col-md-3">বদলি (Transfer) ( আজকের দিনে কর্মরত )</label>
            <div class="col-md-9 text-right">
                <select class="form-control dropdown_transfer">
                    <option value="-1">All</option>
                    @foreach($function->name_of_all_landport() as $key=>$workingplace)
                        <option value="{{$key}}">{{$workingplace[0]}} ({{$workingplace[1]}})</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-xl-6 col-md-6 form-group d-flex">
            <label class="col-form-label text-left col-md-3">গ্রেড ( Grade )</label>
            <div class="col-md-9 text-right">
                <select class="form-control dropdown_grade" data-live-search="true">
                    <option value="-1">All Grade</option>
                    @foreach($function->present_position_present_grade() as $key=>$Grade)
                        @if($Grade[7] > 0)
                        <option value="{{$key}}">{{$Grade[0]}}</option>
                        @endif
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-xl-6 col-md-6 form-group d-flex">
            <label class="col-form-label text-left col-md-3">বেতন স্কেল (Scale)</label>
            <div class="col-md-9 text-right">
                <select class="form-control dropdown_scale" data-live-search="true">
                    <option value="-1">All scale</option>
                    @foreach($function->present_position_present_grade() as $key=>$Scale)
                        @if($Scale[7] > 0)
                        <option value="{{$key}}">{{$Scale[4]}}-{{$Scale[5]}}</option>
                        @endif
                    @endforeach
                </select>
            </div>
        </div>
{{--        <div class="col-xl-6 col-md-6 form-group d-flex">--}}
{{--            <label class="col-form-label text-left col-md-3">Class</label>--}}
{{--            <div class="col-md-9 text-right">--}}
{{--                <select class="form-control dropdown_class" data-live-search="true">--}}
{{--                    <option value="">Select</option>--}}
{{--                    @foreach($em_Class as $Class)--}}
{{--                        <option value="{{$Class}}">{{$Class}}</option>--}}
{{--                    @endforeach--}}
{{--                </select>--}}
{{--            </div>--}}
{{--        </div>--}}
    </div>



    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title">
                <h3 class="card-label">
                    Employee List
{{--                    <span class="d-block text-muted pt-2 font-size-sm">sorting & pagination remote datasource</span>--}}
                </h3>
            </div>
            <div class="card-toolbar">
                <!--begin::Button-->
                <a href="{{route('manage_employee.addnew')}}" class="btn btn-primary font-weight-bolder">
                    <span class="svg-icon svg-icon-md">
                         {{ Metronic::getSVG("media/svg/icons/Design/Flatten.svg", "svg-icon-lg svg-icon-primary") }}
                    </span>	New Record
                </a>
                <!--end::Button-->
            </div>
        </div>
        <div class="card-body" id="employee_list">
            <!--begin: Datatable-->
            @include('admin.employee.table.index')
        </div>
    </div>
    <!--end::Card-->

@endsection

{{-- Scripts Section --}}
@section('scripts')
{{--    <script src="{{ asset('js/pages/widgets.js') }}" type="text/javascript"></script>--}}
    <script src="{{ asset('plugins/custom/datatables/datatables.bundle.js') }}" type="text/javascript"></script>
{{--    <script src="{{ asset('js/pages/crud/datatables/basic/basic.js') }}" type="text/javascript"></script>--}}
{{--    <script src="{{asset('js/pages/crud/forms/widgets/bootstrap-select.js')}}"></script>--}}
<script>
$(document).ready(function() {

    var dropdown_rank = -1;
    var dropdown_working_place = -1;
    var dropdown_transfer = -1;
    var dropdown_grade = -1;
    var dropdown_scale = -1;

    function searchdata(rank, working_place, transfer, grade, scale) {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        // console.log(c_s,ex,vn,bg,r_a,ta_kg);
        jQuery.ajax({
            url: "{{route("ajaxcall.employee_list")}}",
            method: 'post',
            data: {
                rank: rank,
                working_place: working_place,
                transfer: transfer,
                grade: grade,
                scale: scale,
            },
            success: function (result) {
                // console.log(result);
                $("#employee_list").html(result);
            }
        })
    }

    $(document).on("change", ".dropdown_rank", function () {
        dropdown_rank = $(this).val();
        searchdata(dropdown_rank, dropdown_working_place, dropdown_transfer, dropdown_grade, dropdown_scale);
    });
    $(document).on("change", ".dropdown_working_place", function () {
        dropdown_working_place = $(this).val();
        searchdata(dropdown_rank, dropdown_working_place, dropdown_transfer, dropdown_grade, dropdown_scale);
    });
    $(document).on("change", ".dropdown_transfer", function () {
        dropdown_transfer = $(this).val();
        searchdata(dropdown_rank, dropdown_working_place, dropdown_transfer, dropdown_grade, dropdown_scale);
    });
    $(document).on("change", ".dropdown_grade", function () {
        dropdown_grade = $(this).val();
        searchdata(dropdown_rank, dropdown_working_place, dropdown_transfer, dropdown_grade, dropdown_scale);
    });
    $(document).on("change", ".dropdown_scale", function () {
        dropdown_scale = $(this).val();
        searchdata(dropdown_rank, dropdown_working_place, dropdown_transfer, dropdown_grade, dropdown_scale);
    });
    // $(document).on("change", ".dropdown_class", function () {
    //     dropdown_class = $(this).val();
    // });



});
</script>

@endsection
