{{-- Extends layout --}}
@extends('layout.default')

{{-- Content --}}
@section('content')

    <!--begin::Profile Personal Information-->
    <div class="d-flex flex-row">
        @include("admin.employee.aside_nav")
        <!--begin::Content-->
        <div class="flex-row-fluid ml-lg-8">
            <!--begin::Card-->
            <div class="card card-custom card-stretch">
                <!--begin::Header-->
                <div class="card-header py-3">
                    <div class="card-title align-items-start flex-column">
                        <h3 class="card-label font-weight-bolder text-dark">৫। সাধারণ ভবিষ্য তহবিল এবং এর অগ্রিম সংক্রান্ত তথ্যাদি (Information Related to GPF and its Advance)</h3>
                        <span class="text-muted font-weight-bold font-size-sm mt-1">Update your information</span>
                    </div>
                </div>
                <!--end::Header-->

                <!--begin::Form-->
                <form class="form" method="post" action="{{route('employee.gpfdb',['id'=>$employee->id])}}">@csrf
                    <!--begin::Body-->
                    <div class="card-body">
                        <div class="row">
                            <label class="col-xl-3"></label>
                            <div class="col-lg-9 col-xl-6">
                                <h5 class="font-weight-bold mb-6"></h5>
                            </div>
                        </div>
                        <div class="row mb-10">
                            <div class="col-lg-12 col-xl-12  text-center">
                                <h5 class="font-weight-bold mt-10 mb-6">৫.১ সাধারণ ভবিষ্য তহবিল (GPF)</h5>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-form-label text-left col-lg-6 col-sm-12">ভবিষ্য তহবিলের প্রকৃতি (Nature of provident fund)</label>
                            <div class=" col-lg-6 col-md-6 col-sm-12">
                                <select class="form-control " id="kt_select2_1" @if(isset($loggedin->employee_id) && isset($employee->employee_gpf->nature) && (int)$employee->employee_gpf->nature > 0) readonly @else name="gpf_nopf" @endif>
                                    <option value="0">নির্বাচন করুন</option>
                                    <option value="1" @if(isset($employee->employee_gpf->nature) && $employee->employee_gpf->nature == 1){{__('selected')}}@endif>ইনক্রিমেন্ট/সুদ সহ (With increment/interest)</option>
                                    <option value="2" @if(isset($employee->employee_gpf->nature) && $employee->employee_gpf->nature == 2){{__('selected')}}@endif>ইনক্রিমেন্ট/সুদ ব্যতিত (Without increment/interest)</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-lg-6 col-xl-6 col-form-label">হিসাব নম্বর (Account Number)</label>
                            <div class="col-lg-6 col-xl-6">
                                <input class="form-control form-control-lg form-control-solid" type="number" @if(isset($loggedin->employee_id) && isset($employee->employee_gpf->account_number)) readonly @else name="gpf_account_number" @endif  @if(isset($employee->employee_gpf->account_number)) value="{{$employee->employee_gpf->account_number}}" @endif/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-lg-6 col-xl-6 col-form-label">ভলিউম নাম্বার (Volume Number)</label>
                            <div class="col-lg-6 col-xl-6">
                                <input class="form-control form-control-lg form-control-solid" type="number" @if(isset($loggedin->employee_id) && isset($employee->employee_gpf->volume_number)) readonly @else name="gpf_volume_number" @endif @if(isset($employee->employee_gpf->volume_number)) value="{{$employee->employee_gpf->volume_number}}" @endif/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-lg-6 col-xl-6 col-form-label">সর্বশেষ পৃষ্ঠা নাম্বার (Latest Page Number)</label>
                            <div class="col-lg-6 col-xl-6">
                                <input class="form-control form-control-lg form-control-solid" type="number" @if(isset($loggedin->employee_id) && isset($employee->employee_gpf->latest_page)) readonly @else name="gpf_lpn" @endif @if(isset($employee->employee_gpf->latest_page)) value="{{$employee->employee_gpf->latest_page}}" @endif/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-lg-6 col-xl-6 col-form-label">বর্তমান মাসিক চাদা কর্তনের পরিমাণ (Monthly Amount Deducted as Subscription at Present)</label>
                            <div class="col-lg-6 col-xl-6">
                                <input class="form-control form-control-lg form-control-solid" type="number" @if(isset($loggedin->employee_id) && isset($employee->employee_gpf->subscription)) readonly @else name="gpf_msdap" @endif @if(isset($employee->employee_gpf->subscription)) value="{{$employee->employee_gpf->subscription}}" @endif/>
                            </div>
                        </div>


                        <div class="row">
                            <label class="col-xl-6"></label>
                            <div class="col-lg-9 col-xl-6">
                                <h5 class="font-weight-bold mb-6"></h5>
                            </div>
                        </div>
                        <div id="gpf_nominee_track_id" class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h5 class="font-weight-bold mt-10 mb-6">৫.২ জিপিএফ নমিনি সংক্রান্ত তথ্যাদি (Information Related to GPF Nominee)</h5>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info gpf_nomine">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body">
                            @foreach($employee->employee_family_info as $family)
                                @if($family->husbandwife == 1)
                                <button class="emfamily_info family{{$family->nid}} badge badge-primary" type="button" data="{{$family->id}}">Add H/W - {{$family->name_bangla}}</button>
                                @endif
                                @if($family->child == 1 && $family->autistic == 0)
                                    <button class="emfamily_info family{{$family->nid}} badge badge-primary" type="button" data="{{$family->id}}">Add {{$family->relation}} - {{$family->name_bangla}}</button>
                                @endif
                                @if($family->child == 1 && $family->autistic == 1)
                                    <button class="emfamily_info family{{$family->nid}} badge badge-primary" type="button" data="{{$family->id}}">Add Autistic - {{$family->name_bangla}}</button>
                                @endif
                            @endforeach
                        </div>
                        <div class="card-body gpf_nomine_body">
                            @include('admin.employee.extra_partial_page.gpf_nomine')
                        </div>
                        <div class="row">
                            <label class="col-xl-6"></label>
                            <div class="col-lg-9 col-xl-6">
                                <h5 class="font-weight-bold mb-6"></h5>
                            </div>
                        </div>
                        <div id="gpf_advance_track_id" class="row mt-2 mb-2">
                            <div class="col-lg-9 col-xl-9">
                                <h5 class="font-weight-bold mt-10 mb-6">৫.৩ চলমান জিপিএফ অগ্রিম (Current GPF Advance)</h5>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info gpf_adv">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body gpf_adv_body">
                            @include('admin.employee.extra_partial_page.gpf_advance')
                        </div>
                        <div class="card-footer">
                            <div class="row">
                                <div class="col-lg-4">
                                    @if(isset($employee->id))
                                        <div class="card-toolbar">
                                            <a href="{{route('employee.pay_allowanced_deduction',['id'=>$employee->id,'l'=>4])}}" class="btn btn-info mr-2">কর্মচারীর বেতন ভাতাদি ও কর্তন সম্পর্কিত তথ্যাদি </a>
                                        </div>
                                    @endif
                                </div>
                                <div class="col-lg-4 d-none"> <input id="removedata" type="text" name="remove" value="" hidden></div>
                                <div class="col-lg-4">
                                    <div class="card-toolbar">
                                        <button type="submit" class="btn btn-success mr-2">Save Changes</button>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    @if(isset($employee->id))
                                        <div class="card-toolbar">
                                            <a href="{{route('employee.loan',['id'=>$employee->id,'l'=>6])}}" class="btn btn-info mr-2">কর্মচারীর বর্তমান ঋণ সংক্রান্ত তথ্যাদি   </a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                    </div>
                    <!--end::Body-->
                </form>
                <!--end::Form-->
            </div>
        </div>
        <!--end::Content-->
    </div>
    <!--end::Profile Personal Information-->

@endsection

{{-- Scripts Section --}}
@section('scripts')
    <script src="{{ asset('js/pages/widgets.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/pages/custom/profile/profile.js')}}"></script>
    <script>
        $(document).ready(function() {
            var gpf_nomine = $('.gpf_nomini_count').length;
            var gpf_adv = $('.gpf_advance_count').length;
            $(document).on('click', '.gpf_nomine', function(event){
                gpf_nomine++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.gpf_nomine')}}?v="+gpf_nomine,
                    method: 'get',
                    success: function(result){
                        $('.gpf_nomine_body').append(result);
                    }
                });
            });
            $(document).on('click', '.gpf_adv', function(event){
                gpf_adv++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.gpf_adv')}}?v="+gpf_adv,
                    method: 'get',
                    success: function(result){
                        $('.gpf_adv_body').append(result);
                    }
                });
            });
            $(document).on('click', '.remove_this', function(event){
                var id = $(this).attr('data');
                $(this).parent().parent().remove();
                var ddd = $('#removedata').attr('value');
                $('#removedata').attr('value', ddd +','+id)
            });

        });

    </script>
    <script>
        $(document).ready(function() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $(document).on('click', '.emfamily_info', function(event){
                jQuery.ajax({
                    url: "{{route('ajaxcall.find_relation')}}",
                    method: 'post',
                    data: {
                        data: $(this).attr('data'),
                        gpf: 1,
                    },
                    success: function(result){
                        $('.gpf_nomine_body').append(result);
                    }
                })
            });
        });
    </script>
@endsection
