{{-- Extends layout --}}
@extends('layout.default')

{{-- Content --}}
@section('content')

    <!--begin::Profile Personal Information-->
    <div class="d-flex flex-row">
        @include("admin.employee.aside_nav")
        <!--begin::Content-->
        <div class="flex-row-fluid ml-lg-8">
            <!--begin::Card-->
            <div class="card card-custom card-stretch">
                <!--begin::Header-->
                <div class="card-header py-3">
                    <div class="card-title align-items-start flex-column">
                        <h3 class="card-label font-weight-bolder text-dark">৭। গৃহীত অর্জিত ছুটি / লিয়েন সম্পর্কিত তথ্যাদি (Information related to Earn leave/Lien availed)</h3>
                        <span class="text-muted font-weight-bold font-size-sm mt-1">Update your information</span>
                    </div>
                </div>
                <!--end::Header-->

                <!--begin::Form-->
                <form class="form" method="post" action="{{route('employee.leavedb',['id'=>$employee->id])}}">@csrf
                    <!--begin::Body-->
                    <div class="card-body">
                        <div class="row">
                            <label class="col-xl-3"></label>
                            <div class="col-lg-9 col-xl-6">
                                <h5 class="font-weight-bold mb-6"></h5>
                            </div>
                        </div>
                        <div class="row mb-10">
                            <div class="col-lg-9 col-xl-9">
                                <h5 class="font-weight-bold mt-10 mb-6">৭.১ অনুমোদিত ছুটি (Earned Leave)</h5>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info authorized_leave">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body authorized_leave_body">
                            @include('admin.employee.extra_partial_page.authorized_leave')
                        </div>
                        <div class="row">
                            <label class="col-xl-3"></label>
                            <div class="col-lg-9 col-xl-6">
                                <h5 class="font-weight-bold mb-6"></h5>
                            </div>
                        </div>
                        <div id="lien_track_id" class="row mb-10">
                            <div class="col-lg-9 col-xl-9">
                                <h5 class="font-weight-bold mt-10 mb-6">৭.২ লিয়েন (Lien)</h5>
                            </div>
                            <div class="col-lg-3 col-xl-3 my-auto text-right">
                                <button type="button" class="btn btn-info lien">Add new</button>
                            </div>
                        </div>
                        <div class="card-body text-center p-0">If form not filled click <i class="fa fa-trash text-danger"></i> to delete</div>
                        <div class="card-body lien_body">
                            @include('admin.employee.extra_partial_page.lien')
                        </div>
                        <div class="card-footer">
                            <div class="row">
                                <div class="col-lg-4">
                                    @if(isset($employee->id))
                                        <div class="card-toolbar">
                                            <a href="{{route('employee.loan',['id'=>$employee->id,'l'=>6])}}" class="btn btn-info mr-2">কর্মচারীর বর্তমান ঋণ সংক্রান্ত তথ্যাদি</a>
                                        </div>
                                    @endif
                                </div>
                                <div class="col-lg-4 d-none"> <input id="removedata" type="text" name="remove" value="" hidden></div>
                                <div class="col-lg-4">
                                    <div class="card-toolbar">
                                        <button type="submit" class="btn btn-success mr-2">Save Changes</button>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    @if(isset($employee->id))
                                        <div class="card-toolbar">
                                            <a href="{{route('employee.disciplinary',['id'=>$employee->id,'l'=>8])}}" class="btn btn-info mr-2">কর্মচারীর শৃঙ্খলামুলক ব্যবস্থা</a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                    </div>
                    <!--end::Body-->
                </form>
                <!--end::Form-->
            </div>
        </div>
        <!--end::Content-->
    </div>
    <!--end::Profile Personal Information-->

@endsection

{{-- Scripts Section --}}
@section('scripts')
    <script src="{{ asset('js/pages/widgets.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/pages/custom/profile/profile.js')}}"></script>
    <script>
        $(document).ready(function() {
            var authorized_leave = 0;
            $(document).on('click', '.authorized_leave', function(event){
                authorized_leave++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.authorized_leave')}}?v="+authorized_leave,
                    method: 'get',
                    success: function(result){
                        $('.authorized_leave_body').append(result);
                    }
                });
            });
            var lien = 0;
            $(document).on('click', '.lien', function(event){
                lien++;
                jQuery.ajax({
                    url: "{{route('ajaxcall.lien')}}?v="+lien,
                    method: 'get',
                    success: function(result){
                        $('.lien_body').append(result);
                    }
                });
            });
            $(document).on('click', '.remove_this', function(event){
                var id = $(this).attr('data');
                $(this).parent().parent().remove();
                var ddd = $('#removedata').attr('value');
                $('#removedata').attr('value', ddd +','+id)
            });
        });

    </script>
@endsection
