{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Custom Styles(used by this page)-->
    <link href="{{ asset('css/pages/wizard/wizard-1.css') }}" rel="stylesheet" type="text/css"/>
    <!--end::Page Custom Styles-->
@endsection
{{-- Content --}}
@section('content')
    {{-- Dashboard 1 --}}

    <!--begin::Entry-->
    <div class="d-flex flex-column-fluid">
        <!--begin::Container-->
        <div class=" container ">
            <div class="card card-custom">
                <div class="card-body p-0">
                    <!--begin::Wizard-->
{{--                    data-wizard-state="step-first" data-wizard-clickable="false"--}}
                    <div class="wizard wizard-1" id="kt_wizard_v1" >
{{--                        <!--begin::Wizard Nav-->--}}
{{--                        <div class="wizard-nav border-bottom">--}}
{{--                            <div class="wizard-steps p-8 p-lg-10">--}}
{{--                                <!--begin::Wizard Step 1 Nav-->--}}
{{--                                <div class="wizard-step" data-wizard-type="step" data-wizard-state="current">--}}
{{--                                    <div class="wizard-label">--}}
{{--                                        <i class="wizard-icon flaticon-information"></i>--}}
{{--                                        <h3 class="wizard-title">1. Primary Information</h3>--}}
{{--                                    </div>--}}
{{--                                    <span class="svg-icon svg-icon-xl wizard-arrow"> {{ Metronic::getSVG("media/svg/icons/Navigation/Arrow-right.svg", "svg-icon-lg svg-icon-primary") }} </span>--}}
{{--                                </div>--}}
{{--                                <!--end::Wizard Step 1 Nav-->--}}

{{--                                <!--begin::Wizard Step 2 Nav-->--}}
{{--                                <div class="wizard-step" data-wizard-type="step">--}}
{{--                                    <div class="wizard-label">--}}
{{--                                        <i class="wizard-icon flaticon-list"></i>--}}
{{--                                        <h3 class="wizard-title">2. Enter Details</h3>--}}
{{--                                    </div>--}}
{{--                                    <span class="svg-icon svg-icon-xl wizard-arrow">--}}
{{--                                        {{ Metronic::getSVG("media/svg/icons/Navigation/Arrow-right.svg", "svg-icon-lg svg-icon-primary") }}--}}
{{--                                    </span>--}}
{{--                                </div>--}}
{{--                                <!--end::Wizard Step 2 Nav-->--}}

{{--                                <!--begin::Wizard Step 3 Nav-->--}}
{{--                                <div class="wizard-step" data-wizard-type="step">--}}
{{--                                    <div class="wizard-label">--}}
{{--                                        <i class="wizard-icon flaticon-responsive"></i>--}}
{{--                                        <h3 class="wizard-title">3. Select Services</h3>--}}
{{--                                    </div>--}}
{{--                                    <span class="svg-icon svg-icon-xl wizard-arrow">--}}
{{--                                        {{ Metronic::getSVG("media/svg/icons/Navigation/Arrow-right.svg", "svg-icon-lg svg-icon-primary") }}--}}
{{--                                    </span>--}}
{{--                                </div>--}}
{{--                                <!--end::Wizard Step 3 Nav-->--}}

{{--                                <!--begin::Wizard Step 4 Nav-->--}}
{{--                                <div class="wizard-step" data-wizard-type="step">--}}
{{--                                    <div class="wizard-label">--}}
{{--                                        <i class="wizard-icon flaticon-truck"></i>--}}
{{--                                        <h3 class="wizard-title">4. Delivery Address</h3>--}}
{{--                                    </div>--}}
{{--                                    <span class="svg-icon svg-icon-xl wizard-arrow">--}}
{{--                                        {{ Metronic::getSVG("media/svg/icons/Navigation/Arrow-right.svg", "svg-icon-lg svg-icon-primary") }}--}}
{{--                                    </span>--}}
{{--                                </div>--}}
{{--                                <!--end::Wizard Step 4 Nav-->--}}

{{--                                <!--begin::Wizard Step 5 Nav-->--}}
{{--                                <div class="wizard-step" data-wizard-type="step">--}}
{{--                                    <div class="wizard-label">--}}
{{--                                        <i class="wizard-icon flaticon-globe"></i>--}}
{{--                                        <h3 class="wizard-title">5. Review and Submit</h3>--}}
{{--                                    </div>--}}
{{--                                    <span class="svg-icon svg-icon-xl wizard-arrow">--}}
{{--                                        {{ Metronic::getSVG("media/svg/icons/Navigation/Arrow-right.svg", "svg-icon-lg svg-icon-primary") }}--}}
{{--                                    </span>--}}
{{--                                </div>--}}
{{--                                <!--end::Wizard Step 5 Nav-->--}}
{{--                            </div>--}}
{{--                        </div>--}}
{{--                        <!--end::Wizard Nav-->--}}

                        <!--begin::Wizard Body-->
@include('layout.error')
                        <div class="row justify-content-center my-10 px-8 my-lg-15 px-lg-10">
                            <div class="col-xl-12 col-xxl-7">
                                <!--begin::Wizard Form-->
                                <form class="form" id="kt_form" action="{{route("manage_employee.addnew_db")}}" method="post">
                                    @csrf
                                    @if(isset($employee->id))<input type="number" name="other" value="{{$employee->id}}" hidden>@endif
                                    <!--begin::Wizard Step 1-->
                                    <div class="pb-5" data-wizard-type="step-content" data-wizard-state="current">
                                        <h3  class="mb-10 font-weight-bold text-dark">প্রাথমিক তথ্যাদি (Primary Information)</h3>
                                        <!--begin::Input-->
                                        <div class="form-group">
                                            <label>কর্মচারীর নাম (বাংলা) [Name of Employee (Bangla)] <i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                                            <input type="text" class="form-control form-control-solid form-control-lg"  @if(isset($loggedin->employee_id) && isset($employee->name))readonly  @else name="name_bn" @endif placeholder="Name (bangla)" required @if(isset($employee->name))value="{{$employee->name}}"@endif style="border: 1px solid rgb(178, 34, 34,.4);"/>
                                        </div>

                                        <div class="form-group">
                                            <label>কর্মচারীর নাম (ইংরেজি ) [Name of Employee (English)] </label>
                                            <input type="text" class="form-control form-control-solid form-control-lg"  @if(isset($loggedin->employee_id) && isset($employee->name_eng))readonly  @else name="name_eng" @endif placeholder="Name (english)"  @if(isset($employee->name_eng))value="{{$employee->name_eng}}"@endif style="border: 1px solid rgb(178, 34, 34,.4);"/>
                                        </div>
                                        <!--end::Input-->
                                        <!--begin::Input-->
                                        <div class="form-group">
                                   
                                            <label>পদবী (Rank) <i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                                            <div >
                                                <select class="form-control " id="kt_select2_1"  @if(isset($loggedin->employee_id) && isset($employee->rank) && (int)$employee->rank > 0) readonly  @else name="rank" @endif required>
                                                    <option value="">নির্বাচন করুন</option>
                                                    
                                                    @foreach($function->rank() as $rank)
                                                    <option value="{{$rank['id']}}" @if(isset($employee->rank) && (int)$employee->rank == (int)$rank['id']) selected @endif>{{$rank['name_en']}}({{$rank['name_bn']}})</option>
                                                    @endforeach

                                                </select>
                                            </div>
                                            <!-- <input type="text" class="form-control form-control-solid form-control-lg" @if(isset($loggedin->employee_id) && isset($employee->rank))readonly  @else name="rank" @endif  placeholder="Rank" required @if(isset($employee->rank))value="{{$employee->rank}}"@endif  style="border: 1px solid rgb(178, 34, 34,.4);"/>
{{--                                            <span class="form-text text-muted">Please enter your Address.</span>--}} -->
                                        </div>
                                        <!--end::Input-->
                                        <!--begin::Input-->
                                        <div class="form-group">
                                            <label>জাতীয় পরিচয় পত্র নম্বর (National ID number) <i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                                            <input type="number" class="form-control form-control-solid form-control-lg" @if(isset($loggedin->employee_id) && isset($employee->nid))readonly  @else name="nid" @endif placeholder="National ID number" required @if(isset($employee->nid))value="{{$employee->nid}}"@endif  style="border: 1px solid rgb(178, 34, 34,.4);"/>
                                            {{--                                            <span class="form-text text-muted">Please enter your Address.</span>--}}
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-form-label text-left col-lg-3 col-sm-12">জন্ম তারিখ (Date of birth)</label>
                                            <div class="col-lg-9 col-md-9 col-sm-12">

                                                    <input  data-date-format="dd-mm-yyyy" readonly class="form-control form-control-lg form-control-solid kt_datepicker" type="text" @if(isset($loggedin->employee_id) && isset($employee->dob)) @else name="dob" @endif @if(isset($employee->dob))value="{{\Carbon\Carbon::parse($employee->dob)->format('d-m-Y')}}"@endif/>


                                            </div>
                                        </div>
                                        {{-- <div class="form-group row">
                                            <label class="col-form-label text-left col-lg-3 col-sm-12">চাকরির ধরন (Service Type)</label>
                                            <div class=" col-lg-9 col-md-9 col-sm-12">
                                                <select class="form-control " id="kt_select2_1"  @if(isset($loggedin->employee_id) && isset($employee->toegs) && (int)$employee->toegs > 0 )readonly  @else name="type_of_entry" @endif   style="border: 1px solid rgb(178, 34, 34,.4);">
                                                    <option value="">নির্বাচন করুন</option>
                                                    <option value="1" @if(isset($employee->toegs) && $employee->toegs == 1){{__('selected')}}@endif>স্থায়ী (Permanent)</option>
                                                    <option value="2" @if(isset($employee->toegs) && $employee->toegs == 2){{__('selected')}}@endif>অস্থায়ী(Temporary)</option>

                                                </select>
                                            </div>
                                        </div> --}}
                                        <div class="form-group row">
                                            <label class="col-xl-3 col-lg-3 col-form-label">চাকরির ধরন (Service Type) <i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                                            <div class="col-lg-9 col-xl-9">
                                                <select class="form-control"  id=""  @if(isset($loggedin->employee_id) && isset($employee->toegs) && (int)$employee->toegs > 0 )readonly  @else name="type_of_entry" @endif   style="border: 1px solid rgb(178, 34, 34,.4);">
                                                    <option value="">নির্বাচন করুন</option>
                                                    <option value="1" @if(isset($employee->toegs) && $employee->toegs == 1){{__('selected')}}@endif>স্থায়ী (Permanent)</option>
                                                    <option value="2" @if(isset($employee->toegs) && $employee->toegs == 2){{__('selected')}}@endif>অস্থায়ী(Temporary)</option>

                                                </select>                        </div>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-xl-3 col-lg-3 col-form-label">কোটার ধরন (Qouta Type) <i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                                            <div class="col-lg-9 col-xl-9">
                                                <select required class="form-control"  id="" @if(isset($loggedin->employee_id) && isset($employee->quota) && (int)$employee->quota > 0 )readonly  @else name="quota" @endif>
                                                    <option value="">নির্বাচন করুন</option>
                                                    @foreach($function->qoutas() as $qouta)
                                                    <option value="{{$qouta['id']}}" @if(isset($employee->quota) && (int)$employee->quota == (int)$qouta['id']) selected @endif>{{$qouta['name_en']}}({{$qouta['name_bn']}})</option>
                                                    @endforeach

                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-form-label text-left col-lg-3 col-sm-12">ইমেইল (Email) <i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                                            <div class="col-lg-9 col-md-9 col-sm-12">
                                                <div class="input-group date" >
                                                    <input name="email" type="email" class="form-control" required @if(isset($employee->user->email))value="{{$employee->user->email}}"@endif  style="border: 1px solid rgb(178, 34, 34,.4);"/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-form-label text-left col-lg-3 col-sm-12">পাসওয়ার্ড (Password)</label>
                                            <div class="col-lg-9 col-md-9 col-sm-12">
                                                <div class="input-group date" >
                                                    <input name="password" type="password" class="form-control"/>
                                                </div>
{{--                                                <span class="form-text text-muted">এই ইমেইল ও পাসওয়ার্ডের মাদ্ধমে কর্মচারী লগইন করতে পারবে। </span>--}}
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-form-label text-left col-lg-3 col-sm-12">মোবাইল নাম্বার (Contact Number) <i class="fa fa-star-of-life fa-sm text-danger"></i></label>
                                            <div class="col-lg-9 col-md-9 col-sm-12">
                                                <div class="input-group date" >
                                                    <input name="sms_number" type="number" class="form-control" min="0" required  @if(isset($employee->sms_number))value="{{$employee->sms_number}}"@endif  style="border: 1px solid rgb(178, 34, 34,.4);" />
                                                </div>
                                                <span class="form-text text-muted">এই নাম্বারে নোটিফিকেশন ও আপডেট পাঠানো হবে। </span>

                                            </div>
                                        </div>
                                        <div>
                                            <button type="submit" class="btn btn-success font-weight-bold text-uppercase px-9 py-4" >
{{--                                                data-wizard-type="action-submit"--}}
                                                Submit and go to details information
                                            </button>
{{--                                            <button type="button" class="btn btn-primary font-weight-bold text-uppercase px-9 py-4" data-wizard-type="action-next">--}}
{{--                                                Next--}}
{{--                                            </button>--}}
                                        </div>
                                    </div>
                                    <!--end::Wizard Actions-->
                                </form>
                                @if(isset($loggedin) && isset($loggedin->employee_id))
                                    @if(!isset($loggedin->email_verified_at) && (\Carbon\Carbon::parse($loggedin->created_at)->diffInMinutes(\Carbon\Carbon::now()) > 15))
                                        <form method="POST" action="{{ route('verification.send') }}">
                                            @csrf
                                            <div>
                                                <button type="submit" class="btn btn-primary mt-3">
                                                    @if(\Carbon\Carbon::parse($loggedin->created_at)->diffInMinutes(\Carbon\Carbon::now()) < 55 )
                                                        {{ __('Resend Verification Email') }}
                                                    @else
                                                        {{ __('Verify Email') }}
                                                    @endif
                                                </button>
                                            </div>
                                        </form>
                                    @endif
                                    @if(!isset($loggedin->mobile_verified_at) && (\Carbon\Carbon::parse($loggedin->expire) < \Carbon\Carbon::now()))
                                        <form method="POST" action="{{ route('number_send_sms') }}">
                                            @csrf
                                            <div>
                                                <button type="submit" class="btn btn-primary mt-3">
                                                    @if(isset($loggedin->expire) && \Carbon\Carbon::parse($loggedin->expire)->diffInMinutes(\Carbon\Carbon::now()) < 10 )
                                                        {{ __('Resend Verification Code') }}
                                                    @else
                                                        {{ __('Verify mobile number') }}
                                                    @endif
                                                </button>
                                                <span>@if(isset($loggedin->expire)) Last verification code expired at {{$loggedin->expire}}@endif</span>
                                            </div>
                                        </form>
                                    @endif
                                @endif
                                @if(isset($loggedin->verification_code) && !isset($loggedin->mobile_verified_at) && (\Carbon\Carbon::now()->diffInMinutes(\Carbon\Carbon::parse($loggedin->expire)) < 5))
                                    <div class="row d-flex mt-10">
                                        <form method="POST" action="{{ route('number_verify') }}" class="d-flex w-100">
                                            @csrf
                                            <div class="col-xl-3 col-md-3">Verify your mobile number : </div>
                                            <input class="form-control col-xl-3" type="number" name="smsverify">
                                            <button type="submit" class="btn btn-primary ml-3">
                                                Verify
                                            </button>
                                        </form>
                                    </div>
                            @endif
                                <!--end::Wizard Form-->
                            </div>
                        </div>
                        <!--end::Wizard Body-->
                    </div>
                    <!--end::Wizard-->
                </div>
                <!--end::Wizard-->
            </div>
        </div>
        <!--end::Container-->
    </div>
    <!--end::Entry-->

@endsection

{{-- Scripts Section --}}
@section('scripts')
    <script type="text/javascript">
        "use strict";

        // Class definition
        var KTWizard1 = function () {
            // Base elements
            var _wizardEl;
            var _formEl;
            var _wizard;
            var _validations = [];

            // Private functions
            var initWizard = function () {
                // Initialize form wizard
                _wizard = new KTWizard(_wizardEl, {
                    startStep: 1, // initial active step number
                    clickableSteps: true  // allow step clicking
                });

                // Validation before going to next page
                _wizard.on('beforeNext', function (wizard) {
                    // Don't go to the next step yet
                    _wizard.stop();

                    // Validate form
                    var validator = _validations[wizard.getStep() - 1]; // get validator for currnt step
                    validator.validate().then(function (status) {
                        if (status == 'Valid') {
                            _wizard.goNext();
                            KTUtil.scrollTop();
                        } else {
                            Swal.fire({
                                text: "Sorry, looks like there are some errors detected, please try again.",
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn font-weight-bold btn-light"
                                }
                            }).then(function () {
                                KTUtil.scrollTop();
                            });
                        }
                    });
                });

                // Change event
                _wizard.on('change', function (wizard) {
                    KTUtil.scrollTop();
                });
            }

            var initValidation = function () {
                // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
                // Step 1
                _validations.push(FormValidation.formValidation(
                    _formEl,
                    {
                        fields: {
                            name_bn: {
                                validators: {
                                    notEmpty: {
                                        message: 'Name is Required'
                                    }
                                }
                            },
                            rank: {
                                validators: {
                                    notEmpty: {
                                        message: 'Rank is required'
                                    }
                                }
                            },
                            nid: {
                                validators: {
                                    notEmpty: {
                                        message: 'National ID number is required'
                                    }
                                }
                            },
                            dob: {
                                validators: {
                                    notEmpty: {
                                        message: 'Date of birth is required'
                                    }
                                }
                            },
                            type_of_entry: {
                                validators: {
                                    notEmpty: {
                                        message: 'Type of entry in govt service is required'
                                    }
                                }
                            }
                        },
                        plugins: {
                            trigger: new FormValidation.plugins.Trigger(),
                            bootstrap: new FormValidation.plugins.Bootstrap()
                        }
                    }
                ));

                // // Step 2
                // _validations.push(FormValidation.formValidation(
                //     _formEl,
                //     {
                //         fields: {
                //             package: {
                //                 validators: {
                //                     notEmpty: {
                //                         message: 'Package details is required'
                //                     }
                //                 }
                //             },
                //             weight: {
                //                 validators: {
                //                     notEmpty: {
                //                         message: 'Package weight is required'
                //                     },
                //                     digits: {
                //                         message: 'The value added is not valid'
                //                     }
                //                 }
                //             },
                //             width: {
                //                 validators: {
                //                     notEmpty: {
                //                         message: 'Package width is required'
                //                     },
                //                     digits: {
                //                         message: 'The value added is not valid'
                //                     }
                //                 }
                //             },
                //             height: {
                //                 validators: {
                //                     notEmpty: {
                //                         message: 'Package height is required'
                //                     },
                //                     digits: {
                //                         message: 'The value added is not valid'
                //                     }
                //                 }
                //             },
                //             packagelength: {
                //                 validators: {
                //                     notEmpty: {
                //                         message: 'Package length is required'
                //                     },
                //                     digits: {
                //                         message: 'The value added is not valid'
                //                     }
                //                 }
                //             }
                //         },
                //         plugins: {
                //             trigger: new FormValidation.plugins.Trigger(),
                //             bootstrap: new FormValidation.plugins.Bootstrap()
                //         }
                //     }
                // ));
                //
                // // Step 3
                // _validations.push(FormValidation.formValidation(
                //     _formEl,
                //     {
                //         fields: {
                //             delivery: {
                //                 validators: {
                //                     notEmpty: {
                //                         message: 'Delivery type is required'
                //                     }
                //                 }
                //             },
                //             packaging: {
                //                 validators: {
                //                     notEmpty: {
                //                         message: 'Packaging type is required'
                //                     }
                //                 }
                //             },
                //             preferreddelivery: {
                //                 validators: {
                //                     notEmpty: {
                //                         message: 'Preferred delivery window is required'
                //                     }
                //                 }
                //             }
                //         },
                //         plugins: {
                //             trigger: new FormValidation.plugins.Trigger(),
                //             bootstrap: new FormValidation.plugins.Bootstrap()
                //         }
                //     }
                // ));
                //
                // // Step 4
                // _validations.push(FormValidation.formValidation(
                //     _formEl,
                //     {
                //         fields: {
                //             locaddress1: {
                //                 validators: {
                //                     notEmpty: {
                //                         message: 'Address is required'
                //                     }
                //                 }
                //             },
                //             locpostcode: {
                //                 validators: {
                //                     notEmpty: {
                //                         message: 'Postcode is required'
                //                     }
                //                 }
                //             },
                //             loccity: {
                //                 validators: {
                //                     notEmpty: {
                //                         message: 'City is required'
                //                     }
                //                 }
                //             },
                //             locstate: {
                //                 validators: {
                //                     notEmpty: {
                //                         message: 'State is required'
                //                     }
                //                 }
                //             },
                //             loccountry: {
                //                 validators: {
                //                     notEmpty: {
                //                         message: 'Country is required'
                //                     }
                //                 }
                //             }
                //         },
                //         plugins: {
                //             trigger: new FormValidation.plugins.Trigger(),
                //             bootstrap: new FormValidation.plugins.Bootstrap()
                //         }
                //     }
                // ));
            }

            return {
                // public functions
                init: function () {
                    _wizardEl = KTUtil.getById('kt_wizard_v1');
                    _formEl = KTUtil.getById('kt_form');

                    initWizard();
                    initValidation();
                }
            };
        }();

        jQuery(document).ready(function () {
            KTWizard1.init();
        });

    </script>
    <script src="{{ asset('js/pages/crud/forms/widgets/bootstrap-datepicker.js') }}"></script>
    <script src="{{ asset('js/pages/crud/forms/widgets/select2.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('.kt_datepicker').datepicker({
                rtl: KTUtil.isRTL(),
                todayHighlight: true,
                orientation: 'bottom left',
                templates: 'arrows'
            });
        });
    </script>

@endsection
