{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
@endsection
{{-- Content --}}
@section('content')
<div class="row">
    <div class="col-lg-6">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        No of employee per rank
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="chart_rank"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
    <div class="col-lg-6">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        Employee % by rank
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="rankpiechart" class="d-flex justify-content-center"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
    <div class="col-lg-6">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        No of employee on Working place
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="current_working_place" class="d-flex justify-content-center"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
    <div class="col-lg-6">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        Employee % by Gender
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="genderpiechart" class="d-flex justify-content-center"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
    <div class="col-lg-6">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        Employee % by Religion
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="regionpiechart" class="d-flex justify-content-center"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
    <div class="col-lg-6">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        Employee % by Marital status
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="marital_status_piechart" class="d-flex justify-content-center"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
    <div class="col-lg-12">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        Employee Service Status ( Joining, Promotion and transfer )
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="service_status" class="d-flex justify-content-center"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
    <div class="col-lg-12">
        <!--begin::Card-->
        <div class="card card-custom gutter-b">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label">
                        Employee PRL, Rest and Recreation
                    </h3>
                </div>
            </div>
            <div class="card-body">
                <!--begin::Chart-->
                <div id="prl_rest" class="d-flex justify-content-center"></div>
                <!--end::Chart-->
            </div>
        </div>
        <!--end::Card-->
    </div>
</div>

@endsection

{{-- Scripts Section --}}
@section('scripts')
    <script>
        "use strict";

        // Shared Colors Definition
        const primary = '#6993FF';
        const success = '#1BC5BD';
        const info = '#8950FC';
        const warning = '#FFA800';
        const danger = '#F64E60';

        // Class definition
        function generateBubbleData(baseval, count, yrange) {
            var i = 0;
            var series = [];
            while (i < count) {
                var x = Math.floor(Math.random() * (750 - 1 + 1)) + 1;;
                var y = Math.floor(Math.random() * (yrange.max - yrange.min + 1)) + yrange.min;
                var z = Math.floor(Math.random() * (75 - 15 + 1)) + 15;

                series.push([x, y, z]);
                baseval += 86400000;
                i++;
            }
            return series;
        }

        function generateData(count, yrange) {
            var i = 0;
            var series = [];
            while (i < count) {
                var x = 'w' + (i + 1).toString();
                var y = Math.floor(Math.random() * (yrange.max - yrange.min + 1)) + yrange.min;

                series.push({
                    x: x,
                    y: y
                });
                i++;
            }
            return series;
        }
        var rank_data = [];
        var rank_category = [];
        @foreach($employees->groupBy('rank') as $key=>$rank)
            @if((int)$key > 0)rank_data.push({{count($rank)}});rank_category.push('{{$function->rank()[$key]['name_bn']}}');@endif
        @endforeach
        var gender_data = [];
        var gender_category = [];
        @foreach($personalinfo->groupBy('gender') as $key=>$group)
            @if((int)$key > 0)gender_data.push({{count($group)}});gender_category.push('{{$function->gender()[$key][0]}}');@endif
        @endforeach
        var region_data = [];
        var region_category = [];
        @foreach($personalinfo->groupBy('region') as $key=>$group)
            @if((int)$key > 0)region_data.push({{count($group)}});region_category.push('{{$function->religion()[$key][0]}}');@endif
        @endforeach
        var marital_status_data = [];
        var marital_status_category = [];
        @foreach($personalinfo->groupBy('marital_status') as $key=>$group)
        @if((int)$key > 0)marital_status_data.push({{count($group)}});marital_status_category.push('{{$function->marital_status()[$key][0]}}');@endif
        @endforeach

        var KTApexChartsDemo = function () {

            var rankchart = function () {

                const apexChart = "#chart_rank";
                var options = {
                    series: [{
                        name: 'Number',
                        data: rank_data
                    }],
                    chart: {
                        type: 'bar',
                        height: 350
                    },
                    plotOptions: {
                        bar: {
                            horizontal: false,
                            columnWidth: '55%',
                            endingShape: 'rounded'
                        },
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        show: true,
                        width: 2,
                        colors: ['transparent']
                    },
                    xaxis: {
                        categories: rank_category,
                    },
                    yaxis: {
                        title: {
                            text: 'Number'
                        }
                    },
                    fill: {
                        opacity: 1
                    },
                    tooltip: {
                        y: {
                            formatter: function (val) {
                                return " " + val + " "
                            }
                        }
                    },
                    colors: [primary, success, warning]
                };

                var chart = new ApexCharts(document.querySelector(apexChart), options);
                chart.render();
            };
            var rankpiechart = function () {
                const apexChart = "#rankpiechart";
                var options = {
                    series: rank_data,
                    chart: {
                        width: 600,
                        type: 'pie',
                    },
                    labels: rank_category,
                    responsive: [{
                        breakpoint: 480,
                        options: {
                            chart: {
                                width: 200
                            },
                            legend: {
                                position: 'bottom'
                            }
                        }
                    }],
                    colors: [primary, success, warning, danger, info]
                };

                var chart = new ApexCharts(document.querySelector(apexChart), options);
                chart.render();
            };
            var genderpiechart = function () {
                const apexChart = "#genderpiechart";
                var options = {
                    series: gender_data,
                    chart: {
                        width: 400,
                        type: 'pie',
                    },
                    labels: gender_category,
                    responsive: [{
                        breakpoint: 480,
                        options: {
                            chart: {
                                width: 200
                            },
                            legend: {
                                position: 'bottom'
                            }
                        }
                    }],
                    colors: [primary, success, warning, danger, info]
                };

                var chart = new ApexCharts(document.querySelector(apexChart), options);
                chart.render();
            };
            var regionpiechart = function () {
                const apexChart = "#regionpiechart";
                var options = {
                    series: region_data,
                    chart: {
                        width: 400,
                        type: 'pie',
                    },
                    labels: region_category,
                    responsive: [{
                        breakpoint: 480,
                        options: {
                            chart: {
                                width: 200
                            },
                            legend: {
                                position: 'bottom'
                            }
                        }
                    }],
                    colors: [primary, success, warning, danger, info]
                };

                var chart = new ApexCharts(document.querySelector(apexChart), options);
                chart.render();
            };
                var marital_status_piechart = function () {
                    const apexChart = "#marital_status_piechart";
                    var options = {
                        series: marital_status_data,
                        chart: {
                            width: 400,
                            type: 'pie',
                        },
                        labels: marital_status_category,
                        responsive: [{
                            breakpoint: 480,
                            options: {
                                chart: {
                                    width: 200
                                },
                                legend: {
                                    position: 'bottom'
                                }
                            }
                        }],
                        colors: [primary, success, warning, danger, info]
                    };

                    var chart = new ApexCharts(document.querySelector(apexChart), options);
                    chart.render();
                };
                var monthspast = [];
                @foreach($monthpast as $month)
                monthspast.push('{{$month}}');
                @endforeach
            var service_status = function () {
                const apexChart = "#service_status";
                var options = {
                    series: [{
                        name: 'First Join',
                        data: [{{implode(',',$firstjoins)}}]
                    },{
                        name: 'Promotions',
                        data: [{{implode(',',$promotions)}}]
                    },{
                        name: 'Transfer',
                        data: [{{implode(',',$transfers)}}]
                    }
                    ],
                    chart: {
                        type: 'bar',
                        height: 350
                    },
                    plotOptions: {
                        bar: {
                            horizontal: false,
                            columnWidth: '55%',
                            endingShape: 'rounded'
                        },
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        show: true,
                        width: 2,
                        colors: ['transparent']
                    },
                    xaxis: {
                        categories:  monthspast,
                    },
                    yaxis: {
                        title: {
                            text: 'Number'
                        }
                    },
                    fill: {
                        opacity: 1
                    },
                    tooltip: {
                        y: {
                            formatter: function (val) {
                                return " " + val + " "
                            }
                        }
                    },
                    colors: [primary, success, warning]
                };

                var chart = new ApexCharts(document.querySelector(apexChart), options);
                chart.render();
            };
            var monthsfuture = [];
            @foreach($monthfuture as $month)
            monthsfuture.push('{{$month}}');
                @endforeach
            var prl_rest = function () {
                const apexChart = "#prl_rest";
                var options = {
                    series: [{
                        name: 'PRL',
                        data: [{{implode(',',$prls)}}]
                    },{
                        name: 'Rest and Recreation',
                        data: [{{implode(',',$rest_recreations)}}]
                    }
                    ],
                    chart: {
                        type: 'bar',
                        height: 350
                    },
                    plotOptions: {
                        bar: {
                            horizontal: false,
                            columnWidth: '55%',
                            endingShape: 'rounded'
                        },
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        show: true,
                        width: 2,
                        colors: ['transparent']
                    },
                    xaxis: {
                        categories:  monthsfuture,
                    },
                    yaxis: {
                        title: {
                            text: 'Number'
                        }
                    },
                    fill: {
                        opacity: 1
                    },
                    tooltip: {
                        y: {
                            formatter: function (val) {
                                return " " + val + " "
                            }
                        }
                    },
                    colors: [primary, success, warning]
                };

                var chart = new ApexCharts(document.querySelector(apexChart), options);
                chart.render();
            };
            var landport = [];
           @php($landportdata=[])
            @foreach($function->name_of_all_landport() as $key=>$name)
            landport.push('{{$name[0]}}');
                @if(isset($employee_on_working_place[$key]))@php(array_push($landportdata,$employee_on_working_place[$key])) @else @php(array_push($landportdata,0))@endif
            @endforeach
            var current_working_place = function () {
                const apexChart = "#current_working_place";
                var options = {
                    series: [{
                        name: 'Employee',
                        data: [{{implode(',',$landportdata)}}]
                    }
                    ],
                    chart: {
                        type: 'bar',
                        height: 350
                    },
                    plotOptions: {
                        bar: {
                            horizontal: false,
                            columnWidth: '55%',
                            endingShape: 'rounded'
                        },
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        show: true,
                        width: 2,
                        colors: ['transparent']
                    },
                    xaxis: {
                        categories:  landport,
                    },
                    yaxis: {
                        title: {
                            text: 'Number'
                        }
                    },
                    fill: {
                        opacity: 1
                    },
                    tooltip: {
                        y: {
                            formatter: function (val) {
                                return " " + val + " "
                            }
                        }
                    },
                    colors: [primary, success, warning]
                };

                var chart = new ApexCharts(document.querySelector(apexChart), options);
                chart.render();
            };
        // Private functions
            return {
                // public functions
                init: function () {
                    rankchart();
                    rankpiechart();
                    genderpiechart();
                    regionpiechart();
                    marital_status_piechart();
                    service_status();
                    prl_rest();
                    current_working_place();
                }
            };
        }();

        jQuery(document).ready(function () {
            KTApexChartsDemo.init();
        });
    </script>
@endsection
