<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddJobPermanentDateToEmployeeFirstJoinings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employee_first_joinings', function (Blueprint $table) {
            $table->date('job_permanent_date')->nullable();
            $table->integer('job_permanent_rank')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employee_first_joinings', function (Blueprint $table) {
            $table->dropColumn('job_permanent_date');
            $table->dropColumn('job_permanent_rank');
        });
    }
}
