<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSanctionAndType extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employee_trainings', function (Blueprint $table) {
            $table->string("sanction_number")->nullable();
            $table->date("sanction_date")->nullable();
            $table->text('course_title')->nullable()->change();
            $table->text('institution')->nullable()->change();
            $table->tinyInteger('travel_type')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employee_trainings', function (Blueprint $table) {
            $table->dropColumn("sanction_number")->nullable();
            $table->dropColumn("sanction_date")->nullable();
            $table->text('course_title')->nullable(false)->change();
            $table->text('institution')->nullable(false)->change();
            $table->dropColumn('travel_type');
        });
    }
}
