<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDistrictInfoToEmployeeFamilyInfo extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employee_family_infos', function (Blueprint $table) {
            $table->dropColumn("home_district");
            $table->unsignedBigInteger("district_id")->nullable();
            $table->foreign('district_id')->references('id')->on('districts')->onDelete('cascade');
            $table->unsignedBigInteger("thana_id")->nullable();
            $table->foreign('thana_id')->references('id')->on('thanas')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employee_family_infos', function (Blueprint $table) {
            //
        });
    }
}
