<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class DropAllColumnAndAddNewColumnToEmployeeLoan extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employee_loans', function (Blueprint $table) {
            $table->dropColumn("house")->nullable();
            $table->dropColumn("computer")->nullable();
            $table->dropColumn("motocycle")->nullable();
            $table->dropColumn("motocar")->nullable();
            $table->dropColumn("bicycle")->nullable();
            $table->string("sanction_number")->nullable();
            $table->date("sanction_date")->nullable();
            $table->double("sanction_amount")->nullable();
            $table->double("depreciation_amount")->nullable();
            $table->integer("sanction_total_no_installment")->nullable();
            $table->date("sanction_installment_starting_date")->nullable();
            $table->integer("sanction_no_installment_paid")->nullable();
            $table->double("sanction_total_interest_amount")->nullable();
            $table->double("sanction_adjusted_amount")->nullable();
            $table->integer("sanction_number_interest_installment")->nullable();
            $table->integer("sanction_number_interest_installment_paid")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employee_loans', function (Blueprint $table) {
            //
        });
    }
}
