<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class DropAllColumnAndAddNewColumnToGpfAdvance extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employee_gpf_advances', function (Blueprint $table) {
            $table->dropColumn("name");
            $table->dropColumn("value_1")->nullable();
            $table->dropColumn("value_2")->nullable();
            $table->dropColumn("value_3")->nullable();
            $table->dropColumn("value_4")->nullable();
            $table->string("sanction_number")->nullable();
            $table->date("sanction_date")->nullable();
            $table->double("sanction_amount")->nullable();
            $table->integer("sanction_total_no_installment")->nullable();
            $table->date("sanction_installment_starting_date")->nullable();
            $table->integer("sanction_no_installment_paid")->nullable();
            $table->double("sanction_total_interest_amount")->nullable();
            $table->double("sanction_adjusted_amount")->nullable();
            $table->integer("sanction_number_interest_installment")->nullable();
            $table->integer("sanction_number_interest_installment_paid")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employee_gpf_advances', function (Blueprint $table) {
            //
        });
    }
}
