<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeaveTypesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('leave_types', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->double('balance');
            $table->boolean('exceed_maximum_limit')->default(0)->nullable();
            $table->boolean('supporting_documents')->default(0)->nullable();
            $table->integer('minimum_days')->default(0)->nullable();
            $table->boolean('carry_forward')->default(0)->nullable();
            $table->unsignedTinyInteger('time_period')->default(1);
            $table->unsignedInteger('time_period_day')->nullable();
            $table->unsignedTinyInteger('user_type')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('leave_types');
    }
}
